/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.statements.Parameter_Assignment;
import org.eclipse.titan.designer.AST.TTCN3.statements.Parameter_Assignments;
import org.eclipse.titan.designer.AST.TTCN3.statements.Parameter_Redirection;
import org.eclipse.titan.designer.AST.TTCN3.statements.Variable_Entries;
import org.eclipse.titan.designer.AST.TTCN3.statements.Variable_Entry;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureFormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureFormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class AssignmentList_Parameter_Redirection
extends Parameter_Redirection {
    private static final String FULLNAMEPART = ".parameterassignments";
    private final Parameter_Assignments assignments;
    private Variable_Entries entries;

    public AssignmentList_Parameter_Redirection(Parameter_Assignments assignments) {
        this.assignments = assignments;
        if (assignments != null) {
            assignments.setFullNameParent(this);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.assignments == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.assignments != null) {
            this.assignments.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.assignments != null) {
            this.assignments.setCodeSection(codeSection);
        }
        if (this.entries != null) {
            this.entries.setCodeSection(codeSection);
        }
    }

    @Override
    public boolean hasDecodedModifier() {
        int size = this.entries.getNofEntries();
        for (int i = 0; i < size; ++i) {
            Variable_Entry entry = this.entries.getEntryByIndex(i);
            if (!entry.isDecoded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkErroneous(CompilationTimeStamp timestamp) {
        HashMap<String, Parameter_Assignment> parameterMap = new HashMap<String, Parameter_Assignment>();
        int size = this.assignments.getNofParameterAssignments();
        for (int i = 0; i < size; ++i) {
            Parameter_Assignment assignment = this.assignments.getParameterAssignmentByIndex(i);
            String name = assignment.getIdentifier().getName();
            if (parameterMap.containsKey(name)) {
                assignment.getLocation().reportSemanticError(MessageFormat.format("Duplicate redirect for parameter `{0}''", assignment.getIdentifier().getDisplayName()));
                Location otherLocation = ((Parameter_Assignment)parameterMap.get(name)).getLocation();
                otherLocation.reportSemanticWarning(MessageFormat.format("A variable entry for parameter `{0}'' is already given here", assignment.getIdentifier().getDisplayName()));
            } else {
                parameterMap.put(name, assignment);
            }
            this.checkVariableReference(timestamp, assignment.getReference(), null);
            Value stringEncoding = assignment.getStringEncoding();
            if (stringEncoding == null) continue;
            stringEncoding.checkStringEncoding(timestamp, null);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp, Signature_Type signature, boolean isOut) {
        String name;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        SignatureFormalParameterList parameterList = signature.getParameterList();
        if (parameterList.getNofParameters() == 0) {
            this.getLocation().reportSemanticError(MessageFormat.format("Parameter redirect cannot be used because signature `{0}'' does not have parameters", signature.getTypename()));
            this.checkErroneous(timestamp);
            return;
        }
        boolean errorFlag = false;
        HashMap<String, Parameter_Assignment> parameterMap = new HashMap<String, Parameter_Assignment>();
        int size = this.assignments.getNofParameterAssignments();
        for (int i = 0; i < size; ++i) {
            Parameter_Assignment assignment = this.assignments.getParameterAssignmentByIndex(i);
            name = assignment.getIdentifier().getName();
            if (parameterMap.containsKey(name)) {
                assignment.getLocation().reportSemanticError(MessageFormat.format("Duplicate redirect for parameter `{0}''", assignment.getIdentifier().getDisplayName()));
                Location otherLocation = ((Parameter_Assignment)parameterMap.get(name)).getLocation();
                otherLocation.reportSemanticWarning(MessageFormat.format("A variable entry for parameter `{0}'' is already given here", assignment.getIdentifier().getDisplayName()));
                errorFlag = true;
            } else {
                parameterMap.put(name, assignment);
            }
            if (parameterList.hasParameterWithName(name)) {
                String message;
                SignatureFormalParameter parameterTemplate = parameterList.getParameterByName(name);
                if (isOut) {
                    if (SignatureFormalParameter.ParamaterDirection.PARAM_IN == parameterTemplate.getDirection()) {
                        message = MessageFormat.format("Parameter `{0}'' of signature `{1}'' has `in'' direction", assignment.getIdentifier().getDisplayName(), signature.getTypename());
                        assignment.getLocation().reportSemanticError(message);
                        errorFlag = true;
                    }
                } else if (SignatureFormalParameter.ParamaterDirection.PARAM_OUT == parameterTemplate.getDirection()) {
                    message = MessageFormat.format("Parameter `{0}'' of signature `{1}'' has `out'' direction", assignment.getIdentifier().getDisplayName(), signature.getTypename());
                    assignment.getLocation().reportSemanticError(message);
                    errorFlag = true;
                }
                if (assignment.isDecoded()) {
                    Value stringEncoding = assignment.getStringEncoding();
                    Type parType = parameterTemplate.getType();
                    IType refdLast = parType.getTypeRefdLast(timestamp);
                    switch (refdLast.getTypetypeTtcn3()) {
                        case TYPE_BITSTRING: 
                        case TYPE_HEXSTRING: 
                        case TYPE_OCTETSTRING: 
                        case TYPE_CHARSTRING: {
                            if (stringEncoding == null) break;
                            stringEncoding.getLocation().reportSemanticError("The encoding format parameter for the '@decoded' modifier is only available to parameter redirects of universal charstrings");
                            errorFlag = true;
                            break;
                        }
                        case TYPE_UCHARSTRING: {
                            if (stringEncoding == null) break;
                            stringEncoding.checkStringEncoding(timestamp, null);
                            break;
                        }
                        default: {
                            assignment.getLocation().reportSemanticError("The '@decoded' modifier is only available to parameter redirects of string types.");
                            errorFlag = true;
                        }
                    }
                    Reference variableReference = assignment.getReference();
                    IType varType = variableReference.checkVariableReference(timestamp);
                    if (errorFlag || varType == null) continue;
                    IType declarationType = varType.getTypeRefdLast(timestamp);
                    assignment.setDeclarationType(declarationType);
                    varType.checkCoding(timestamp, false, variableReference.getMyScope().getModuleScope(), false, variableReference.getLocation());
                    continue;
                }
                this.checkVariableReference(timestamp, assignment.getReference(), parameterTemplate.getType());
                continue;
            }
            assignment.getLocation().reportSemanticError(MessageFormat.format("Signature `{0}'' does not have parameter named `{1}''", signature.getTypename(), assignment.getIdentifier().getDisplayName()));
            errorFlag = true;
            this.checkVariableReference(timestamp, assignment.getReference(), null);
            Value stringEncoding = assignment.getStringEncoding();
            if (stringEncoding == null) continue;
            stringEncoding.checkStringEncoding(timestamp, null);
        }
        if (!errorFlag) {
            this.entries = new Variable_Entries();
            int upperLimit = isOut ? parameterList.getNofOutParameters() : parameterList.getNofInParameters();
            for (int i = 0; i < upperLimit; ++i) {
                SignatureFormalParameter parameter = isOut ? parameterList.getOutParameterByIndex(i) : parameterList.getInParameterByIndex(i);
                name = parameter.getIdentifier().getName();
                if (parameterMap.containsKey(name)) {
                    Parameter_Assignment parAssignment = (Parameter_Assignment)parameterMap.get(name);
                    this.entries.add(new Variable_Entry(parAssignment.getReference(), parAssignment.isDecoded(), parAssignment.getStringEncoding(), parAssignment.getDeclarationType()));
                    continue;
                }
                this.entries.add(new Variable_Entry());
            }
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        this.assignments.updateSyntax(reparser, isDamaged);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.assignments == null) {
            return;
        }
        this.assignments.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.assignments == null || this.assignments.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, ExpressionStruct expression, TemplateInstance matched_ti, String lastGenTIExpression, boolean is_out) {
        this.internalGenerateCode(aData, expression, this.entries, matched_ti, lastGenTIExpression, is_out);
    }

    @Override
    public void generateCodeDecoded(JavaGenData aData, StringBuilder source, TemplateInstance matched_ti, String tempID, boolean is_out) {
        this.internalGenerateCodeDecoded(aData, source, this.entries, matched_ti, tempID, is_out);
    }
}

