/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.StatColumn;

public enum FunctionMetric implements IMetricEnum
{
    NUMBER_OF_PARAMETERS("Number of parameters", "Number of parameters in the function declaration", EnumSet.of(StatColumn.MAX, StatColumn.MEAN, StatColumn.DEV)),
    LINES_OF_CODE("Lines of code", "Number of lines of the function body"),
    CYCLOMATIC_COMPLEXITY("Cyclomatic complexity", "Cyclomatic (or McCabe) complexity of the function"),
    NESTING("Nesting", "Maximal number of nested blocks in the function", EnumSet.of(StatColumn.MAX, StatColumn.MEAN, StatColumn.DEV)),
    RETURN_POINTS("Return points", "Number of return statements (not the exit points in the CFG)", EnumSet.of(StatColumn.MAX, StatColumn.MEAN, StatColumn.DEV)),
    DEFAULT_ACTIVATIONS("Default activations", "Number of possible default branch activations in the function"),
    IN_ENVY("External feature envy", "Number of references to entities inside the module of this function"),
    OUT_ENVY("Internal feature envy", "Number of references to entities outside the module of this function");

    public static final String GROUP_NAME = "Function";
    private String displayName;
    private String hint;
    private Set<StatColumn> requestedStatistics;
    private boolean isInteger;

    private FunctionMetric(String name, String hint) {
        this(name, hint, EnumSet.allOf(StatColumn.class), true);
    }

    private FunctionMetric(String name, String hint, Set<StatColumn> requestedStatistics) {
        this(name, hint, requestedStatistics, true);
    }

    private FunctionMetric(String name, String hint, Set<StatColumn> requestedStatistics, boolean isInteger) {
        this.displayName = name;
        this.hint = hint;
        this.requestedStatistics = requestedStatistics;
        this.isInteger = isInteger;
    }

    @Override
    public String id() {
        return "Function." + this.name();
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    @Override
    public String getHint() {
        return this.hint;
    }

    @Override
    public Set<StatColumn> requestedStatistics() {
        return this.requestedStatistics;
    }

    @Override
    public boolean isInteger() {
        return this.isInteger;
    }

    @Override
    public String groupName() {
        return GROUP_NAME;
    }
}

