/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.utils;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static boolean getBooleanPersistentProperty(IResource resource, String qualifier, String localName) {
        try {
            return "true".equalsIgnoreCase(resource.getPersistentProperty(new QualifiedName(qualifier, localName)));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace("Error while reading persistent property of resource: " + resource.getName(), e);
            return false;
        }
    }

    public static String getPersistentProperty(IResource resource, QualifiedName key) {
        try {
            return resource.getPersistentProperty(key);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace("Error while reading persistent property of resource: " + resource.getName(), e);
            return null;
        }
    }

    public static String getPersistentProperty(IResource resource, String qualifier, String localName) {
        return ResourceUtils.getPersistentProperty(resource, new QualifiedName(qualifier, localName));
    }

    public static boolean setPersistentProperty(IResource resource, String qualifier, String localName, boolean value) {
        return ResourceUtils.setPersistentProperty(resource, qualifier, localName, String.valueOf(value));
    }

    public static boolean setPersistentProperty(IResource resource, QualifiedName key, String value) {
        try {
            resource.setPersistentProperty(key, value);
            return true;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace("Error while setting persistent property of resource: " + resource.getName(), e);
            return false;
        }
    }

    public static boolean setPersistentProperty(IResource resource, String qualifier, String localName, String value) {
        return ResourceUtils.setPersistentProperty(resource, new QualifiedName(qualifier, localName), value);
    }

    public static boolean removePersistentProperty(IResource resource, QualifiedName key) {
        return ResourceUtils.setPersistentProperty(resource, key, null);
    }

    public static void refreshResources(List<? extends IResource> resources) {
        for (IResource iResource : resources) {
            try {
                iResource.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace("Error while refreshing " + iResource.getLocationURI(), e);
            }
        }
    }
}

