/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.log.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.titan.common.utils.StandardCharsets;
import org.eclipse.titan.common.utils.StringUtils;

public class LogFormatter {
    private static final int DEFAULT_INDENTATION_SIZE = 100;
    public static final int TICK_SIZE = 65536;
    private static final int IN_BUFFER_SIZE = 8192;
    private static final int OUT_BUFFER_SIZE = 65536;
    private static final int INDENTATION_SIZE = 4;
    private static final byte[] NEWLINE = StringUtils.lineSeparator().getBytes(StandardCharsets.UTF8);
    private static byte[] indentation;
    private LastTokenTypes lastToken;
    private int indentationLevel;
    private boolean insideString;

    public void format(IProgressMonitor internalMonitor, FileChannel sourceChannel, FileChannel targetChannel) throws IOException {
        long nofProcessedBytes = 0L;
        this.indentationLevel = 0;
        this.insideString = false;
        boolean cancelled = false;
        this.lastToken = LastTokenTypes.OTHER;
        ByteBuffer sourceBuffer = ByteBuffer.allocateDirect(8192);
        ByteBuffer targetBuffer = ByteBuffer.allocate(65536);
        sourceBuffer.clear();
        while (!cancelled && sourceChannel.read(sourceBuffer) != -1) {
            if (internalMonitor.isCanceled()) {
                cancelled = true;
            }
            sourceBuffer.flip();
            this.processBuffer(sourceBuffer, targetBuffer, targetChannel);
            nofProcessedBytes += (long)sourceBuffer.limit();
            sourceBuffer.flip();
            targetBuffer.flip();
            targetChannel.write(targetBuffer);
            targetBuffer.clear();
            if (nofProcessedBytes <= 65536L) continue;
            internalMonitor.worked((int)nofProcessedBytes / 65536);
            nofProcessedBytes %= 65536L;
        }
    }

    private void processBuffer(ByteBuffer source, ByteBuffer targetBuffer, FileChannel targetChannel) throws IOException {
        while (source.hasRemaining()) {
            byte actualByte = source.get();
            if (targetBuffer.remaining() < this.indentationLevel * 4 + 1) {
                targetBuffer.flip();
                targetChannel.write(targetBuffer);
                targetBuffer.clear();
            }
            if (this.insideString) {
                this.processInsideString(source, targetBuffer, actualByte);
                continue;
            }
            this.outsideString(source, targetBuffer, actualByte);
        }
    }

    private void outsideString(ByteBuffer source, ByteBuffer target, byte actualByte) {
        switch (actualByte) {
            case 123: {
                if (this.indentationLevel > 0) {
                    switch (this.lastToken) {
                        case OPEN_BRACE: 
                        case COMMA: {
                            target.put(NEWLINE);
                            this.indent(target, this.indentationLevel);
                            break;
                        }
                        default: {
                            target.put((byte)32);
                        }
                    }
                }
                target.put(actualByte);
                ++this.indentationLevel;
                this.lastToken = LastTokenTypes.OPEN_BRACE;
                break;
            }
            case 125: {
                if (this.indentationLevel > 0) {
                    --this.indentationLevel;
                    if (LastTokenTypes.OPEN_BRACE.equals((Object)this.lastToken)) {
                        target.put((byte)32);
                    } else {
                        target.put(NEWLINE);
                        this.indent(target, this.indentationLevel);
                    }
                    this.lastToken = LastTokenTypes.CLOSE_BRACE;
                }
                target.put(actualByte);
                break;
            }
            case 44: {
                target.put(actualByte);
                if (this.indentationLevel <= 0) break;
                this.lastToken = LastTokenTypes.COMMA;
                break;
            }
            case 34: {
                target.put(actualByte);
                this.insideString = true;
                break;
            }
            case 9: 
            case 32: {
                if (this.indentationLevel > 0) {
                    if (!LastTokenTypes.OTHER.equals((Object)this.lastToken)) break;
                    this.lastToken = LastTokenTypes.WHITE_SPACE;
                    break;
                }
                target.put(actualByte);
                break;
            }
            case 10: {
                if (this.indentationLevel > 0) {
                    if (!LastTokenTypes.OTHER.equals((Object)this.lastToken)) break;
                    this.lastToken = LastTokenTypes.WHITE_SPACE;
                    break;
                }
                target.put(NEWLINE);
                break;
            }
            case 13: {
                if (source.remaining() > 0) {
                    byte temp2 = source.get();
                    if (10 == temp2) {
                        if (this.indentationLevel > 0) {
                            if (!LastTokenTypes.OTHER.equals((Object)this.lastToken)) break;
                            this.lastToken = LastTokenTypes.WHITE_SPACE;
                            break;
                        }
                        target.put(NEWLINE);
                        break;
                    }
                    target.put(NEWLINE);
                    break;
                }
                target.put(actualByte);
                break;
            }
            default: {
                if (this.indentationLevel > 0) {
                    switch (this.lastToken) {
                        case OPEN_BRACE: 
                        case COMMA: {
                            target.put(NEWLINE);
                            this.indent(target, this.indentationLevel);
                            break;
                        }
                        case CLOSE_BRACE: 
                        case WHITE_SPACE: {
                            target.put((byte)32);
                            break;
                        }
                    }
                    this.lastToken = LastTokenTypes.OTHER;
                }
                target.put(actualByte);
            }
        }
    }

    private void processInsideString(ByteBuffer source, ByteBuffer target, byte actualByte) {
        target.put(actualByte);
        switch (actualByte) {
            case 34: {
                this.insideString = false;
                break;
            }
            case 92: {
                if (!source.hasRemaining()) break;
                byte temp = source.get();
                target.put(temp);
                break;
            }
        }
    }

    private void indent(ByteBuffer target, int amount) {
        int temp = amount * 4;
        if (temp > indentation.length) {
            LogFormatter.resizeIndentation(temp);
        }
        target.put(indentation, 0, temp);
    }

    private static void resizeIndentation(int newSize) {
        indentation = new byte[newSize];
        for (int i = 0; i < newSize; ++i) {
            LogFormatter.indentation[i] = 32;
        }
    }

    static {
        LogFormatter.resizeIndentation(100);
    }

    private static enum LastTokenTypes {
        OPEN_BRACE,
        CLOSE_BRACE,
        COMMA,
        WHITE_SPACE,
        OTHER;

    }
}

