/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.details;

import java.util.ArrayDeque;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.titan.log.viewer.console.TITANDebugConsole;
import org.eclipse.titan.log.viewer.views.details.DetailData;
import org.eclipse.titan.log.viewer.views.details.TreeObject;
import org.eclipse.titan.log.viewer.views.details.TreeParent;
import org.eclipse.ui.IViewSite;

public class DetailsViewContentProvider
implements ITreeContentProvider {
    private TreeParent invisibleRoot;
    private String value = "";
    private String sourceInfo = "";

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (newInput == null || oldInput == null) {
            this.value = "";
            this.buildTreeModel2();
            v.refresh();
            return;
        }
        DetailData oI = (DetailData)oldInput;
        DetailData nI = (DetailData)newInput;
        this.sourceInfo = nI.getSourceInfo();
        String oldValue = oI.getLine();
        String newValue = nI.getLine();
        if (newValue == null) {
            TITANDebugConsole.getConsole().newMessageStream().println("c");
            this.value = "";
            this.buildTreeModel2();
            v.refresh();
            return;
        }
        if (oldValue == null) {
            oldValue = "";
        }
        this.value = newValue.length() >= 2 && newValue.startsWith(": ") ? newValue.substring(2) : newValue;
        String name = nI.getName();
        String port = nI.getPort();
        if (port != null && !port.trim().isEmpty()) {
            this.buildTreeModel(name + '(' + port + ')');
        } else {
            this.buildTreeModel(name);
        }
        v.refresh();
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof IViewSite) {
            return this.getChildren(this.invisibleRoot);
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof TreeObject) {
            return ((TreeObject)child).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof TreeParent) {
            return ((TreeParent)parent).getChildren();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        return parent instanceof TreeParent && ((TreeParent)parent).hasChildren();
    }

    private void buildTreeModel(String namePort) {
        String logString = this.value;
        StringTokenizer tokenizer = new StringTokenizer(logString, "{},", true);
        ArrayDeque<TreeParent> parentStack = new ArrayDeque<TreeParent>();
        TreeParent root = new TreeParent(namePort);
        this.addSourceInfo(root);
        if (!logString.startsWith("{")) {
            root.addChild(new TreeObject(logString.trim()));
        } else {
            String prev = "";
            String token = "";
            while (tokenizer.hasMoreTokens()) {
                prev = token;
                token = tokenizer.nextToken().trim();
                if (",".equals(token) || "".equals(token)) continue;
                if ("{".equals(token)) {
                    if (prev.endsWith(":=")) {
                        String parentName = prev.substring(0, prev.indexOf(32));
                        parentStack.push(new TreeParent(parentName));
                        continue;
                    }
                    parentStack.push(new TreeParent(""));
                    continue;
                }
                if (token.endsWith("}")) {
                    if (parentStack.isEmpty()) continue;
                    TreeParent tmpParent = (TreeParent)parentStack.peek();
                    parentStack.pop();
                    if (!parentStack.isEmpty()) {
                        ((TreeParent)parentStack.peek()).addChild(tmpParent);
                        continue;
                    }
                    root.addChild(tmpParent);
                    continue;
                }
                if (token.endsWith(":=")) continue;
                if (!parentStack.isEmpty()) {
                    ((TreeParent)parentStack.peek()).addChild(new TreeObject(token));
                    continue;
                }
                root.addChild(new TreeObject(token));
            }
        }
        this.invisibleRoot = new TreeParent("");
        this.invisibleRoot.addChild(root);
        parentStack.clear();
    }

    private void addSourceInfo(TreeParent root) {
        if (this.sourceInfo != null && this.sourceInfo.trim().length() > 0) {
            root.addChild(new TreeObject("sourceInfo := " + this.sourceInfo));
        } else {
            root.addChild(new TreeObject("<SourceInfoFormat:=Single>"));
        }
    }

    private void buildTreeModel2() {
        this.invisibleRoot = new TreeParent("");
    }
}

