/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcnppeditor.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.declarationsearch.IdentifierFinderVisitor;
import org.eclipse.titan.designer.editors.actions.OpenDeclarationBase;
import org.eclipse.titan.designer.editors.ttcnppeditor.TTCNPPEditor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;

public final class OpenDeclaration
extends OpenDeclarationBase {
    public static final String TTCNPPEDITOR = "TTCNPP";

    private void selectAndRevealDeclaration(Location location) {
        this.selectAndRevealDeclaration(location, TTCNPPEDITOR);
    }

    @Override
    protected final void doOpenDeclaration() {
        int offset;
        if (this.targetEditor == null || !(this.targetEditor instanceof TTCNPPEditor)) {
            return;
        }
        if (!this.check()) {
            return;
        }
        IFile file = (IFile)this.targetEditor.getEditorInput().getAdapter(IFile.class);
        IPreferencesService prefs = Platform.getPreferencesService();
        boolean reportDebugInformation = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
        if (!this.selection.isEmpty() && this.selection instanceof TextSelection && !"".equals(((TextSelection)this.selection).getText())) {
            if (reportDebugInformation) {
                TITANDebugConsole.println("text selected: " + ((TextSelection)this.selection).getText());
            }
            TextSelection tSelection = (TextSelection)this.selection;
            offset = tSelection.getOffset() + tSelection.getLength();
        } else {
            offset = ((TTCNPPEditor)this.targetEditor).getCarretOffset();
        }
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        Module module = projectSourceParser.containedModule(file);
        if (module == null) {
            if (reportDebugInformation) {
                TITANDebugConsole.println("Cannot find the module.");
            }
            return;
        }
        IdentifierFinderVisitor visitor = new IdentifierFinderVisitor(offset);
        module.accept(visitor);
        Declaration decl = visitor.getReferencedDeclaration();
        if (decl == null) {
            if (reportDebugInformation) {
                TITANDebugConsole.println("No visible elements found.");
            }
            return;
        }
        this.selectAndRevealDeclaration(decl.getIdentifier().getLocation());
    }
}

