/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.declarationsearch.IdentifierFinderVisitor;
import org.eclipse.titan.designer.editors.IEditorWithCarretOffset;
import org.eclipse.titan.designer.editors.asn1editor.ASN1Editor;
import org.eclipse.titan.designer.editors.controls.PeekSource;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverInfoControl;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.editors.ttcnppeditor.TTCNPPEditor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class PeekDeclaration
extends AbstractHandler
implements IEditorActionDelegate {
    public void run(IAction action) {
        this.peekDefinition();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.peekDefinition();
        return null;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    private void peekDefinition() {
        int offset;
        IEditorPart targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        ITextSelection selection = TextSelection.emptySelection();
        if (targetEditor == null || !(targetEditor instanceof TTCN3Editor) && !(targetEditor instanceof TTCNPPEditor) && !(targetEditor instanceof ASN1Editor)) {
            return;
        }
        IFile file = (IFile)targetEditor.getEditorInput().getAdapter(IFile.class);
        if (selection instanceof TextSelection && !selection.isEmpty() && !((TextSelection)selection).getText().isEmpty()) {
            TextSelection tSelection = (TextSelection)selection;
            offset = tSelection.getOffset() + tSelection.getLength();
        } else {
            offset = ((IEditorWithCarretOffset)targetEditor).getCarretOffset();
        }
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        Module module = projectSourceParser.containedModule(file);
        if (module == null) {
            return;
        }
        IdentifierFinderVisitor visitor = new IdentifierFinderVisitor(offset);
        module.accept(visitor);
        Declaration decl = visitor.getReferencedDeclaration();
        if (decl == null) {
            return;
        }
        Shell shell = targetEditor.getSite().getShell();
        Ttcn3HoverInfoControl con = new Ttcn3HoverInfoControl(shell, null);
        Control control = (Control)targetEditor.getAdapter(Control.class);
        if (control instanceof StyledText) {
            StyledText text = (StyledText)control;
            Point caretLocation = text.getLocationAtOffset(text.getCaretOffset());
            Point displayLocation = text.toDisplay(caretLocation);
            Font textFont = JFaceResources.getTextFont();
            FontData[] fontData = textFont.getFontData();
            displayLocation.y += fontData[0].getHeight() * 2;
            con.setLocation(displayLocation);
        }
        Ttcn3HoverContent content = new Ttcn3HoverContent();
        PeekSource.addStyledSource(PeekSource.getPeekSource(targetEditor, decl.getLocation()), content);
        con.setInput(content, true);
        con.setVisible(true);
        con.setFocus();
    }
}

