/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;

public final class TITANBuilderResourceVisitor
implements IResourceVisitor {
    private static final String TRUE = "true";
    private String resourcename;
    private final IContainer[] workingDirectories;
    private final List<IPath> excludedFolders = new ArrayList<IPath>();
    private final List<URI> centralStorages = new ArrayList<URI>();
    private final Map<String, IFile> centralStorageFiles = new HashMap<String, IFile>();
    private final Map<String, IFile> excludedFiles = new HashMap<String, IFile>();
    private final Map<String, IFile> files = new HashMap<String, IFile>();
    private final ResourceExclusionHelper helper;

    public TITANBuilderResourceVisitor(IContainer[] workingDirectories) {
        this.workingDirectories = workingDirectories;
        this.helper = new ResourceExclusionHelper();
    }

    public Map<String, IFile> getFiles() {
        return this.files;
    }

    public Map<String, IFile> getExcludedFiles() {
        return this.excludedFiles;
    }

    public Map<String, IFile> getCentralStorageFiles() {
        return this.centralStorageFiles;
    }

    public boolean visit(IResource resource) {
        if (resource == null || !resource.isAccessible()) {
            return false;
        }
        URI resourceLocation = resource.getLocationURI();
        this.resourcename = resource.getName();
        if (this.resourcename == null || this.resourcename.startsWith(".")) {
            return false;
        }
        try {
            URI resolved = resource.getWorkspace().getPathVariableManager().resolveURI(resourceLocation);
            IFileStore store = EFS.getStore((URI)resolved);
            IFileInfo fileInfo = store.fetchInfo();
            if (!fileInfo.exists()) {
                ErrorReporter.logError((String)("The resource `" + resource.getFullPath() + "' points to a non-existing location."));
                return false;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        switch (resource.getType()) {
            case 1: {
                if (!ResourceExclusionHelper.isDirectlyExcluded((IFile)resource) && !this.helper.isExcludedByRegexp(this.resourcename)) {
                    boolean inExcluded = false;
                    IPath resourceFullPath = resource.getFullPath();
                    for (int i = 0; i < this.excludedFolders.size(); ++i) {
                        IPath excludedFolder = this.excludedFolders.get(i);
                        if (!excludedFolder.isPrefixOf(resourceFullPath)) continue;
                        inExcluded = true;
                        break;
                    }
                    IFile file = (IFile)resource;
                    if (inExcluded) {
                        this.excludedFiles.put(resource.getName(), file);
                        return false;
                    }
                    boolean inCentralStorage = false;
                    for (int i = 0; i < this.centralStorages.size(); ++i) {
                        URI centralFolder = this.centralStorages.get(i);
                        if (centralFolder.getHost() != resourceLocation.getHost() || !resourceLocation.getPath().startsWith(centralFolder.getPath())) continue;
                        inCentralStorage = true;
                        break;
                    }
                    file = (IFile)resource;
                    if (inCentralStorage) {
                        if (file.getLocation() == null) {
                            this.centralStorageFiles.put(file.getName(), file);
                        } else {
                            this.centralStorageFiles.put(file.getLocation().toOSString(), file);
                        }
                    } else {
                        this.files.put(this.resourcename, file);
                    }
                } else if (resourceLocation != null) {
                    this.excludedFiles.put(resource.getName(), (IFile)resource);
                }
                return false;
            }
            case 2: {
                for (IContainer workingDirectory : this.workingDirectories) {
                    if (!workingDirectory.equals(resource)) continue;
                    return false;
                }
                try {
                    if (ResourceExclusionHelper.isDirectlyExcluded((IFolder)resource) || this.helper.isExcludedByRegexp(this.resourcename)) {
                        this.excludedFolders.add(resource.getFullPath());
                    }
                    if (!TRUE.equals(resource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "centralStorage")))) break;
                    this.centralStorages.add(resourceLocation);
                    break;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }
        return true;
    }
}

