/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Constructor;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ClassConstructorExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ComponentCreateExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class UndefCreateExpression
extends Expression_Value {
    private static final String FIRSTOPERANDERROR = "The first operand of operation `create()' should be a charstring value";
    private static final String SECONDOPERANDERROR = "The second operand of operation `create()' should be a charstring value";
    private static final String COMPONENTEXPECTED = "Operation `create'' should refer to a component type instead of {0}";
    private static final String TYPEMISMATCH1 = "Type mismatch: reference to a component type was expected in operation `create'' instead of `{0}''";
    private static final String TYPEMISMATCH2 = "Incompatible component type: operation `create'' should refer to `{0}'' instead of `{1}''";
    private static final String TRAITINSTANTIATED = "A trait class cannot be instantiated";
    private static final String ABSTRACTINSTANTIATED = "An abstract class cannot be instantiated";
    private static final String OPERATIONNAME = "create()";
    private final Reference componentReference;
    private final Value name;
    private final Value location;
    private final boolean isAlive;
    private final ParsedActualParameters parameters;
    private Expression_Value realExpression;
    private CompilationTimeStamp checkCreateTimestamp;
    private Type checkCreateCache;

    public UndefCreateExpression(Reference reference, Value name, Value location, boolean isAlive, ParsedActualParameters parameters) {
        this.componentReference = reference;
        this.name = name;
        this.location = location;
        this.isAlive = isAlive;
        this.parameters = parameters;
        if (reference != null) {
            reference.setFullNameParent(this);
        }
        if (name != null) {
            name.setFullNameParent(this);
        }
        if (location != null) {
            location.setFullNameParent(this);
        }
    }

    public UndefCreateExpression(Reference reference, Value name, Value location, boolean isAlive) {
        this(reference, name, location, isAlive, null);
    }

    public UndefCreateExpression(Reference reference, ParsedActualParameters parameters) {
        this(reference, null, null, false, parameters);
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.UNDEFINED_CREATE_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return false;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.componentReference != null) {
            this.componentReference.setMyScope(scope);
        }
        if (this.name != null) {
            this.name.setMyScope(scope);
        }
        if (this.location != null) {
            this.location.setMyScope(scope);
        }
        if (this.parameters != null) {
            this.parameters.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.componentReference != null) {
            this.componentReference.setCodeSection(codeSection);
        }
        if (this.name != null) {
            this.name.setCodeSection(codeSection);
        }
        if (this.location != null) {
            this.location.setCodeSection(codeSection);
        }
        if (this.realExpression != null) {
            this.realExpression.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.componentReference == child) {
            return builder.append(".<operand1>");
        }
        if (this.name == child) {
            return builder.append(".<operand2>");
        }
        if (this.location == child) {
            return builder.append(".<operand3>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.realExpression != null) {
            return this.realExpression.getExpressionReturntype(timestamp, expectedValue);
        }
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    @Override
    public Type getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return this.checkCreate(timestamp);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        this.setIsErroneous(false);
        this.checkCreate(timestamp);
        if (this.componentReference == null) {
            return;
        }
        Assignment assignment = this.componentReference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            this.setIsErroneous(true);
            return;
        }
        IType assignmentType = assignment.getType(timestamp);
        if (assignmentType instanceof Component_Type) {
            IType.Type_type typeType;
            IValue last;
            if (this.name != null) {
                last = this.name.setLoweridToReference(timestamp);
                typeType = last.getExpressionReturntype(timestamp, expectedValue);
                if (!last.getIsErroneous(timestamp)) {
                    switch (typeType) {
                        case TYPE_CHARSTRING: {
                            last.getValueRefdLast(timestamp, referenceChain);
                            break;
                        }
                        case TYPE_UNDEFINED: {
                            break;
                        }
                        default: {
                            this.name.getLocation().reportSemanticError(FIRSTOPERANDERROR);
                            this.setIsErroneous(true);
                        }
                    }
                }
            }
            if (this.location != null) {
                last = this.location.setLoweridToReference(timestamp);
                typeType = last.getExpressionReturntype(timestamp, expectedValue);
                if (!last.getIsErroneous(timestamp)) {
                    switch (typeType) {
                        case TYPE_CHARSTRING: {
                            last.getValueRefdLast(timestamp, referenceChain);
                            break;
                        }
                        case TYPE_UNDEFINED: {
                            break;
                        }
                        default: {
                            this.name.getLocation().reportSemanticError(SECONDOPERANDERROR);
                            this.setIsErroneous(true);
                        }
                    }
                }
            }
            this.realExpression = new ComponentCreateExpression(this.componentReference, this.name, this.location, this.isAlive);
            this.realExpression.setMyScope(this.getMyScope());
            this.realExpression.setFullNameParent(this);
            this.realExpression.setLocation(this.getLocation());
            this.realExpression.evaluateValue(timestamp, expectedValue, referenceChain);
            this.checkExpressionDynamicPart(expectedValue, OPERATIONNAME, false, true, false);
        } else if (assignmentType instanceof Class_Type) {
            Class_Type classInstance = (Class_Type)assignmentType;
            if (classInstance.isTrait()) {
                this.getLocation().reportSemanticError(TRAITINSTANTIATED);
                this.setIsErroneous(true);
            }
            if (classInstance.isAbstract()) {
                this.getLocation().reportSemanticError(ABSTRACTINSTANTIATED);
                this.setIsErroneous(true);
            }
            this.realExpression = new ClassConstructorExpression(this.componentReference, this.parameters);
            this.realExpression.setMyScope(this.getMyScope());
            this.realExpression.setFullNameParent(this);
            this.realExpression.setLocation(this.getLocation());
            this.realExpression.evaluateValue(timestamp, expectedValue, referenceChain);
            ActualParameterList tempActualParameters = new ActualParameterList();
            Assignment constructorAssignment = classInstance.getClassType().getClassTypeBody().getAssByIdentifier(timestamp, new Identifier(Identifier.Identifier_type.ID_TTCN, "create"));
            if (constructorAssignment instanceof Def_Constructor) {
                FormalParameterList fpList = ((Def_Constructor)constructorAssignment).getFormalParameterList();
                fpList.checkActualParameterList(timestamp, this.parameters, tempActualParameters);
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.componentReference == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        this.checkCreate(timestamp);
        return this.lastValue;
    }

    private Type checkCreate(CompilationTimeStamp timestamp) {
        IType last;
        if (this.checkCreateTimestamp != null && !this.checkCreateTimestamp.isLess(timestamp)) {
            return this.checkCreateCache;
        }
        this.checkCreateTimestamp = timestamp;
        this.checkCreateCache = null;
        Assignment assignment = this.componentReference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            this.setIsErroneous(true);
            return null;
        }
        if (!Assignment.Assignment_type.A_TYPE.semanticallyEquals(assignment.getAssignmentType())) {
            this.componentReference.getLocation().reportSemanticError(MessageFormat.format(COMPONENTEXPECTED, assignment.getDescription()));
            this.setIsErroneous(true);
            return null;
        }
        IType type = ((Def_Type)assignment).getType(timestamp).getFieldType(timestamp, this.componentReference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
        if (type == null) {
            this.setIsErroneous(true);
            return null;
        }
        boolean isComponent = true;
        IType assignmentType = assignment.getType(timestamp);
        if (assignmentType instanceof Component_Type) {
            isComponent = true;
        } else if (assignmentType instanceof Class_Type) {
            isComponent = false;
        } else if (!IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) {
            this.componentReference.getLocation().reportSemanticError(MessageFormat.format(TYPEMISMATCH1, type.getTypename()));
            this.setIsErroneous(true);
            return null;
        }
        if (this.myGovernor != null && IType.Type_type.TYPE_COMPONENT.equals((Object)(last = this.myGovernor.getTypeRefdLast(timestamp)).getTypetype()) && !last.isCompatible(timestamp, type, null, null, null)) {
            this.componentReference.getLocation().reportSemanticError(MessageFormat.format(TYPEMISMATCH2, last.getTypename(), type.getTypename()));
            this.setIsErroneous(true);
            return null;
        }
        this.checkCreateCache = isComponent ? (Component_Type)type : (Class_Type)type;
        return this.checkCreateCache;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.componentReference != null) {
            this.componentReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.componentReference.getLocation());
        }
        if (this.name != null) {
            this.name.updateSyntax(reparser, false);
            reparser.updateLocation(this.name.getLocation());
        }
        if (this.location != null) {
            this.location.updateSyntax(reparser, false);
            reparser.updateLocation(this.location.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.componentReference != null) {
            this.componentReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.name != null) {
            this.name.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.location != null) {
            this.location.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.componentReference != null && !this.componentReference.accept(v)) {
            return false;
        }
        if (this.name != null && !this.name.accept(v)) {
            return false;
        }
        return this.location == null || this.location.accept(v);
    }

    @Override
    public boolean returnsNative() {
        if (this.realExpression != null && this.realExpression != this) {
            return this.realExpression.returnsNative();
        }
        return false;
    }

    @Override
    public StringBuilder generateSingleExpression(JavaGenData aData) {
        if (this.realExpression != null) {
            return this.realExpression.generateSingleExpression(aData);
        }
        return new StringBuilder();
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        if (this.realExpression != null) {
            this.realExpression.generateCodeExpressionExpression(aData, expression);
        }
    }

    @Override
    public String createStringRepresentation() {
        return null;
    }
}

