/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.IAppendableSyntax;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.SkeletonTemplateProposal;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Keywords;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class For_Loop_Definitions
extends Assignments
implements ILocateableNode,
IIncrementallyUpdateable {
    private final List<Definition> definitions = new CopyOnWriteArrayList<Definition>();
    private Location location;
    private HashMap<String, Definition> definitionMap;
    private CompilationTimeStamp lastCompilationTimeStamp;
    private CompilationTimeStamp lastUniquenessCheckTimeStamp;

    public For_Loop_Definitions() {
        this.scopeName = "definitions";
        this.location = NULL_Location.INSTANCE;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (Definition definition : this.definitions) {
            if (definition != child) continue;
            Identifier identifier = definition.getIdentifier();
            return builder.append(".").append(identifier.getDisplayName());
        }
        return builder;
    }

    @Override
    public int getNofAssignments() {
        return this.definitions.size();
    }

    @Override
    public Definition getAssignmentByIndex(int i) {
        return this.definitions.get(i);
    }

    @Override
    public Object[] getOutlineChildren() {
        ArrayList<Definition> outlineDefinitions = new ArrayList<Definition>();
        outlineDefinitions.addAll(this.definitions);
        Collections.sort(outlineDefinitions, new Comparator<IOutlineElement>(){

            @Override
            public int compare(IOutlineElement o1, IOutlineElement o2) {
                Location l1 = o1.getIdentifier().getLocation();
                Location l2 = o2.getIdentifier().getLocation();
                if (l1.getOffset() < l2.getOffset()) {
                    return -1;
                }
                if (l1.getOffset() > l2.getOffset()) {
                    return 1;
                }
                return 0;
            }
        });
        return outlineDefinitions.toArray();
    }

    @Override
    public String getOutlineIcon() {
        return "ttcn.gif";
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    public void addDefinitions(List<Definition> definitionList) {
        if (definitionList != null) {
            ArrayList<Definition> safeToAdd = new ArrayList<Definition>(definitionList.size());
            for (Definition definition : definitionList) {
                if (definition == null || definition.getIdentifier() == null || definition.getIdentifier().getLocation() == null) continue;
                definition.setMyScope(this);
                safeToAdd.add(definition);
                definition.setFullNameParent(this);
            }
            this.definitions.addAll(safeToAdd);
        }
    }

    protected void checkUniqueness(CompilationTimeStamp timestamp) {
        if (this.lastUniquenessCheckTimeStamp != null && !this.lastUniquenessCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        this.lastUniquenessCheckTimeStamp = timestamp;
        if (this.definitionMap == null) {
            this.definitionMap = new HashMap(this.definitions.size());
        }
        this.definitionMap.clear();
        for (Definition definition : this.definitions) {
            Identifier identifier = definition.getIdentifier();
            String definitionName = identifier.getName();
            if (this.definitionMap.containsKey(definitionName)) {
                Location otherLocation = this.definitionMap.get(definitionName).getIdentifier().getLocation();
                otherLocation.reportSingularSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was first declared here", identifier.getDisplayName()));
                identifier.getLocation().reportSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was declared here again", identifier.getDisplayName()));
                continue;
            }
            this.definitionMap.put(definitionName, definition);
            if (this.parentScope == null || definition.getLocation() == null) continue;
            if (this.parentScope.hasAssignmentWithId(timestamp, identifier)) {
                definition.getLocation().reportSemanticError(MessageFormat.format("Definition with identifier `{0}'' is not unique in the scope hierarchy", identifier.getDisplayName()));
                ArrayList<ISubReference> subReferences = new ArrayList<ISubReference>();
                subReferences.add(new FieldSubReference(identifier));
                Reference reference = new Reference(null, subReferences);
                Assignment assignment = this.parentScope.getAssBySRef(timestamp, reference);
                if (assignment == null || assignment.getLocation() == null) continue;
                assignment.getLocation().reportSingularSemanticError(MessageFormat.format("Previous definition with identifier `{0}'' in higher scope unit is here", identifier.getDisplayName()));
                continue;
            }
            if (!this.parentScope.isValidModuleId(identifier)) continue;
            definition.getLocation().reportSemanticWarning(MessageFormat.format("Definition with name `{0}'' hides a module identifier", identifier.getDisplayName()));
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastCompilationTimeStamp != null && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        this.lastCompilationTimeStamp = timestamp;
        this.lastUniquenessCheckTimeStamp = timestamp;
        if (this.definitionMap == null) {
            this.definitionMap = new HashMap(this.definitions.size());
        }
        this.definitionMap.clear();
        for (Definition definition : this.definitions) {
            Identifier identifier = definition.getIdentifier();
            String definitionName = identifier.getName();
            if (this.definitionMap.containsKey(definitionName)) {
                Location otherLocation = this.definitionMap.get(definitionName).getIdentifier().getLocation();
                otherLocation.reportSingularSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was first declared here", identifier.getDisplayName()));
                identifier.getLocation().reportSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was declared here again", identifier.getDisplayName()));
            } else {
                this.definitionMap.put(definitionName, definition);
                if (this.parentScope != null && definition.getLocation() != null) {
                    if (this.parentScope.hasAssignmentWithId(timestamp, identifier)) {
                        definition.getLocation().reportSemanticError(MessageFormat.format("Definition with identifier `{0}'' is not unique in the scope hierarchy", identifier.getDisplayName()));
                        ArrayList<ISubReference> subReferences = new ArrayList<ISubReference>();
                        subReferences.add(new FieldSubReference(identifier));
                        Reference reference = new Reference(null, subReferences);
                        Assignment assignment = this.parentScope.getAssBySRef(timestamp, reference);
                        if (assignment != null && assignment.getLocation() != null) {
                            assignment.getLocation().reportSingularSemanticError(MessageFormat.format("Previous definition with identifier `{0}'' in higher scope unit is here", identifier.getDisplayName()));
                        }
                    } else if (this.parentScope.isValidModuleId(identifier)) {
                        definition.getLocation().reportSemanticWarning(MessageFormat.format("Definition with name `{0}'' hides a module identifier", identifier.getDisplayName()));
                    }
                }
            }
            definition.check(timestamp);
        }
    }

    @Override
    public void postCheck() {
        for (Definition definition : this.definitions) {
            definition.postCheck();
        }
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference) {
        return this.getAssBySRef(timestamp, reference, null);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference, IReferenceChain refChain) {
        Definition result;
        if (reference.getModuleIdentifier() != null) {
            return this.getModuleScope().getAssBySRef(timestamp, reference);
        }
        Identifier identifier = reference.getId();
        if (identifier == null) {
            return this.getModuleScope().getAssBySRef(timestamp, reference);
        }
        if (this.lastUniquenessCheckTimeStamp == null) {
            this.checkUniqueness(timestamp);
        }
        if ((result = this.definitionMap.get(identifier.getName())) != null) {
            return result;
        }
        return this.getParentScope().getAssBySRef(timestamp, reference);
    }

    @Override
    public Definition getLocalAssignmentByID(CompilationTimeStamp timestamp, Identifier id) {
        if (this.lastUniquenessCheckTimeStamp == null) {
            this.checkUniqueness(timestamp);
        }
        return this.definitionMap.get(id.getName());
    }

    @Override
    public boolean hasLocalAssignmentWithID(CompilationTimeStamp timestamp, Identifier identifier) {
        if (this.lastUniquenessCheckTimeStamp == null) {
            this.checkUniqueness(timestamp);
        }
        return this.definitionMap.containsKey(identifier.getName());
    }

    @Override
    public void addProposal(ProposalCollector propCollector) {
        if (propCollector.getReference().getModuleIdentifier() == null) {
            for (Definition definition : this.definitions) {
                definition.addProposal(propCollector, 0);
            }
        }
        super.addProposal(propCollector);
    }

    @Override
    public void addSkeletonProposal(ProposalCollector propCollector) {
        for (SkeletonTemplateProposal templateProposal : TTCN3CodeSkeletons.MODULE_LEVEL_SKELETON_PROPOSALS) {
            propCollector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), TTCN3CodeSkeletons.SKELETON_IMAGE);
        }
    }

    @Override
    public void addKeywordProposal(ProposalCollector propCollector) {
        propCollector.addProposal(TTCN3Keywords.MODULE_SCOPE, null, "keyword");
        propCollector.addProposal(TTCN3Keywords.GENERALLY_USABLE, null, "keyword");
        super.addKeywordProposal(propCollector);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector) {
        if (declarationCollector.getReference().getModuleIdentifier() == null) {
            for (Definition definition : this.definitions) {
                definition.addDeclaration(declarationCollector, 0);
            }
        }
        super.addDeclaration(declarationCollector);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        Location cumulativeLocation;
        Location temporalLocation;
        if (!isDamaged) {
            for (Definition temp : this.definitions) {
                Location temporalLocation2 = temp.getLocation();
                Location cumulativeLocation2 = temp.getCumulativeDefinitionLocation();
                if (!reparser.isAffected(temporalLocation2)) continue;
                temp.updateSyntax(reparser, false);
                if (!temporalLocation2.equals(cumulativeLocation2)) {
                    reparser.updateLocation(cumulativeLocation2);
                }
                reparser.updateLocation(temporalLocation2);
            }
            return;
        }
        int result = 0;
        this.lastCompilationTimeStamp = null;
        boolean enveloped = false;
        int nofDamaged = 0;
        int leftBoundary = this.location.getOffset();
        int rightBoundary = this.location.getEndOffset();
        int damageOffset = reparser.getDamageStart();
        IAppendableSyntax lastAppendableBeforeChange = null;
        IAppendableSyntax lastPrependableBeforeChange = null;
        int size = this.definitions.size();
        for (int i = 0; i < size && !enveloped; ++i) {
            Location cumulativeLocation3;
            Definition temp = this.definitions.get(i);
            Location tempLocation = temp.getLocation();
            if (tempLocation.equals(cumulativeLocation3 = temp.getCumulativeDefinitionLocation()) && reparser.envelopsDamage(cumulativeLocation3)) {
                enveloped = true;
                leftBoundary = cumulativeLocation3.getOffset();
                rightBoundary = cumulativeLocation3.getEndOffset();
                continue;
            }
            if (reparser.isDamaged(cumulativeLocation3)) {
                ++nofDamaged;
                if (reparser.getDamageStart() == cumulativeLocation3.getEndOffset()) {
                    lastAppendableBeforeChange = temp;
                    continue;
                }
                if (reparser.getDamageEnd() != cumulativeLocation3.getOffset()) continue;
                lastPrependableBeforeChange = temp;
                continue;
            }
            if (cumulativeLocation3.getEndOffset() < damageOffset && cumulativeLocation3.getEndOffset() > leftBoundary) {
                leftBoundary = cumulativeLocation3.getEndOffset();
                lastAppendableBeforeChange = temp;
            }
            if (cumulativeLocation3.getOffset() < damageOffset || cumulativeLocation3.getOffset() >= rightBoundary) continue;
            rightBoundary = cumulativeLocation3.getOffset();
            lastPrependableBeforeChange = temp;
        }
        if (!enveloped && isDamaged) {
            List<Integer> temp;
            boolean isBeingExtended;
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            if (lastAppendableBeforeChange != null && (isBeingExtended = reparser.startsWithFollow(lastAppendableBeforeChange.getPossibleExtensionStarterTokens()))) {
                leftBoundary = lastAppendableBeforeChange.getLocation().getOffset();
                ++nofDamaged;
                enveloped = false;
                reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            }
            if (lastPrependableBeforeChange != null && (temp = lastPrependableBeforeChange.getPossiblePrefixTokens()) != null && reparser.endsWithToken(temp)) {
                rightBoundary = lastPrependableBeforeChange.getLocation().getEndOffset();
                ++nofDamaged;
                enveloped = false;
                reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            }
            if (nofDamaged != 0) {
                this.removeStuffInRange(reparser);
                this.lastUniquenessCheckTimeStamp = null;
            }
        }
        for (Definition temp : this.definitions) {
            temporalLocation = temp.getLocation();
            cumulativeLocation = temp.getCumulativeDefinitionLocation();
            if (!reparser.isAffected(cumulativeLocation)) continue;
            try {
                temp.updateSyntax(reparser, enveloped && reparser.envelopsDamage(temporalLocation));
                if (!reparser.getNameChanged()) continue;
                this.lastUniquenessCheckTimeStamp = null;
                reparser.setNameChanged(false);
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    this.definitions.remove(temp);
                    reparser.extendDamagedRegion(cumulativeLocation);
                    result = 1;
                    continue;
                }
                e.decreaseDepth();
                throw e;
            }
        }
        if (result == 1) {
            this.removeStuffInRange(reparser);
            this.lastUniquenessCheckTimeStamp = null;
        }
        for (Definition temp : this.definitions) {
            temporalLocation = temp.getLocation();
            cumulativeLocation = temp.getCumulativeDefinitionLocation();
            if (!reparser.isAffected(temporalLocation)) continue;
            if (!temporalLocation.equals(cumulativeLocation)) {
                reparser.updateLocation(cumulativeLocation);
            }
            reparser.updateLocation(temporalLocation);
        }
        if (!enveloped && reparser.envelopsDamage(this.location)) {
            throw new ReParseException();
        }
        if (result != 0) {
            this.lastUniquenessCheckTimeStamp = null;
            throw new ReParseException(result);
        }
    }

    private void removeStuffInRange(TTCN3ReparseUpdater reparser) {
        ArrayList<Definition> toBeRemoved = new ArrayList<Definition>();
        for (Definition temp : this.definitions) {
            if (!reparser.isDamaged(temp.getCumulativeDefinitionLocation())) continue;
            reparser.extendDamagedRegion(temp.getCumulativeDefinitionLocation());
            toBeRemoved.add(temp);
        }
        this.definitions.removeAll(toBeRemoved);
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        if (this.definitions == null) {
            return null;
        }
        for (Definition definition : this.definitions) {
            if (!definition.getLocation().containsOffset(offset)) continue;
            return definition;
        }
        return null;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        for (Definition definition : this.definitions) {
            definition.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        for (Definition definition : this.definitions) {
            if (definition.accept(v)) continue;
            return false;
        }
        return v.leave(this) != 2;
    }

    @Override
    public Iterator<Assignment> iterator() {
        return new Iterator<Assignment>(){
            Iterator<Definition> it;
            {
                this.it = For_Loop_Definitions.this.definitions.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Assignment next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.definitions != null) {
            for (Definition definition : this.definitions) {
                definition.getLocation().update_location_object(aData, source);
                definition.generateCodeString(aData, source);
                source.append('\n');
            }
        }
    }
}

