/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.Object;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASN1.ASN1Object;
import org.eclipse.titan.designer.AST.ASN1.Object.ASN1Objects;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClass_Definition;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectSet_definition;
import org.eclipse.titan.designer.AST.ASN1.Object.Object_Definition;
import org.eclipse.titan.designer.AST.ASN1.Object.ReferencedObject;
import org.eclipse.titan.designer.AST.ASN1.Object.Referenced_ObjectSet;
import org.eclipse.titan.designer.AST.ASN1.ObjectClass;
import org.eclipse.titan.designer.AST.ASN1.ObjectSet;
import org.eclipse.titan.designer.AST.ASN1.ObjectSetElement_Visitor;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ObjectSetElementVisitor_objectCollector
extends ObjectSetElement_Visitor {
    private static final String OBJECTOFCLASSEXPECTED = "Objects of objectclass `{0}'' are expected; `{1}'' is object of class `{2}''";
    private static final String DUPLICATED_OBJECT_WITH_UNIQUE_FIELD = "This object with identifier (UNIQUE) field is already in the set";
    private static final String DUPLICATED_OBJECT_WITH_UNIQUE_FIELD_IN_SET = "Object set already contains object with identifier (UNIQUE) field";
    private final ObjectClass_Definition governor;
    private final Set<Object> visitedElements = new HashSet<Object>();
    private ASN1Objects objects;
    private final CompilationTimeStamp timestamp;

    public ObjectSetElementVisitor_objectCollector(ObjectSet parent, CompilationTimeStamp timestamp) {
        super(parent.getLocation());
        this.governor = parent.getMyGovernor().getRefdLast(timestamp, null);
        this.objects = new ASN1Objects();
        this.timestamp = timestamp;
    }

    public ObjectSetElementVisitor_objectCollector(Location location, ObjectClass governor, CompilationTimeStamp timestamp) {
        super(location);
        this.governor = governor.getRefdLast(timestamp, null);
        this.objects = new ASN1Objects();
        this.timestamp = timestamp;
    }

    @Override
    public void visitObject(ASN1Object p) {
        this.visitObjectFromObjectSet(p, null);
    }

    public void visitObjectFromObjectSet(ASN1Object p, ObjectSet os) {
        ObjectClass_Definition refdClass;
        Object_Definition object = p.getRefdLast(this.timestamp, null);
        if (object.getIsErroneous(this.timestamp)) {
            return;
        }
        if (this.visitedElements.contains(object)) {
            IValue value = object.getUniqueFieldSettingValue();
            if (value != null && p instanceof ReferencedObject) {
                p.getLocation().reportSemanticError(DUPLICATED_OBJECT_WITH_UNIQUE_FIELD);
            } else if (value != null && os != null && os instanceof Referenced_ObjectSet) {
                os.getLocation().reportSemanticError(DUPLICATED_OBJECT_WITH_UNIQUE_FIELD_IN_SET);
            }
            return;
        }
        ObjectClass_Definition myClass = this.governor.getRefdLast(this.timestamp, null);
        if (myClass != (refdClass = object.getMyGovernor().getRefdLast(this.timestamp, null))) {
            if (this.location != NULL_Location.INSTANCE && refdClass != null) {
                this.location.reportSemanticError(MessageFormat.format(OBJECTOFCLASSEXPECTED, myClass.getFullName(), p.getFullName(), refdClass.getFullName()));
            }
            return;
        }
        this.visitedElements.add(object);
        this.objects.addObject(object);
    }

    @Override
    public void visitObjectSetReferenced(Referenced_ObjectSet p) {
        this.visitObjectSet(p, false);
    }

    public void visitObjectSet(ObjectSet p, boolean force) {
        ObjectClass_Definition refdClass;
        if (this.governor == null || p == null) {
            return;
        }
        ObjectSet_definition os = p.getRefdLast(this.timestamp, null);
        ObjectClass_Definition myClass = this.governor.getRefdLast(this.timestamp, null);
        if (myClass != (refdClass = os.getMyGovernor().getRefdLast(this.timestamp, null)) && myClass != null && refdClass != null) {
            p.getLocation().reportSemanticError(MessageFormat.format(OBJECTOFCLASSEXPECTED, myClass.getFullName(), p.getFullName(), refdClass.getFullName()));
            return;
        }
        if (this.visitedElements.contains(os)) {
            if (!force) {
                return;
            }
        } else {
            this.visitedElements.add(os);
        }
        ASN1Objects otherObjects = os.getObjs();
        otherObjects.trimToSize();
        for (int i = 0; i < otherObjects.getNofObjects(); ++i) {
            this.visitObjectFromObjectSet(otherObjects.getObjectByIndex(i), p);
        }
    }

    public ASN1Objects getObjects() {
        return this.objects;
    }

    public ASN1Objects giveObjects() {
        ASN1Objects temp = this.objects;
        this.objects = null;
        return temp;
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.objects == null || this.objects.accept(v);
    }
}

