/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.models;

import org.eclipse.titan.common.utils.ObjectUtils;

public class TimeInterval {
    private String start;
    private String end;
    private String timestampFormat;

    public TimeInterval(String start, String end, String timestampFormat) {
        this.start = start;
        this.end = end;
        this.timestampFormat = timestampFormat;
    }

    public TimeInterval(TimeInterval timeInterval) {
        this.start = timeInterval.start;
        this.end = timeInterval.end;
        this.timestampFormat = timeInterval.timestampFormat;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public String getTimeStampFormat() {
        return this.timestampFormat;
    }

    public boolean contains(String timestamp) {
        if (this.start.isEmpty()) {
            return this.end.isEmpty() || this.end.compareTo(timestamp) >= 0;
        }
        if (this.end.isEmpty()) {
            return this.start.compareTo(timestamp) <= 0;
        }
        return this.start.compareTo(timestamp) <= 0 && this.end.compareTo(timestamp) >= 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TimeInterval rhs = (TimeInterval)o;
        return ObjectUtils.equals((Object)this.timestampFormat, (Object)rhs.timestampFormat) && ObjectUtils.equals((Object)this.start, (Object)rhs.start) && ObjectUtils.equals((Object)this.end, (Object)rhs.end);
    }

    public int hashCode() {
        return ObjectUtils.hash((Object[])new Object[]{this.start, this.end, this.timestampFormat});
    }
}

