/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.LinkerFlagsOptionsData;
import org.eclipse.titan.designer.properties.pages.IOptionsPage;
import org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage;

public final class LinkerFlagsOptionsPage
implements IOptionsPage {
    private Composite mainComposite;
    private Composite linkerFreeTextComposite;
    private Button useGoldLinker;
    private StringFieldEditor freeTextLinkerOptions;

    @Override
    public void dispose() {
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
            this.mainComposite = null;
            this.linkerFreeTextComposite.dispose();
            this.linkerFreeTextComposite = null;
            this.useGoldLinker.dispose();
            this.freeTextLinkerOptions.dispose();
        }
    }

    @Override
    public Composite createContents(Composite parent) {
        if (this.mainComposite != null) {
            return this.mainComposite;
        }
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayout((Layout)new GridLayout());
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.useGoldLinker = new Button(this.mainComposite, 32);
        this.useGoldLinker.setText("Use Gold Linker (-fuse-ld=gold)");
        this.linkerFreeTextComposite = new Composite(this.mainComposite, 0);
        this.linkerFreeTextComposite.setLayout((Layout)new GridLayout());
        this.linkerFreeTextComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.freeTextLinkerOptions = new StringFieldEditor("freeTextLinkerOptions", "Other options (free text):", this.linkerFreeTextComposite);
        this.freeTextLinkerOptions.setStringValue("");
        return this.mainComposite;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.mainComposite == null) {
            return;
        }
        this.useGoldLinker.setEnabled(enabled);
        this.freeTextLinkerOptions.setEnabled(true, this.linkerFreeTextComposite);
    }

    @Override
    public void copyPropertyStore(IProject project, PreferenceStore tempStorage) {
        String temp = null;
        for (int i = 0; i < LinkerFlagsOptionsData.PROPERTIES.length; ++i) {
            try {
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", LinkerFlagsOptionsData.PROPERTIES[i]));
                if (temp == null) continue;
                tempStorage.setValue(LinkerFlagsOptionsData.PROPERTIES[i], temp);
                continue;
            }
            catch (CoreException ce) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
            }
        }
    }

    @Override
    public boolean evaluatePropertyStore(IProject project, PreferenceStore tempStorage) {
        String actualValue = null;
        String copyValue = null;
        boolean result = false;
        for (int i = 0; i < LinkerFlagsOptionsData.PROPERTIES.length; ++i) {
            try {
                actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", LinkerFlagsOptionsData.PROPERTIES[i]));
                copyValue = tempStorage.getString(LinkerFlagsOptionsData.PROPERTIES[i]);
                result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                result = true;
            }
        }
        return result;
    }

    @Override
    public void performDefaults() {
        if (this.mainComposite == null) {
            return;
        }
        this.setEnabled(true);
        this.useGoldLinker.setSelection(false);
        this.freeTextLinkerOptions.setStringValue("");
    }

    @Override
    public boolean checkProperties(ProjectBuildPropertyPage page) {
        return true;
    }

    @Override
    public void loadProperties(IProject project) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "useGoldLinker"));
            this.useGoldLinker.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "freeTextLinkerOptions"));
            this.freeTextLinkerOptions.setStringValue(temp);
        }
        catch (CoreException e) {
            this.useGoldLinker.setSelection(false);
            this.freeTextLinkerOptions.setStringValue("");
        }
    }

    @Override
    public boolean saveProperties(IProject project) {
        try {
            this.setProperty(project, "useGoldLinker", this.useGoldLinker.getSelection() ? "true" : "false");
            this.setProperty(project, "freeTextLinkerOptions", this.freeTextLinkerOptions.getStringValue());
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        return true;
    }

    private void setProperty(IProject project, String name, String value) throws CoreException {
        QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", name);
        String oldValue = project.getPersistentProperty(qualifiedName);
        if (value != null && !value.equals(oldValue)) {
            project.setPersistentProperty(qualifiedName, value);
        }
    }
}

