/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions.runconfiggenerator;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.cfg.ConfigFileHandler;
import org.eclipse.titan.common.utils.FileUtils;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.common.utils.StringUtils;
import org.eclipse.titan.designer.actions.runconfiggenerator.FileNameDialog;
import org.eclipse.titan.designer.actions.runconfiggenerator.GenerateRunConfigBase;
import org.eclipse.titan.designer.consoles.TITANConsole;
import org.eclipse.titan.designer.core.TITANBuilder;
import org.eclipse.titan.designer.core.TITANJavaBuilder;

public class GenerateRunConfigParallel
extends GenerateRunConfigBase {
    @Override
    protected void generateRunConfig(IFile file) throws CoreException {
        if (TITANBuilder.isBuilderEnabled(file.getProject())) {
            this.generateRunConfigParallelTitan(file);
        } else if (TITANJavaBuilder.isBuilderEnabled(file.getProject())) {
            this.generateRunConfigParallelTitanJava(file);
        }
    }

    private void generateRunConfigParallelTitan(IFile file) throws CoreException {
        ErrorReporter.parallelErrorDisplayInMessageDialog((String)("Error while generating the default launch configuration for project " + file.getProject().getName()), (String)"This feature is only available for Titan Java projects!");
    }

    private void generateRunConfigParallelTitanJava(IFile file) throws CoreException {
        int tcpPort;
        if (!this.validateFile(file)) {
            return;
        }
        String projectName = file.getProject().getName();
        String projectLocation = file.getProject().getLocation().toOSString();
        String configFileName = file.getLocation().toOSString();
        ConfigFileHandler configHandler = new ConfigFileHandler();
        configHandler.readFromFile(configFileName);
        String localAddress = configHandler.getLocalAddress();
        if (StringUtils.isNullOrEmpty((String)localAddress)) {
            localAddress = "127.0.0.1";
            ErrorReporter.parallelWarningDisplayInMessageDialog((String)("Error while generating the default launch configuration for project " + projectName), (String)("\"LocalAddress\" parameter is missing from configuration file: " + file.getFullPath().toOSString() + "\nUsing default: " + localAddress));
            TITANConsole.println("\"LocalAddress\" parameter is missing from configuration file: " + file.getFullPath().toOSString());
            TITANConsole.println("Using default: " + localAddress);
        }
        if ((tcpPort = configHandler.getTcpPort()) == 0) {
            ErrorReporter.logError((String)("\"TCPPort\" parameter is missing from configuration file: " + file.getFullPath().toOSString()));
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)("Error while generating the default launch configuration for project " + projectName), (String)("\"TCPPort\" parameter is missing from configuration file: " + file.getFullPath().toOSString() + "\nCannot continue"));
            TITANConsole.println("\"TCPPort\" parameter is missing from configuration file: " + file.getFullPath().toOSString());
            TITANConsole.println("Cannot continue");
            return;
        }
        String filenamePrefix = projectName;
        boolean overwrite = false;
        FileNameDialog dialog = new FileNameDialog(new Shell());
        dialog.setDefaultFileName(filenamePrefix);
        dialog.setMode(false);
        dialog.create();
        if (dialog.open() != 0) {
            return;
        }
        filenamePrefix = dialog.getFirstName();
        overwrite = dialog.getOverwrite();
        FileUtils.createDir((IFolder)file.getProject().getFolder("launch"));
        String parallelRunConfigShortFilename = filenamePrefix + "-HC";
        URI parallelRunConfigFilename = URIUtil.toURI((String)(projectLocation + File.separator + "launch" + File.separator + parallelRunConfigShortFilename + ".launch"));
        String titanRunConfigShortFilename = filenamePrefix + "-MC";
        URI titanRunConfigFilename = URIUtil.toURI((String)(projectLocation + File.separator + "launch" + File.separator + titanRunConfigShortFilename + ".launch"));
        URI launchGroupConfigFilename = URIUtil.toURI((String)(projectLocation + File.separator + "launch" + File.separator + filenamePrefix + "-Parallel.launch"));
        URI configFileNameUri = URIUtil.toURI((IPath)file.getProject().getLocation()).relativize(URIUtil.toURI((IPath)file.getLocation()));
        String parallelRunConfigContent = MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<launchConfiguration type=\"org.eclipse.jdt.launching.localJavaApplication\">\n    <listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_PATHS\">\n        <listEntry value=\"/{0}/java_src/org/eclipse/titan/{0}/generated/Parallel_main.java\"/>\n    </listAttribute>\n    <listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_TYPES\">\n        <listEntry value=\"1\"/>\n    </listAttribute>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_ATTR_USE_ARGFILE\" value=\"false\"/>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_SHOW_CODEDETAILS_IN_EXCEPTION_MESSAGES\" value=\"true\"/>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_USE_CLASSPATH_ONLY_JAR\" value=\"false\"/>\n    <booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_USE_START_ON_FIRST_THREAD\" value=\"true\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.MAIN_TYPE\" value=\"org.eclipse.titan.{0}.generated.Parallel_main\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.MODULE_NAME\" value=\"{0}\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.PROGRAM_ARGUMENTS\" value=\"{1} {2,number,#}\"/>\n    <stringAttribute key=\"org.eclipse.jdt.launching.PROJECT_ATTR\" value=\"{0}\"/>\n</launchConfiguration>\n", projectName, localAddress, tcpPort);
        String titanRunConfigContent = MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<launchConfiguration type=\"org.eclipse.titan.executor.executors.java_mctr.LaunchConfigurationDelegate\">\r\n    <stringAttribute key=\"bad_container_name\" value=\"\\consume\"/>\r\n    <stringAttribute key=\"lastTimeSelection\" value=\"configuration file\"/>\r\n    <intAttribute key=\"lastTimeSelectionTime\" value=\"1\"/>\r\n    <intAttribute key=\"lastTimeSelectionType\" value=\"4\"/>\r\n    <listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_PATHS\">\r\n        <listEntry value=\"/{0}\"/>\r\n    </listAttribute>\r\n    <listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_TYPES\">\r\n        <listEntry value=\"4\"/>\r\n    </listAttribute>\r\n    <intAttribute key=\"org.eclipse.titan.executor.MainControllerStateRefreshTimeout\" value=\"5\"/>\r\n    <stringAttribute key=\"org.eclipse.titan.executor.configurationFilePath\" value=\"{1}\"/>\r\n    <booleanAttribute key=\"org.eclipse.titan.executor.consoleLogging\" value=\"true\"/>\r\n    <stringAttribute key=\"org.eclipse.titan.executor.executableFilePath\" value=\"\"/>\r\n    <booleanAttribute key=\"org.eclipse.titan.executor.executeConfigurationFileOnLaunch\" value=\"true\"/>\r\n    <booleanAttribute key=\"org.eclipse.titan.executor.keepTemporarilyGeneratedConfigurationFiles\" value=\"true\"/>\r\n    <intAttribute key=\"org.eclipse.titan.executor.maximumNotificationLineCount\" value=\"1000\"/>\r\n    <stringAttribute key=\"org.eclipse.titan.executor.projectName\" value=\"{0}\"/>\r\n    <booleanAttribute key=\"org.eclipse.titan.executor.severityLevelExtraction\" value=\"true\"/>\r\n    <booleanAttribute key=\"org.eclipse.titan.executor.testcaseRefreshOnStart\" value=\"true\"/>\r\n    <booleanAttribute key=\"org.eclipse.titan.executor.verdictExtraction\" value=\"true\"/>\r\n    <stringAttribute key=\"org.eclipse.titan.executor.workingdirectoryPath\" value=\"\"/>\r\n</launchConfiguration>\r\n", projectName, configFileNameUri.getPath());
        String launchGroupConfigContent = MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<launchConfiguration type=\"org.eclipse.debug.core.groups.GroupLaunchConfigurationType\">\r\n    <stringAttribute key=\"org.eclipse.debug.core.launchGroup.0.action\" value=\"NONE\"/>\r\n    <booleanAttribute key=\"org.eclipse.debug.core.launchGroup.0.adoptIfRunning\" value=\"false\"/>\r\n    <booleanAttribute key=\"org.eclipse.debug.core.launchGroup.0.enabled\" value=\"true\"/>\r\n    <stringAttribute key=\"org.eclipse.debug.core.launchGroup.0.mode\" value=\"inherit\"/>\r\n    <stringAttribute key=\"org.eclipse.debug.core.launchGroup.0.name\" value=\"{0}\"/>\r\n    <stringAttribute key=\"org.eclipse.debug.core.launchGroup.1.action\" value=\"OUTPUT_REGEXP\"/>\r\n    <stringAttribute key=\"org.eclipse.debug.core.launchGroup.1.actionParam\" value=\"Listening on IP address\"/>    <booleanAttribute key=\"org.eclipse.debug.core.launchGroup.1.adoptIfRunning\" value=\"false\"/>\r\n    <booleanAttribute key=\"org.eclipse.debug.core.launchGroup.1.enabled\" value=\"true\"/>\r\n    <stringAttribute key=\"org.eclipse.debug.core.launchGroup.1.mode\" value=\"inherit\"/>\r\n    <stringAttribute key=\"org.eclipse.debug.core.launchGroup.1.name\" value=\"{1}\"/>\r\n    <listAttribute key=\"org.eclipse.debug.ui.favoriteGroups\">\r\n        <listEntry value=\"org.eclipse.debug.ui.launchGroup.run\"/>\r\n    </listAttribute>\r\n</launchConfiguration>", titanRunConfigShortFilename, parallelRunConfigShortFilename);
        try {
            File parallelRunConfigFile = new File(parallelRunConfigFilename);
            File titanRunConfigFile = new File(titanRunConfigFilename);
            File launchGroupConfigFile = new File(launchGroupConfigFilename);
            if (overwrite) {
                FileUtils.deleteQuietly((File)parallelRunConfigFile);
                FileUtils.deleteQuietly((File)titanRunConfigFile);
                FileUtils.deleteQuietly((File)launchGroupConfigFile);
            }
            if (parallelRunConfigFile.createNewFile() && titanRunConfigFile.createNewFile() && launchGroupConfigFile.createNewFile()) {
                IOUtils.writeStringToFile((File)parallelRunConfigFile, (String)parallelRunConfigContent);
                TITANConsole.println("Run configuration generated: " + parallelRunConfigFile.getAbsolutePath());
                IOUtils.writeStringToFile((File)titanRunConfigFile, (String)titanRunConfigContent);
                TITANConsole.println("Run configuration generated: " + titanRunConfigFile.getAbsolutePath());
                IOUtils.writeStringToFile((File)launchGroupConfigFile, (String)launchGroupConfigContent);
                TITANConsole.println("Run configuration generated: " + launchGroupConfigFile.getAbsolutePath());
                file.getProject().refreshLocal(2, null);
            } else {
                TITANConsole.println("File generation error. Existing files were not overwritten.");
            }
        }
        catch (IOException e) {
            TITANConsole.println("An error occurred.");
        }
    }
}

