/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.Type_Assignment;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.RawAST;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ValueRange;
import org.eclipse.titan.designer.AST.TTCN3.templates.Value_Range_Template;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.BuildTimestamp;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Float_Type
extends ASN1Type {
    private static final String REALVALUEEXPECTED = "REAL value was expected";
    private static final String FLOATVALUEEXPECTED = "float value was expected";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `float''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for type `float''";
    private static final String INCORRECTBOUNDARIES = "The lower boundary is higher than the upper boundary";

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_REAL;
    }

    @Override
    public IASN1Type newInstance() {
        return new Float_Type();
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return IType.Type_type.TYPE_REAL.equals((Object)temp.getTypetype());
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return "float";
    }

    @Override
    public String getOutlineIcon() {
        return "float.gif";
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_FLOAT;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.initAttributes(timestamp);
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
        this.checkSubtypeRestrictions(timestamp);
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        boolean selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return selfReference;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return selfReference;
            }
        }
        if (value.isAsn()) {
            IType lastType;
            if (IValue.Value_type.REFERENCED_VALUE.equals((Object)value.getValuetype()) && !(lastType = last.getMyGovernor().getTypeRefdLast(timestamp)).getIsErroneous(timestamp) && !IType.Type_type.TYPE_REAL.equals((Object)lastType.getTypetype())) {
                value.getLocation().reportSemanticError(REALVALUEEXPECTED);
                value.setIsErroneous(true);
                return selfReference;
            }
            switch (last.getValuetype()) {
                case REAL_VALUE: {
                    break;
                }
                case UNDEFINED_BLOCK: {
                    last = last.setValuetype(timestamp, IValue.Value_type.SEQUENCE_VALUE);
                    Identifier identifier = new Identifier(Identifier.Identifier_type.ID_ASN, "REAL");
                    Assignment assignment = this.getMyScope().getAssignmentsScope().getLocalAssignmentByID(timestamp, identifier);
                    ((Type_Assignment)assignment).getType(timestamp).checkThisValue(timestamp, last, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, false, false, true, false, valueCheckingOptions.str_elem));
                    last = last.setValuetype(timestamp, IValue.Value_type.REAL_VALUE);
                    break;
                }
                case INTEGER_VALUE: {
                    last.setValuetype(timestamp, IValue.Value_type.REAL_VALUE);
                    break;
                }
                case EXPRESSION_VALUE: 
                case MACRO_VALUE: {
                    break;
                }
                default: {
                    last.getLocation().reportSemanticError(REALVALUEEXPECTED);
                    last.setIsErroneous(true);
                    break;
                }
            }
        } else {
            switch (last.getValuetype()) {
                case REAL_VALUE: {
                    break;
                }
                case EXPRESSION_VALUE: 
                case MACRO_VALUE: {
                    break;
                }
                default: {
                    value.getLocation().reportSemanticError(FLOATVALUEEXPECTED);
                    value.setIsErroneous(true);
                }
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        if (ITTCN3Template.Template_type.VALUE_RANGE.equals((Object)template.getTemplatetype())) {
            ValueRange range = ((Value_Range_Template)template).getValueRange();
            IValue lower = this.checkBoundary(timestamp, range.getMin());
            IValue upper = this.checkBoundary(timestamp, range.getMax());
            range.setTypeType(this.getTypetypeTtcn3());
            if (lower != null && upper != null && ((Real_Value)lower).getValue() > ((Real_Value)upper).getValue()) {
                template.getLocation().reportSemanticError(INCORRECTBOUNDARIES);
            }
            if (lower != null && range.getMax() == null) {
                this.checkBoundaryInfinity(timestamp, lower, true);
            }
            if (range.getMin() == null && upper != null) {
                this.checkBoundaryInfinity(timestamp, upper, false);
            }
        } else {
            template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName()));
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(LENGTHRESTRICTIONNOTALLOWED);
        }
        return false;
    }

    private IValue checkBoundary(CompilationTimeStamp timestamp, Value value) {
        if (value == null) {
            return null;
        }
        value.setMyGovernor(this);
        IValue temp = this.checkThisValueRef(timestamp, value);
        this.checkThisValue(timestamp, temp, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, true, false, false));
        temp = temp.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
        switch (temp.getValuetype()) {
            case REAL_VALUE: {
                break;
            }
            default: {
                temp = null;
            }
        }
        return temp;
    }

    private void checkBoundaryInfinity(CompilationTimeStamp timestamp, IValue value, boolean isUpper) {
        if (value == null) {
            return;
        }
        value.setMyGovernor(this);
        IValue temp = this.checkThisValueRef(timestamp, value);
        this.checkThisValue(timestamp, temp, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_STATIC_VALUE, false, false, true, false, false));
        temp = temp.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_STATIC_VALUE, null);
        if (temp.getValuetype() == IValue.Value_type.OMIT_VALUE) {
            value.getLocation().reportSemanticError("`omit' value is not allowed in this context");
            value.setIsErroneous(true);
            return;
        }
        if (this.subType != null) {
            // empty if block
        }
    }

    @Override
    public void checkCodingAttributes(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        int restrictionLength;
        if (this.subType != null && (restrictionLength = this.subType.get_length_restriction()) != -1) {
            if (this.rawAttribute == null) {
                this.rawAttribute = new RawAST(this.getDefaultRawFieldLength());
            }
            this.rawAttribute.length_restriction = restrictionLength;
        }
        if (this.rawAttribute != null && this.rawAttribute.fieldlength != 64 && this.rawAttribute.fieldlength != 32) {
            this.getLocation().reportSemanticError(MessageFormat.format("Invalid length ({0}) specified in parameter FIELDLENGTH for float type `{1}''. The FIELDLENGTH must be single (32) or double (64)", this.rawAttribute.fieldlength, this.getFullName()));
        }
        this.checkJson(timestamp);
    }

    @Override
    public boolean canHaveCoding(CompilationTimeStamp timestamp, IType.MessageEncoding_type coding) {
        if (coding == IType.MessageEncoding_type.BER) {
            return this.hasEncoding(timestamp, IType.MessageEncoding_type.BER, null);
        }
        switch (coding) {
            case RAW: 
            case JSON: 
            case XER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public int getDefaultRawFieldLength() {
        return 64;
    }

    @Override
    public int getRawLength(BuildTimestamp timestamp) {
        if (this.rawAttribute != null) {
            return this.rawAttribute.fieldlength;
        }
        return this.getDefaultRawFieldLength();
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("float");
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return this.needsAlias();
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        if (this.needsAlias()) {
            String ownName = this.getGenNameOwn();
            source.append(MessageFormat.format("\tpublic static class {0} extends {1} '{'\n", ownName, this.getGenNameValue(aData, source)));
            StringBuilder descriptor = new StringBuilder();
            this.generateCodeTypedescriptor(aData, source, descriptor, null);
            this.generateCodeDefaultCoding(aData, source, descriptor);
            this.generateCodeForCodingHandlers(aData, source, descriptor);
            source.append((CharSequence)descriptor);
            source.append("\t}\n");
            source.append(MessageFormat.format("\tpublic static class {0}_template extends {1} '{' '}'\n", ownName, this.getGenNameTemplate(aData, source)));
        } else if (this.getParentType() == null || !this.getParentType().generatesOwnClass(aData, source)) {
            this.generateCodeTypedescriptor(aData, source, null, aData.attibute_registry);
            this.generateCodeDefaultCoding(aData, source, null);
            this.generateCodeForCodingHandlers(aData, source, null);
        }
        if (!this.isAsn()) {
            if (this.hasDoneAttribute()) {
                this.generateCodeDone(aData, source);
            }
            if (this.subType != null) {
                this.subType.generateCode(aData, source);
            }
        }
    }

    @Override
    public String createStringRep_for_OpenType_AltName(CompilationTimeStamp timestamp) {
        if (this.isTagged() || this.hasRawAttributes(timestamp)) {
            return this.getGenNameOwn();
        }
        return "REAL";
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        aData.addBuiltinTypeImport("TitanFloat");
        return "TitanFloat";
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        aData.addBuiltinTypeImport("TitanFloat_template");
        return "TitanFloat_template";
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.rawAttribute != null || this.jsonAttribute != null || this.hasVariantAttributes(CompilationTimeStamp.getBaseTimestamp()) || !this.isAsn() && this.hasEncodeAttribute("JSON")) {
            if (this.needsAlias()) {
                String baseName = this.getGenNameOwn(aData);
                return baseName + "." + this.getGenNameOwn();
            }
            if (this.getParentType() != null) {
                IType parentType = this.getParentType();
                if (parentType.generatesOwnClass(aData, source)) {
                    return parentType.getGenNameOwn(aData) + "." + this.getGenNameOwn();
                }
                return this.getGenNameOwn(aData);
            }
            return this.getGenNameOwn(aData);
        }
        if (this.needsAlias()) {
            String baseName = this.getGenNameOwn(aData);
            return baseName + "." + this.getGenNameOwn();
        }
        aData.addBuiltinTypeImport("TitanFloat");
        return "TitanFloat.TitanFloat";
    }

    @Override
    public boolean needsOwnRawDescriptor(JavaGenData aData) {
        return this.rawAttribute != null;
    }

    @Override
    public String getGenNameRawDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.rawAttribute == null) {
            aData.addBuiltinTypeImport("TitanFloat");
            return "TitanFloat.TitanFloat_raw_";
        }
        if (this.needsAlias()) {
            return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_raw_";
        }
        return this.getGenNameOwn(aData) + "_raw_";
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return this.jsonAttribute != null && !this.jsonAttribute.empty() || this.getOwnertype() == IType.TypeOwner_type.OT_RECORD_OF && this.getParentType().getJsonAttribute() != null && this.getParentType().getJsonAttribute().as_map;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.needsOwnJsonDescriptor(aData)) {
            return this.getGenNameOwn(aData) + "_json_";
        }
        aData.addBuiltinTypeImport("TitanFloat");
        return "TitanFloat.TitanFloat_json_";
    }
}

