/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.IDecode_Match;
import org.eclipse.titan.runtime.core.Optional;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.Restricted_Length_Template;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TTCN_Pattern;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanCharString_Element;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanUniversalChar;
import org.eclipse.titan.runtime.core.TitanUniversalCharString_template;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanCharString_template
extends Restricted_Length_Template {
    TitanCharString single_value;
    ArrayList<TitanCharString_template> value_list;
    boolean min_is_set;
    boolean max_is_set;
    boolean min_is_exclusive;
    boolean max_is_exclusive;
    TitanCharString min_value;
    TitanCharString max_value;
    private boolean pattern_value_regexp_init;
    private Pattern pattern_value_posix_regexp;
    boolean pattern_value_nocase;
    protected TitanUniversalCharString_template.Unichar_Decmatch dec_match;

    public TitanCharString_template() {
    }

    public TitanCharString_template(Base_Template.template_sel otherValue) {
        super(otherValue);
        TitanCharString_template.check_single_selection(otherValue);
    }

    public TitanCharString_template(String otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanCharString(otherValue);
    }

    public TitanCharString_template(TitanCharString otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        otherValue.must_bound("Creating a template from an unbound charstring value.");
        this.single_value = new TitanCharString(otherValue);
    }

    public TitanCharString_template(TitanCharString_Element otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        otherValue.must_bound("Creating a template from an unbound charstring value.");
        this.single_value = new TitanCharString(otherValue);
    }

    public TitanCharString_template(Optional<TitanCharString> otherValue) {
        switch (otherValue.get_selection()) {
            case OPTIONAL_PRESENT: {
                this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
                this.single_value = new TitanCharString(otherValue.constGet());
                break;
            }
            case OPTIONAL_OMIT: {
                this.set_selection(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case OPTIONAL_UNBOUND: {
                throw new TtcnError("Creating a charstring template from an unbound optional field.");
            }
        }
    }

    public TitanCharString_template(TitanCharString_template otherValue) {
        this.copy_template(otherValue);
    }

    public TitanCharString_template(Base_Template.template_sel p_sel, TitanCharString p_str) {
        this(p_sel, p_str, false);
    }

    public TitanCharString_template(Base_Template.template_sel p_sel, TitanCharString p_str, boolean p_nocase) {
        super(Base_Template.template_sel.STRING_PATTERN);
        this.single_value = new TitanCharString(p_str);
        if (p_sel != Base_Template.template_sel.STRING_PATTERN) {
            throw new TtcnError("Internal error: Initializing a charstring pattern template with invalid selection.");
        }
        this.pattern_value_regexp_init = false;
        this.pattern_value_nocase = p_nocase;
    }

    @Override
    public void clean_up() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = null;
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list.clear();
                this.value_list = null;
                break;
            }
            case VALUE_RANGE: {
                this.min_value = null;
                this.max_value = null;
                break;
            }
            case STRING_PATTERN: {
                this.pattern_value_regexp_init = false;
                this.pattern_value_posix_regexp = null;
                break;
            }
            case DECODE_MATCH: {
                this.dec_match = null;
                break;
            }
        }
        this.template_selection = Base_Template.template_sel.UNINITIALIZED_TEMPLATE;
    }

    @Override
    public TitanCharString_template operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanCharString) {
            return this.operator_assign((TitanCharString)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to charstring", otherValue));
    }

    @Override
    public TitanCharString_template operator_assign(Base_Template otherValue) {
        if (otherValue instanceof TitanCharString_template) {
            return this.operator_assign((TitanCharString_template)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to charstring template", otherValue));
    }

    @Override
    public TitanCharString_template operator_assign(Base_Template.template_sel otherValue) {
        TitanCharString_template.check_single_selection(otherValue);
        this.clean_up();
        this.set_selection(otherValue);
        return this;
    }

    public TitanCharString_template operator_assign(String otherValue) {
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanCharString(otherValue);
        return this;
    }

    public TitanCharString_template operator_assign(TitanCharString otherValue) {
        otherValue.must_bound("Assignment of an unbound charstring value to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanCharString(otherValue);
        return this;
    }

    public TitanCharString_template operator_assign(TitanCharString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound charstring value to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanCharString(otherValue);
        return this;
    }

    public TitanCharString_template operator_assign(TitanCharString_template otherValue) {
        if (otherValue != this) {
            this.clean_up();
            this.copy_template(otherValue);
        }
        return this;
    }

    private void copy_template(TitanCharString_template otherValue) {
        switch (otherValue.template_selection) {
            case STRING_PATTERN: {
                this.pattern_value_regexp_init = false;
                this.pattern_value_nocase = otherValue.pattern_value_nocase;
            }
            case SPECIFIC_VALUE: {
                this.single_value = new TitanCharString(otherValue.single_value);
                break;
            }
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list = new ArrayList(otherValue.value_list.size());
                for (int i = 0; i < otherValue.value_list.size(); ++i) {
                    TitanCharString_template temp = new TitanCharString_template(otherValue.value_list.get(i));
                    this.value_list.add(temp);
                }
                break;
            }
            case VALUE_RANGE: {
                this.min_is_set = otherValue.min_is_set;
                this.min_is_exclusive = otherValue.min_is_exclusive;
                if (this.min_is_set) {
                    this.min_value = new TitanCharString(otherValue.min_value);
                }
                this.max_is_set = otherValue.max_is_set;
                this.max_is_exclusive = otherValue.max_is_exclusive;
                if (!this.max_is_set) break;
                this.max_value = new TitanCharString(otherValue.max_value);
                break;
            }
            case DECODE_MATCH: {
                this.dec_match = otherValue.dec_match;
                break;
            }
            default: {
                throw new TtcnError("Copying an uninitialized/unsupported charstring template.");
            }
        }
        this.set_selection(otherValue);
    }

    public TitanCharString_Element get_at(int index) {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Accessing a charstring element of a non-specific charstring template.");
        }
        return this.single_value.get_at(index);
    }

    public TitanCharString_Element get_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a charstring template with an unbound integer value.");
        return this.get_at(index_value.get_int());
    }

    public TitanCharString_Element constGet_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a charstring template with an unbound integer value.");
        return this.constGet_at(index_value.get_int());
    }

    public TitanCharString_Element constGet_at(int index) {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Accessing a charstring element of a non-specific charstring template.");
        }
        return this.single_value.constGet_at(index);
    }

    @Override
    public boolean match(Base_Type otherValue, boolean legacy) {
        if (otherValue instanceof TitanCharString) {
            return this.match((TitanCharString)otherValue, legacy);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to charstring", otherValue));
    }

    @Override
    public void log_match(Base_Type match_value, boolean legacy) {
        if (match_value instanceof TitanCharString) {
            this.log_match((TitanCharString)match_value, legacy);
            return;
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to charstring", match_value));
    }

    public boolean match(TitanCharString otherValue) {
        return this.match(otherValue, false);
    }

    public boolean match(TitanCharString otherValue, boolean legacy) {
        if (!otherValue.is_bound()) {
            return false;
        }
        TitanInteger value_length = otherValue.lengthof();
        if (!this.match_length(value_length.get_int())) {
            return false;
        }
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                return this.single_value.operator_equals(otherValue);
            }
            case OMIT_VALUE: {
                return false;
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (!this.value_list.get(i).match(otherValue, legacy)) continue;
                    return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                }
                return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
            }
            case VALUE_RANGE: {
                char maxValueChar;
                if (!this.min_is_set) {
                    throw new TtcnError("The lower bound is not set when matching with a charstring value range template.");
                }
                if (!this.max_is_set) {
                    throw new TtcnError("The upper bound is not set when matching with a charstring value range template.");
                }
                char minValueChar = this.min_value.get_value().charAt(0);
                if (minValueChar > (maxValueChar = this.max_value.get_value().charAt(0))) {
                    throw new TtcnError("The lower bound (\"" + minValueChar + "\") is greater than the upper bound (\"" + maxValueChar + "\") when matching with a charstring value range template.");
                }
                StringBuilder otherStr = otherValue.get_value();
                char min_value_offset = '\u0000';
                char max_value_offset = '\u0000';
                if (this.min_is_exclusive) {
                    min_value_offset = '\u0001';
                }
                if (this.max_is_exclusive) {
                    max_value_offset = '\u0001';
                }
                int otherLen = otherStr.length();
                for (int i = 0; i < otherLen; ++i) {
                    if (otherStr.charAt(i) >= minValueChar + min_value_offset && otherStr.charAt(i) <= maxValueChar - max_value_offset) continue;
                    return false;
                }
                return true;
            }
            case STRING_PATTERN: {
                if (!this.pattern_value_regexp_init) {
                    this.pattern_value_posix_regexp = TTCN_Pattern.convert_pattern(this.single_value.get_value().toString(), this.pattern_value_nocase);
                }
                if (this.pattern_value_posix_regexp != null) {
                    return TTCN_Pattern.match(otherValue.get_value().toString(), this.pattern_value_posix_regexp, this.pattern_value_nocase);
                }
                throw new TtcnError(MessageFormat.format("Cannot convert pattern \"{0}\" to POSIX-equivalent.", this.single_value.get_value().toString()));
            }
            case DECODE_MATCH: {
                TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_WARNING);
                TTCN_EncDec.clear_error();
                TTCN_Buffer buffer = new TTCN_Buffer(otherValue);
                boolean ret_val = this.dec_match.dec_match.match(buffer);
                TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_DEFAULT);
                TTCN_EncDec.clear_error();
                return ret_val;
            }
        }
        throw new TtcnError("Matching with an uninitialized/unsupported charstring template.");
    }

    public boolean match(TitanCharString_Element otherValue, boolean legacy) {
        return this.match(new TitanCharString(otherValue), legacy);
    }

    @Override
    public TitanCharString valueof() {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) {
            throw new TtcnError("Performing a valueof or send operation on a non-specific charstring template.");
        }
        return new TitanCharString(this.single_value);
    }

    @Override
    public void set_type(Base_Template.template_sel templateType, int list_length) {
        this.clean_up();
        switch (templateType) {
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.set_selection(templateType);
                this.value_list = new ArrayList(list_length);
                for (int i = 0; i < list_length; ++i) {
                    this.value_list.add(new TitanCharString_template());
                }
                break;
            }
            case VALUE_RANGE: {
                this.set_selection(Base_Template.template_sel.VALUE_RANGE);
                this.min_is_set = false;
                this.max_is_set = false;
                this.min_is_exclusive = false;
                this.max_is_exclusive = false;
                break;
            }
            case DECODE_MATCH: {
                this.set_selection(Base_Template.template_sel.DECODE_MATCH);
                break;
            }
            default: {
                throw new TtcnError("Setting an invalid type for a charstring template.");
            }
        }
    }

    @Override
    public int n_list_elem() {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list charstring template.");
        }
        return this.value_list.size();
    }

    @Override
    public TitanCharString_template list_item(int list_index) {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Internal error: Accessing a list element of a non-list charstring template. ");
        }
        if (list_index < 0) {
            throw new TtcnError("Internal error: Indexing a charstring value list template with a negative index.");
        }
        if (list_index >= this.value_list.size()) {
            throw new TtcnError("Internal error: Index overflow in a charstring value list template.");
        }
        return this.value_list.get(list_index);
    }

    @Override
    public boolean match_omit(boolean legacy) {
        if (this.is_ifPresent) {
            return true;
        }
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                if (legacy) {
                    for (int i = 0; i < this.value_list.size(); ++i) {
                        if (!this.value_list.get(i).match_omit()) continue;
                        return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                    }
                    return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
                }
                return false;
            }
        }
        return false;
    }

    public TitanInteger lengthof() {
        if (this.is_ifPresent) {
            throw new TtcnError("Performing lengthof() operation on a charstring template which has an ifpresent attribute.");
        }
        int min_length = 0;
        boolean has_any_or_none = false;
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                min_length = this.single_value.lengthof().get_int();
                has_any_or_none = false;
                break;
            }
            case OMIT_VALUE: {
                throw new TtcnError("Performing lengthof() operation on a charstring template containing omit value.");
            }
            case VALUE_RANGE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                min_length = 0;
                has_any_or_none = true;
                break;
            }
            case VALUE_LIST: {
                if (this.value_list.isEmpty()) {
                    throw new TtcnError("Internal error: Performing lengthof() operation on a charstring template containing an empty list.");
                }
                int item_length = this.value_list.get(0).lengthof().get_int();
                for (int i = 1; i < this.value_list.size(); ++i) {
                    if (this.value_list.get(i).lengthof().get_int() == item_length) continue;
                    throw new TtcnError("Performing lengthof() operation on a charstring template containing a value list with different lengths.");
                }
                min_length = item_length;
                has_any_or_none = false;
                break;
            }
            case COMPLEMENTED_LIST: {
                throw new TtcnError("Performing lengthof() operation on a charstring template containing complemented list.");
            }
            case STRING_PATTERN: {
                throw new TtcnError("Performing lengthof() operation on a charstring template containing a pattern is not allowed.");
            }
            default: {
                throw new TtcnError("Performing lengthof() operation on an uninitialized/unsupported charstring template.");
            }
        }
        return new TitanInteger(this.check_section_is_single(min_length, has_any_or_none, "length", "a", "charstring template"));
    }

    public void set_min(String otherMinValue) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Setting the lower bound for a non-range charstring template.");
        }
        int length = otherMinValue.length();
        if (length != 1) {
            throw new TtcnError(MessageFormat.format("The length of the lower bound in a charstring value range template must be 1 instead of `{0}''. ", length));
        }
        this.min_is_set = true;
        this.min_is_exclusive = false;
        this.min_value = new TitanCharString(otherMinValue);
        if (this.max_is_set && this.min_value.lengthof().get_int() > this.max_value.lengthof().get_int()) {
            throw new TtcnError(MessageFormat.format("The lower bound {0} in a charstring value range template is greater than the upper bound {1}.", this.min_value, this.max_value));
        }
    }

    public void set_min(TitanCharString otherMinValue) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Setting the lower bound for a non-range charstring template.");
        }
        otherMinValue.must_bound("Setting an unbound value as lower bound in a charstring value range template.");
        int length = otherMinValue.lengthof().get_int();
        if (length != 1) {
            throw new TtcnError(MessageFormat.format("The length of the lower bound in a charstring value range template must be 1 instead of `{0}''. ", length));
        }
        this.min_is_set = true;
        this.min_is_exclusive = false;
        this.min_value = new TitanCharString(otherMinValue);
        if (this.max_is_set && this.min_value.lengthof().get_int() > this.max_value.lengthof().get_int()) {
            throw new TtcnError(MessageFormat.format("The lower bound {0} in a charstring value range template is greater than the upper bound {1}.", this.min_value, this.max_value));
        }
    }

    public void set_max(String otherMaxValue) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Setting the upper bound for a non-range charstring template.");
        }
        int length = otherMaxValue.length();
        if (length != 1) {
            throw new TtcnError(MessageFormat.format("The length of the upper bound in a charstring value range template must be 1 instead of {0}.", length));
        }
        this.max_is_set = true;
        this.max_is_exclusive = false;
        this.max_value = new TitanCharString(otherMaxValue);
        if (this.min_is_set && this.min_value.lengthof().get_int() > this.max_value.lengthof().get_int()) {
            throw new TtcnError(MessageFormat.format("The upper bound `{0}'' in a charstring value range template is smaller than the lower bound {1}.", this.max_value, this.min_value));
        }
    }

    public void set_max(TitanCharString otherMaxValue) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Setting the upper bound for a non-range charstring template.");
        }
        otherMaxValue.must_bound("Setting an unbound value as upper bound in a charstring value range template.");
        int length = otherMaxValue.lengthof().get_int();
        if (length != 1) {
            throw new TtcnError(MessageFormat.format("The length of the upper bound in a charstring value range template must be 1 instead of {0}.", length));
        }
        this.max_is_set = true;
        this.max_is_exclusive = false;
        this.max_value = new TitanCharString(otherMaxValue);
        if (this.min_is_set && this.min_value.lengthof().get_int() > this.max_value.lengthof().get_int()) {
            throw new TtcnError(MessageFormat.format("The upper bound `{0}'' in a charstring value range template is smaller than the lower bound {1}.", this.max_value, this.min_value));
        }
    }

    public void set_min_exclusive(boolean minExclusive) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Setting the lower bound for a non-range charstring template.");
        }
        this.min_is_exclusive = minExclusive;
    }

    public void set_max_exclusive(boolean maxExclusive) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Setting the upper bound for a non-range charstring template.");
        }
        this.max_is_exclusive = maxExclusive;
    }

    public void set_decmatch(IDecode_Match dec_match) {
        if (this.template_selection != Base_Template.template_sel.DECODE_MATCH) {
            throw new TtcnError("Setting the decoded content matching mechanism of a non-decmatch charstring template.");
        }
        this.dec_match = new TitanUniversalCharString_template.Unichar_Decmatch();
        this.dec_match.dec_match = dec_match;
        this.dec_match.coding = TitanCharString.CharCoding.UTF_8;
    }

    public Object get_decmatch_dec_res() {
        if (this.template_selection != Base_Template.template_sel.DECODE_MATCH) {
            throw new TtcnError("Retrieving the decoding result of a non-decmatch charstring template.");
        }
        return this.dec_match.dec_match.get_dec_res();
    }

    public Base_Type.TTCN_Typedescriptor get_decmatch_type_descr() {
        if (this.template_selection != Base_Template.template_sel.DECODE_MATCH) {
            throw new TtcnError("Retrieving the decoded type's descriptor in a non-decmatch charstring template.");
        }
        return this.dec_match.dec_match.get_type_descr();
    }

    @Override
    public void log() {
        switch (this.template_selection) {
            case STRING_PATTERN: {
                TitanCharString_template.log_pattern(this.single_value.lengthof().get_int(), this.single_value.get_value().toString(), this.pattern_value_nocase);
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value.log();
                break;
            }
            case COMPLEMENTED_LIST: {
                TTCN_Logger.log_event_str("complement");
            }
            case VALUE_LIST: {
                TTCN_Logger.log_char('(');
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (i > 0) {
                        TTCN_Logger.log_event_str(", ");
                    }
                    this.value_list.get(i).log();
                }
                TTCN_Logger.log_char(')');
                break;
            }
            case VALUE_RANGE: {
                TTCN_Logger.log_char('(');
                if (this.min_is_exclusive) {
                    TTCN_Logger.log_char('!');
                }
                if (this.min_is_set) {
                    if (TTCN_Logger.is_printable(this.min_value.get_value().charAt(0))) {
                        TTCN_Logger.log_char('\"');
                        TTCN_Logger.log_char_escaped(this.min_value.get_value().charAt(0));
                        TTCN_Logger.log_char('\"');
                    } else {
                        TTCN_Logger.log_event_str(MessageFormat.format("char(0, 0, 0, 0)", this.min_value.get_value().charAt(0)));
                    }
                } else {
                    TTCN_Logger.log_event_str("<unknown lower bound>");
                }
                TTCN_Logger.log_event_str(" .. ");
                if (this.max_is_exclusive) {
                    TTCN_Logger.log_char('!');
                }
                if (this.max_is_set) {
                    if (TTCN_Logger.is_printable(this.max_value.get_value().charAt(0))) {
                        TTCN_Logger.log_char('\"');
                        TTCN_Logger.log_char_escaped(this.max_value.get_value().charAt(0));
                        TTCN_Logger.log_char('\"');
                    } else {
                        TTCN_Logger.log_event_str(MessageFormat.format("char(0, 0, 0, 0)", this.max_value.get_value().charAt(0)));
                    }
                } else {
                    TTCN_Logger.log_event_str("<unknown upper bound>");
                }
                TTCN_Logger.log_char(')');
                break;
            }
            case DECODE_MATCH: {
                TTCN_Logger.log_event_str("decmatch ");
                this.dec_match.dec_match.log();
                break;
            }
            default: {
                this.log_generic();
            }
        }
        this.log_restricted();
        this.log_ifpresent();
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_TEMPLATE.getValue() | Param_Types.Module_Parameter.basic_check_bits_t.BC_LIST.getValue(), "charstring template");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        switch (param.get_type()) {
            case MP_Omit: {
                this.operator_assign(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case MP_Any: {
                this.operator_assign(Base_Template.template_sel.ANY_VALUE);
                break;
            }
            case MP_AnyOrNone: {
                this.operator_assign(Base_Template.template_sel.ANY_OR_OMIT);
                break;
            }
            case MP_List_Template: 
            case MP_ComplementList_Template: {
                TitanCharString_template temp = new TitanCharString_template();
                temp.set_type(param.get_type() == Param_Types.Module_Parameter.type_t.MP_List_Template ? Base_Template.template_sel.VALUE_LIST : Base_Template.template_sel.COMPLEMENTED_LIST, param.get_size());
                for (int i = 0; i < param.get_size(); ++i) {
                    temp.list_item(i).set_param(param.get_elem(i));
                }
                this.operator_assign(temp);
                break;
            }
            case MP_Charstring: {
                this.operator_assign(new TitanCharString((String)param.get_string_data()));
                break;
            }
            case MP_StringRange: {
                TitanUniversalChar lower_uchar = param.get_lower_uchar();
                TitanUniversalChar upper_uchar = param.get_upper_uchar();
                if (!lower_uchar.is_char()) {
                    param.error("Lower bound of char range cannot be a multiple-byte character", new Object[0]);
                }
                if (!upper_uchar.is_char()) {
                    param.error("Upper bound of char range cannot be a multiple-byte character", new Object[0]);
                }
                this.clean_up();
                this.set_selection(Base_Template.template_sel.VALUE_RANGE);
                this.min_is_set = true;
                this.max_is_set = true;
                this.min_value = new TitanCharString(String.valueOf(lower_uchar.getUc_cell()));
                this.max_value = new TitanCharString(String.valueOf(upper_uchar.getUc_cell()));
                this.min_is_exclusive = param.get_is_min_exclusive();
                this.max_is_exclusive = param.get_is_max_exclusive();
                break;
            }
            case MP_Pattern: {
                this.clean_up();
                this.single_value = new TitanCharString(param.get_pattern());
                this.pattern_value_regexp_init = false;
                this.pattern_value_nocase = param.get_nocase();
                this.set_selection(Base_Template.template_sel.STRING_PATTERN);
                break;
            }
            case MP_Expression: {
                if (param.get_expr_type() == Param_Types.Module_Parameter.expression_operand_t.EXPR_CONCATENATE) {
                    TitanCharString operand1 = new TitanCharString();
                    TitanCharString operand2 = new TitanCharString();
                    TitanCharString result = new TitanCharString();
                    AtomicBoolean nocase = new AtomicBoolean();
                    boolean is_pattern = operand1.set_param_internal(param.get_operand1(), true, nocase);
                    operand2.set_param(param.get_operand2());
                    result.operator_assign(operand1.operator_concatenate(operand2));
                    if (is_pattern) {
                        this.clean_up();
                        this.single_value = result;
                        this.pattern_value_regexp_init = false;
                        this.pattern_value_nocase = nocase.get();
                        this.set_selection(Base_Template.template_sel.STRING_PATTERN);
                        break;
                    }
                    this.operator_assign(result);
                    break;
                }
                param.expr_type_error("a charstring");
                break;
            }
            default: {
                param.type_error("charstring template");
            }
        }
        this.is_ifPresent = param.get_ifpresent();
        if (param.get_length_restriction() != null) {
            this.set_length_range(param);
        }
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        Param_Types.Module_Parameter mp = null;
        switch (this.template_selection) {
            case UNINITIALIZED_TEMPLATE: {
                mp = new Param_Types.Module_Param_Unbound();
                break;
            }
            case OMIT_VALUE: {
                mp = new Param_Types.Module_Param_Omit();
                break;
            }
            case ANY_VALUE: {
                mp = new Param_Types.Module_Param_Any();
                break;
            }
            case ANY_OR_OMIT: {
                mp = new Param_Types.Module_Param_AnyOrNone();
                break;
            }
            case SPECIFIC_VALUE: {
                mp = this.single_value.get_param(param_name);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                mp = this.template_selection == Base_Template.template_sel.VALUE_LIST ? new Param_Types.Module_Param_List_Template() : new Param_Types.Module_Param_ComplementList_Template();
                for (int i = 0; i < this.value_list.size(); ++i) {
                    mp.add_elem(this.value_list.get(i).get_param(param_name));
                }
                break;
            }
            case VALUE_RANGE: {
                TitanUniversalChar lower_bound = new TitanUniversalChar('\u0000', '\u0000', '\u0000', this.min_value.get_value().charAt(0));
                TitanUniversalChar upper_bound = new TitanUniversalChar('\u0000', '\u0000', '\u0000', this.max_value.get_value().charAt(0));
                mp = new Param_Types.Module_Param_StringRange(lower_bound, upper_bound, this.min_is_exclusive, this.max_is_exclusive);
                break;
            }
            case STRING_PATTERN: {
                mp = new Param_Types.Module_Param_Pattern(this.single_value.get_value().toString(), this.pattern_value_nocase);
                break;
            }
            case DECODE_MATCH: {
                throw new TtcnError("Referencing a decoded content matching template is not supported.");
            }
            default: {
                throw new TtcnError("Referencing an uninitialized/unsupported charstring template.");
            }
        }
        if (this.is_ifPresent) {
            mp.set_ifpresent();
        }
        mp.set_length_restriction(this.get_length_range());
        return mp;
    }

    public TitanCharString get_single_value() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: 
            case STRING_PATTERN: {
                break;
            }
            default: {
                throw new TtcnError("This template does not have single value.");
            }
        }
        return this.single_value;
    }

    static void log_pattern(int n_chars, String chars_ptr, boolean nocase) {
        TTCN_Logger.log_event_str("pattern ");
        if (nocase) {
            TTCN_Logger.log_event_str("@nocase ");
        }
        TTCN_Logger.log_event_str("\"");
        LogPatternState state = LogPatternState.INITIAL;
        block33: for (int i = 0; i < n_chars; ++i) {
            char c = chars_ptr.charAt(i);
            if (' ' <= c) {
                switch (c) {
                    case '\"': {
                        TTCN_Logger.log_event_str("\\\"");
                        break;
                    }
                    case '{': {
                        if (state == LogPatternState.BACKSLASH || state == LogPatternState.BACKSLASH_Q) {
                            TTCN_Logger.log_char('{');
                            break;
                        }
                        TTCN_Logger.log_event_str("\\{");
                        break;
                    }
                    case '}': {
                        if (state == LogPatternState.BACKSLASH || state == LogPatternState.QUADRUPLE) {
                            TTCN_Logger.log_char('}');
                            break;
                        }
                        TTCN_Logger.log_event_str("\\}");
                        break;
                    }
                    case ' ': {
                        if (state != LogPatternState.INITIAL && state != LogPatternState.BACKSLASH) break;
                    }
                    default: {
                        TTCN_Logger.log_char(c);
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '\t': {
                        if (state != LogPatternState.INITIAL && state != LogPatternState.BACKSLASH) break;
                        TTCN_Logger.log_event_str("\\t");
                        break;
                    }
                    case '\r': {
                        if (state != LogPatternState.INITIAL && state != LogPatternState.BACKSLASH) break;
                        TTCN_Logger.log_event_str("\\r");
                        break;
                    }
                    case '\n': 
                    case '\u000b': 
                    case '\f': {
                        if (state != LogPatternState.INITIAL && state != LogPatternState.BACKSLASH) break;
                    }
                    default: {
                        TTCN_Logger.log_event("\\q{0,0,0," + c + "}", new Object[0]);
                    }
                }
            }
            switch (state) {
                case INITIAL: {
                    switch (c) {
                        case '\\': {
                            state = LogPatternState.BACKSLASH;
                            continue block33;
                        }
                        case '#': {
                            state = LogPatternState.HASHMARK;
                            continue block33;
                        }
                    }
                    continue block33;
                }
                case BACKSLASH: {
                    if (c == 'q') {
                        state = LogPatternState.BACKSLASH_Q;
                        continue block33;
                    }
                    state = LogPatternState.INITIAL;
                    continue block33;
                }
                case BACKSLASH_Q: {
                    switch (c) {
                        case '{': {
                            state = LogPatternState.QUADRUPLE;
                            continue block33;
                        }
                        case '\t': 
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            continue block33;
                        }
                    }
                    state = LogPatternState.INITIAL;
                    continue block33;
                }
                case HASHMARK: {
                    switch (c) {
                        case '(': {
                            state = LogPatternState.REPETITIONS;
                            continue block33;
                        }
                        case '\t': 
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            continue block33;
                        }
                    }
                    state = LogPatternState.INITIAL;
                    continue block33;
                }
                case QUADRUPLE: 
                case REPETITIONS: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                        case ',': {
                            continue block33;
                        }
                    }
                    if (Character.isDigit(c)) continue block33;
                    state = LogPatternState.INITIAL;
                }
            }
        }
        TTCN_Logger.log_char('\"');
    }

    public void log_match(TitanCharString match_value, boolean legacy) {
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT == TTCN_Logger.get_matching_verbosity() && TTCN_Logger.get_logmatch_buffer_len() != 0) {
            TTCN_Logger.print_logmatch_buffer();
            TTCN_Logger.log_event_str(" := ");
        }
        match_value.log();
        TTCN_Logger.log_event_str(" with ");
        this.log();
        if (this.match(match_value)) {
            TTCN_Logger.log_event_str(" matched");
        } else {
            TTCN_Logger.log_event_str(" unmatched");
        }
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.encode_text_restricted(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case STRING_PATTERN: {
                text_buf.push_int(this.pattern_value_nocase ? 1 : 0);
                this.single_value.encode_text(text_buf);
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value.encode_text(text_buf);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                text_buf.push_int(this.value_list.size());
                for (int i = 0; i < this.value_list.size(); ++i) {
                    this.value_list.get(i).encode_text(text_buf);
                }
                break;
            }
            case VALUE_RANGE: {
                if (!this.min_is_set) {
                    throw new TtcnError("Text encoder: The lower bound is not set in a charstring value range template.");
                }
                if (!this.max_is_set) {
                    throw new TtcnError("Text encoder: The upper bound is not set in a charstring value range template.");
                }
                byte[] temp = new byte[]{(byte)this.min_value.get_value().charAt(0), (byte)this.max_value.get_value().charAt(0)};
                text_buf.push_raw(temp);
                break;
            }
            default: {
                throw new TtcnError("Text encoder: Encoding an uninitialized/unsupported charstring template.");
            }
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        this.decode_text_restricted(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case STRING_PATTERN: {
                this.pattern_value_regexp_init = false;
                int temp = text_buf.pull_int().get_int();
                this.pattern_value_nocase = temp == 1;
                this.single_value = new TitanCharString();
                this.single_value.decode_text(text_buf);
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value = new TitanCharString();
                this.single_value.decode_text(text_buf);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                int size = text_buf.pull_int().get_int();
                this.value_list = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    TitanCharString_template temp = new TitanCharString_template();
                    temp.decode_text(text_buf);
                    this.value_list.add(temp);
                }
                break;
            }
            case VALUE_RANGE: {
                byte[] temp = new byte[1];
                text_buf.pull_raw(1, temp);
                this.min_value = new TitanCharString();
                this.min_value.get_value().setCharAt(0, (char)temp[0]);
                text_buf.pull_raw(1, temp);
                this.max_value = new TitanCharString();
                this.max_value.get_value().setCharAt(0, (char)temp[0]);
                this.min_is_set = true;
                this.max_is_set = true;
                this.min_is_exclusive = false;
                this.max_is_exclusive = false;
                break;
            }
            default: {
                throw new TtcnError("Text decoder: An unknown/unsupported selection was received for a charstring template.");
            }
        }
    }

    @Override
    public void check_restriction(Base_Template.template_res restriction, String name, boolean legacy) {
        if (this.template_selection == Base_Template.template_sel.UNINITIALIZED_TEMPLATE) {
            return;
        }
        switch (name != null && restriction == Base_Template.template_res.TR_VALUE ? Base_Template.template_res.TR_OMIT : restriction) {
            case TR_VALUE: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_OMIT: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.OMIT_VALUE && this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_PRESENT: {
                if (this.match_omit(legacy)) break;
                return;
            }
            default: {
                return;
            }
        }
        throw new TtcnError(MessageFormat.format("Restriction `{0}'' on template of type {1} violated.", TitanCharString_template.get_res_name(restriction), name == null ? "charstring" : name));
    }

    private static enum LogPatternState {
        INITIAL,
        BACKSLASH,
        BACKSLASH_Q,
        QUADRUPLE,
        HASHMARK,
        REPETITIONS;

    }
}

