/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;

public class ProjectAnalyzerJob
extends WorkspaceJob {
    private IProject project;

    public ProjectAnalyzerJob(String name) {
        super(name);
    }

    public final IStatus runInWorkspace(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.project == null) {
            return new Status(4, "org.eclipse.titanium", "Project not specified for ProjectAnalyzerJob");
        }
        ProjectSourceParser parser = GlobalParser.getProjectSourceParser((IProject)this.project);
        WorkspaceJob job = parser.analyzeAll();
        if (job == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Display disp = Display.getDefault();
                    Shell shell = new Shell(disp, 1264);
                    shell.setText("Unavailable operation");
                    String errorMessage = "This operation can not be executed while project parsing is disabled.\n\nPlease enable parsing on the preference page: Window/Preferences/ TITAN Preferences/On-the-fly checker/ Enable parsing of TTCN-3, ASN.1 and Runtime Configuration files";
                    MessageDialog.openInformation((Shell)shell, (String)"Confronting settings", (String)"This operation can not be executed while project parsing is disabled.\n\nPlease enable parsing on the preference page: Window/Preferences/ TITAN Preferences/On-the-fly checker/ Enable parsing of TTCN-3, ASN.1 and Runtime Configuration files");
                }
            });
            return Status.CANCEL_STATUS;
        }
        IStatus preStatus = this.doPreWork((IProgressMonitor)progress.newChild(20));
        progress.setWorkRemaining(80);
        if (!preStatus.isOK()) {
            return preStatus;
        }
        try {
            job.join();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while analyzing", (Throwable)e);
        }
        progress.setWorkRemaining(30);
        return this.doPostWork((IProgressMonitor)progress.newChild(30));
    }

    public IStatus doPreWork(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public IStatus doPostWork(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject p) {
        this.project = p;
    }

    public ProjectAnalyzerJob quickSchedule(IProject project) {
        this.project = project;
        this.setSystem(false);
        this.setUser(true);
        this.schedule();
        return this;
    }
}

