/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PressShortCutRule
extends GenerationSimpleRule {
    String widgetLocator;
    Widget widget;
    private char keyChar;
    private int modifier;

    @Override
    public boolean appliesTo(Event event) {
        return event.type == 1 && event.stateMask != 0 && (event.stateMask != 131072 || !Character.isUpperCase(event.character));
    }

    @Override
    public void initializeForEvent(Event event) {
        this.widget = event.widget;
        this.keyChar = event.character;
        this.modifier = event.stateMask;
        this.widgetLocator = WidgetUtils.widgetLocator(this.widget);
    }

    @Override
    public List<String> getActions() {
        ArrayList<String> res = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        line.append(this.widgetLocator);
        line.append(".pressShortcut(");
        line.append(PressShortCutRule.computeString(this.modifier));
        if (this.keyChar != '\u0000') {
            line.append(", ");
            line.append('\'');
            line.append(this.keyChar);
            line.append('\'');
        }
        line.append(")");
        res.add(line.toString());
        return res;
    }

    private static String computeString(int modifier) {
        if (modifier == 0) {
            return "SWT.NONE";
        }
        StringBuilder res = new StringBuilder();
        if ((modifier & 0x40000) != 0) {
            res.append("SWT.CTRL");
        }
        if ((modifier & 0x10000) != 0) {
            if (res.length() > 0) {
                res.append(" | ");
            }
            res.append("SWT.ALT");
        }
        if ((modifier & 0x20000) != 0) {
            if (res.length() > 0) {
                res.append(" | ");
            }
            res.append("SWT.SHIFT");
        }
        return res.toString();
    }

    @Override
    public List<String> getImports() {
        return null;
    }

    @Override
    public Widget getWidget() {
        return this.widget;
    }
}

