/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextMenuRule
extends GenerationSimpleRule {
    private List<String> path;
    private String menu;
    private MenuItem item;
    private String widgetAccessor;

    @Override
    public boolean appliesTo(Event event) {
        boolean menu = event.widget instanceof MenuItem;
        int style = 0;
        if (menu) {
            MenuItem currentItem = (MenuItem)event.widget;
            Menu parent = null;
            while (currentItem != null && (parent = currentItem.getParent()) != null) {
                style = parent.getStyle();
                currentItem = parent.getParentItem();
            }
        }
        return event.type == 13 && menu && (style & 8) != 0;
    }

    @Override
    public void initializeForEvent(Event event) {
        this.item = (MenuItem)event.widget;
        this.menu = WidgetUtils.cleanText(this.item.getText());
        this.path = new ArrayList<String>();
        MenuItem currentItem = this.item;
        Menu parent = null;
        while (currentItem != null && (parent = currentItem.getParent()) != null) {
            currentItem = parent.getParentItem();
            if (currentItem == null || currentItem.getText() == null) continue;
            this.path.add(WidgetUtils.cleanText(currentItem.getText()));
        }
        Collections.reverse(this.path);
        this.widgetAccessor = WidgetUtils.widgetLocator(this.item);
    }

    @Override
    public List<String> getActions() {
        StringBuilder res = new StringBuilder();
        res.append(this.widgetAccessor);
        res.append(".click()");
        return Arrays.asList(res.toString());
    }

    @Override
    public List<String> getImports() {
        return null;
    }

    public MenuItem getWidget() {
        return this.item;
    }

    public List<String> getPath() {
        return this.path;
    }

    public void setPath(List<String> path) {
        this.path = path;
    }

    public String getMenu() {
        return this.menu;
    }

    public void setMenu(String menu) {
        this.menu = menu;
    }
}

