/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.jdt.editor.listener;

import java.util.Map;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swtbot.generator.jdt.editor.document.ClassDocument;
import org.eclipse.swtbot.generator.jdt.editor.listener.AnnotationSelectionListener;
import org.eclipse.swtbot.generator.ui.BotGeneratorEventDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSelectionListener
extends SelectionAdapter {
    private ToolItem dropdown;
    private Map<CTabItem, SourceViewer> tabViewer;
    private CTabFolder classTabFolder;
    private Menu menu;
    private ToolItem annotationsToolItem;

    public MethodSelectionListener(ToolItem dropdown, BotGeneratorEventDispatcher recorder, Map<CTabItem, SourceViewer> tabViewer, CTabFolder classTabFolder, ToolItem annotationsToolItem) {
        this.dropdown = dropdown;
        this.menu = new Menu((Control)dropdown.getParent());
        this.classTabFolder = classTabFolder;
        this.tabViewer = tabViewer;
        this.annotationsToolItem = annotationsToolItem;
    }

    public void add(String item) {
        MenuItem menuItem = new MenuItem(this.menu, 0);
        menuItem.setText(item);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MenuItem selected = (MenuItem)event.widget;
                MethodSelectionListener.this.dropdown.setText(selected.getText());
                SourceViewer viewer = (SourceViewer)MethodSelectionListener.this.tabViewer.get(MethodSelectionListener.this.classTabFolder.getSelection());
                ClassDocument doc = (ClassDocument)viewer.getDocument();
                doc.setActiveMethod(selected.getText());
                ((AnnotationSelectionListener)((Object)MethodSelectionListener.this.annotationsToolItem.getData())).update();
                viewer.setTopIndex(((ClassDocument)viewer.getDocument()).getLastOffset() - 4);
            }
        });
        this.dropdown.setText(item);
        SourceViewer viewer = this.tabViewer.get(this.classTabFolder.getSelection());
        ClassDocument doc = (ClassDocument)viewer.getDocument();
        doc.setActiveMethod(menuItem.getText());
        ((AnnotationSelectionListener)((Object)this.annotationsToolItem.getData())).update();
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.detail == 4) {
            ToolItem item = (ToolItem)event.widget;
            Rectangle rect = item.getBounds();
            Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
            this.menu.setLocation(pt.x, pt.y + rect.height);
            this.menu.setVisible(true);
        }
    }
}

