/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.discovery;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

public class WorkbenchUtil {
    public static void openUrl(String location) {
        WorkbenchUtil.openUrl(location, 0);
    }

    public static void openUrl(String location, int customFlags) {
        try {
            URL url = null;
            if (location != null) {
                url = new URL(location);
            }
            if (WebBrowserPreference.getBrowserChoice() == 1 || (customFlags & 0x80) != 0) {
                try {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    support.getExternalBrowser().openURL(url);
                }
                catch (PartInitException e) {
                    Status status = new Status(4, "org.eclipse.team.svn.core.svnnature", SVNUIMessages.WorkbenchUtil_Browser_Initialization_Failed);
                    MessageDialog.openError((Shell)UIMonitorUtility.getShell(), (String)SVNUIMessages.WorkbenchUtil_Open_Location_Title, (String)status.getMessage());
                }
            } else {
                IWebBrowser browser = null;
                int flags = customFlags;
                flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? (flags |= 0x26) : (flags |= 0x86);
                String generatedId = "org.eclipse.team.svn.ui.web.browser-" + Calendar.getInstance().getTimeInMillis();
                browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, generatedId, null, null);
                browser.openURL(url);
            }
        }
        catch (PartInitException e) {
            LoggedOperation.reportError((String)WorkbenchUtil.class.toString(), (Throwable)e);
            Status status = new Status(4, "org.eclipse.team.svn.core.svnnature", SVNUIMessages.WorkbenchUtil_Browser_Initialization_Failed, (Throwable)e);
            MessageDialog.openError((Shell)UIMonitorUtility.getShell(), (String)SVNUIMessages.WorkbenchUtil_Open_Location_Title, (String)status.getMessage());
        }
        catch (MalformedURLException e) {
            if (location != null && location.trim().equals("")) {
                Status status = new Status(2, "org.eclipse.team.svn.core.svnnature", SVNUIMessages.WorkbenchUtil_No_URL_Error, (Throwable)e);
                MessageDialog.openWarning((Shell)UIMonitorUtility.getShell(), (String)SVNUIMessages.WorkbenchUtil_Open_Location_Title, (String)status.getMessage());
            }
            Status status = new Status(4, "org.eclipse.team.svn.core.svnnature", SVNUIMessages.format((String)SVNUIMessages.WorkbenchUtil_Invalid_URL_Error, (Object)location), (Throwable)e);
            MessageDialog.openError((Shell)UIMonitorUtility.getShell(), (String)SVNUIMessages.WorkbenchUtil_Open_Location_Title, (String)status.getMessage());
        }
    }
}

