/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote.management;

import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRevisionLink;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.eclipse.team.svn.ui.dialog.DiscardConfirmationDialog;
import org.eclipse.team.svn.ui.operation.RefreshRepositoryLocationsOperation;
import org.eclipse.team.svn.ui.repository.model.RepositoryRevision;

public class DiscardRevisionLinksAction
extends AbstractRepositoryTeamAction {
    public void runImpl(IAction action) {
        final RepositoryRevision[] revisions = (RepositoryRevision[])this.getAdaptedSelection(RepositoryRevision.class);
        DiscardConfirmationDialog dialog = new DiscardConfirmationDialog(this.getShell(), revisions.length == 1, 1);
        if (dialog.open() == 0) {
            HashSet<IRepositoryLocation> locations = new HashSet<IRepositoryLocation>();
            int i = 0;
            while (i < revisions.length) {
                locations.add(revisions[i].getRevisionLink().getRepositoryResource().getRepositoryLocation());
                ++i;
            }
            AbstractActionOperation mainOp = new AbstractActionOperation("Operation_RemoveRevisionLinks", SVNUIMessages.class){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    int i = 0;
                    while (i < revisions.length) {
                        final IRevisionLink link = revisions[i].getRevisionLink();
                        this.protectStep(new IUnprotectedOperation(){

                            public void run(IProgressMonitor monitor) throws Exception {
                                IRepositoryLocation location = link.getRepositoryResource().getRepositoryLocation();
                                location.removeRevisionLink(link);
                            }
                        }, monitor, revisions.length);
                        ++i;
                    }
                }
            };
            CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new SaveRepositoryLocationsOperation());
            op.add((IActionOperation)new RefreshRepositoryLocationsOperation(locations.toArray(new IRepositoryLocation[locations.size()]), true));
            this.runBusy((IActionOperation)op);
        }
    }

    public boolean isEnabled() {
        return ((RepositoryRevision[])this.getAdaptedSelection(RepositoryRevision.class)).length > 0;
    }
}

