/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.core.state.model;

import org.eclipse.linuxtools.lttng.core.TraceDebug;
import org.eclipse.linuxtools.lttng.core.state.model.LttngProcessState;

final class ProcessStateKey {
    private long pid;
    private long cpuId;
    private String traceId;

    private ProcessStateKey() {
    }

    public ProcessStateKey(LttngProcessState newRef) {
        this.pid = newRef.getPid();
        this.cpuId = newRef.getCpu();
        this.traceId = newRef.getTrace_id();
    }

    public ProcessStateKey(Long newPid, Long newCpuId, String newTraceId) {
        this.pid = newPid;
        this.cpuId = newCpuId;
        this.traceId = newTraceId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        boolean isSame = true;
        if (obj instanceof ProcessStateKey) {
            ProcessStateKey procKey = (ProcessStateKey)obj;
            if (procKey.pid != this.pid) {
                return false;
            }
            if (!procKey.traceId.equals(this.traceId)) {
                return false;
            }
            if (procKey.pid == 0L && procKey.cpuId != this.cpuId) {
                return false;
            }
        } else {
            TraceDebug.debug("ERROR : The received Key is not of the type ProcessStateKey! but " + obj.getClass().toString());
            return false;
        }
        return isSame;
    }

    public int hashCode() {
        return 1 ^ (int)(this.pid ^ this.pid >>> 32) ^ this.traceId.hashCode();
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.pid)) + ":" + this.traceId;
    }
}

