/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.internal.callgraph.CallgraphPlugin;
import org.eclipse.linuxtools.internal.callgraph.Messages;
import org.eclipse.linuxtools.internal.callgraph.StapData;
import org.eclipse.linuxtools.internal.callgraph.StapGraph;
import org.eclipse.linuxtools.internal.callgraph.StapGraphParser;
import org.eclipse.linuxtools.internal.callgraph.StapNode;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapParser;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapUIErrorMessages;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapView;
import org.eclipse.linuxtools.internal.callgraph.graphlisteners.AutoScrollSelectionListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class CallgraphView
extends SystemTapView {
    private StapGraphParser parser;
    private Action view_treeview;
    private Action view_radialview;
    private Action view_aggregateview;
    private Action view_levelview;
    private Action view_refresh;
    private Action animation_slow;
    private Action animation_fast;
    private Action mode_collapsednodes;
    private Action markers_next;
    private Action markers_previous;
    private Action limits;
    private Action goto_next;
    private Action goto_previous;
    private Action goto_last;
    private Action play;
    private Action save_dot;
    private Action save_col_dot;
    private Action save_cur_dot;
    private Action save_text;
    ImageDescriptor playImage = CallgraphPlugin.getImageDescriptor("icons/perform.png");
    ImageDescriptor pauseImage = CallgraphPlugin.getImageDescriptor("icons/pause.gif");
    private IMenuManager menu;
    private IMenuManager gotoMenu;
    private IMenuManager view;
    private IMenuManager animation;
    private IMenuManager markers;
    private IMenuManager saveMenu;
    public IToolBarManager mgr;
    private Composite graphComp;
    private Composite treeComp;
    private StapGraph g;
    private int treeSize = 200;

    public IStatus initializeView(Display targetDisplay, IProgressMonitor monitor) {
        Display disp = targetDisplay;
        if (disp == null) {
            disp = Display.getCurrent();
        }
        if (disp == null) {
            disp = Display.getDefault();
        }
        this.treeSize = 200;
        this.makeTreeComp(this.treeSize);
        this.makeGraphComp();
        this.graphComp.setBackgroundMode(2);
        Canvas papaCanvas = new Canvas(this.graphComp, 2048);
        GridLayout papaLayout = new GridLayout(1, true);
        papaLayout.horizontalSpacing = 0;
        papaLayout.verticalSpacing = 0;
        papaLayout.marginHeight = 0;
        papaLayout.marginWidth = 0;
        papaCanvas.setLayout((Layout)papaLayout);
        GridData papaGD = new GridData(1, 1, false, false);
        papaGD.widthHint = 160;
        papaCanvas.setLayoutData((Object)papaGD);
        Image image = CallgraphPlugin.getImageDescriptor("icons/up.gif").createImage();
        Button up = new Button((Composite)papaCanvas, 8);
        GridData buttonData = new GridData(0x1000000, 0x1000000, true, false);
        buttonData.widthHint = 150;
        buttonData.heightHint = 20;
        up.setData((Object)buttonData);
        up.setImage(image);
        up.setToolTipText(Messages.getString("CallgraphView.ThumbNailUp"));
        Canvas thumbCanvas = new Canvas((Composite)papaCanvas, 0);
        image = CallgraphPlugin.getImageDescriptor("icons/down.gif").createImage();
        Button down = new Button((Composite)papaCanvas, 8);
        buttonData = new GridData(0x1000000, 0x1000000, true, false);
        buttonData.widthHint = 150;
        buttonData.heightHint = 0;
        down.setData((Object)buttonData);
        down.setImage(image);
        down.setToolTipText(Messages.getString("CallgraphView.ThumbNailDown"));
        this.g = new StapGraph(this.graphComp, 2048, this.treeComp, papaCanvas, this);
        this.g.setLayoutData(new GridData(this.masterComposite.getBounds().width, Display.getCurrent().getBounds().height - this.treeSize));
        up.addSelectionListener((SelectionListener)new AutoScrollSelectionListener(0, this.g));
        down.addSelectionListener((SelectionListener)new AutoScrollSelectionListener(1, this.g));
        GridData thumbGD = new GridData(1, 1, false, false);
        thumbGD.widthHint = 160;
        thumbCanvas.setLayoutData((Object)thumbGD);
        LightweightSystem lws = new LightweightSystem(thumbCanvas);
        ScrollableThumbnail thumb = new ScrollableThumbnail(this.g.getViewport());
        thumb.setSource(this.g.getContents());
        lws.setContents((IFigure)thumb);
        this.loadData(monitor);
        return this.finishLoad(monitor);
    }

    private IStatus loadData(IProgressMonitor mon) {
        IProgressMonitor monitor = mon;
        if (this.g.getNodeData(0) == null) {
            this.g.loadData(0, 0, StapGraph.CONSTANT_TOP_NODE_NAME, 1L, 1, -1, false, "");
        }
        this.g.setStartTime(this.parser.startTime);
        this.g.setEndTime(this.parser.endingTimeInNS);
        for (int id_parent : this.parser.serialMap.keySet()) {
            if (id_parent < 0) continue;
            boolean marked = false;
            String msg = "";
            if (this.g.getNodeData(id_parent) == null) {
                if (this.parser.markedMap.get(id_parent) != null) {
                    marked = true;
                    msg = this.parser.markedMap.remove(id_parent);
                }
                this.g.loadData(0, id_parent, this.parser.serialMap.get(id_parent), this.parser.timeMap.get(id_parent), 1, 0, marked, msg);
            }
            for (int key : this.parser.neighbourMaps.keySet()) {
                HashMap<Integer, ArrayList<Integer>> outNeighbours = this.parser.neighbourMaps.get(key);
                if (outNeighbours == null || outNeighbours.get(id_parent) == null) continue;
                for (int id_child : outNeighbours.get(id_parent)) {
                    if (this.g.getNodeData(id_child) != null && id_child < 0) {
                        this.g.addCalled(id_child);
                        continue;
                    }
                    if (this.g.getNodeData(id_child) != null) continue;
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    marked = false;
                    msg = "";
                    if (this.parser.markedMap.get(id_child) != null) {
                        marked = true;
                        msg = this.parser.markedMap.remove(id_child);
                    }
                    if (id_child == -1) continue;
                    if (this.parser.timeMap.get(id_child) == null) {
                        this.g.loadData(0, id_child, this.parser.serialMap.get(id_child), this.parser.timeMap.get(0), 1, id_parent, marked, msg);
                        continue;
                    }
                    this.g.loadData(0, id_child, this.parser.serialMap.get(id_child), this.parser.timeMap.get(id_child), 1, id_parent, marked, msg);
                }
            }
            if (this.parser.neighbourMaps.size() <= 1) continue;
            this.g.setThreaded();
        }
        monitor.worked(1);
        if (this.parser.markedMap.size() > 0) {
            for (int key : this.parser.markedMap.keySet()) {
                this.g.insertMessage(key, this.parser.markedMap.get(key));
            }
            this.parser.markedMap.clear();
        }
        if (this.g.aggregateTime == null) {
            this.g.aggregateTime = new HashMap();
        }
        if (this.g.aggregateCount == null) {
            this.g.aggregateCount = new HashMap();
        }
        this.g.aggregateCount.putAll(this.parser.countMap);
        this.g.aggregateTime.putAll(this.parser.aggregateTimeMap);
        this.g.setLastFunctionCalled(0);
        this.g.recursivelyCollapseAllChildrenOfNode(this.g.getTopNode());
        monitor.worked(1);
        this.setGraphOptions(true);
        this.g.initializeTree();
        this.g.setProject(this.parser.project);
        return Status.OK_STATUS;
    }

    private IStatus finishLoad(IProgressMonitor monitor) {
        if (this.g.aggregateCount == null) {
            this.g.aggregateCount = new HashMap();
        }
        this.g.aggregateCount.putAll(this.parser.countMap);
        if (this.g.aggregateTime == null) {
            this.g.aggregateTime = new HashMap();
        }
        this.g.aggregateTime.putAll(this.parser.aggregateTimeMap);
        if (this.parser.totalTime != -1L) {
            this.g.setTotalTime(this.parser.totalTime);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.g.initializeTree();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.g.setCallOrderList(this.parser.callOrderList);
        this.g.setProject(this.parser.project);
        this.initializePartControl();
        return Status.OK_STATUS;
    }

    public void setGraphOptions(boolean visible) {
        this.play.setEnabled(visible);
        this.save_file.setEnabled(visible);
        this.save_dot.setEnabled(visible);
        this.save_col_dot.setEnabled(visible);
        this.save_cur_dot.setEnabled(visible);
        this.save_text.setEnabled(visible);
        this.view_treeview.setEnabled(visible);
        this.view_radialview.setEnabled(visible);
        this.view_aggregateview.setEnabled(visible);
        this.view_levelview.setEnabled(visible);
        this.view_refresh.setEnabled(visible);
        this.limits.setEnabled(visible);
        this.markers_next.setEnabled(visible);
        this.markers_previous.setEnabled(visible);
        this.animation_slow.setEnabled(visible);
        this.animation_fast.setEnabled(visible);
        this.mode_collapsednodes.setEnabled(visible);
        this.goto_next.setEnabled(visible);
        this.goto_previous.setEnabled(visible);
        this.goto_last.setEnabled(visible);
    }

    public void makeTreeComp(int treeSize) {
        if (this.treeComp != null && !this.treeComp.isDisposed()) {
            this.treeComp.dispose();
        }
        this.treeComp = new Composite(this.masterComposite, 0);
        GridData treegd = new GridData(1, 4, false, true);
        treegd.widthHint = treeSize;
        this.treeComp.setLayout((Layout)new FillLayout());
        this.treeComp.setLayoutData((Object)treegd);
    }

    public void makeGraphComp() {
        if (this.graphComp != null && !this.graphComp.isDisposed()) {
            this.graphComp.dispose();
        }
        this.graphComp = new Composite(this.masterComposite, 0);
        GridData graphgd = new GridData(4, 4, true, true);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        this.graphComp.setLayout((Layout)gl);
        this.graphComp.setLayoutData((Object)graphgd);
    }

    private void initializePartControl() {
        this.setGraphOptions(true);
        if (this.graphComp == null) {
            return;
        }
        this.graphComp.setParent(this.masterComposite);
        if (this.treeComp != null) {
            this.treeComp.setParent(this.masterComposite);
        }
        this.graphComp.setSize(this.masterComposite.getSize().x, this.masterComposite.getSize().y);
    }

    public void createPartControl(Composite parent) {
        if (this.masterComposite != null) {
            this.masterComposite.dispose();
        }
        this.masterComposite = parent;
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        GridData gd = new GridData(100, 100);
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)gd);
        this.createActions();
        this.mgr = this.getViewSite().getActionBars().getToolBarManager();
        this.menu = this.getViewSite().getActionBars().getMenuManager();
        this.addFileMenu();
        this.save_cur_dot = new Action(Messages.getString("CallgraphView.SaveViewAsDot")){

            public void run() {
                CallgraphView.this.writeToDot(CallgraphView.this.g.getCollapseMode(), ((CallgraphView)CallgraphView.this).g.nodeMap.keySet());
            }
        };
        this.save_dot = new Action(Messages.getString("CallgraphView.SaveAllUncollapsedAsDot")){

            public void run() {
                CallgraphView.this.writeToDot(false, ((CallgraphView)CallgraphView.this).g.nodeDataMap.keySet());
            }
        };
        this.save_col_dot = new Action(Messages.getString("CallgraphView.SaveAllCollapsedAsDot")){

            public void run() {
                CallgraphView.this.writeToDot(true, ((CallgraphView)CallgraphView.this).g.nodeDataMap.keySet());
            }
        };
        this.save_text = new Action(Messages.getString("CallgraphView.SaveCollapsedAsASCII")){

            public void run() {
                Shell sh = new Shell();
                FileDialog dialog = new FileDialog(sh, 8192);
                String filePath = dialog.open();
                if (filePath == null) {
                    return;
                }
                File f = new File(filePath);
                f.delete();
                try {
                    f.createNewFile();
                    BufferedWriter out = new BufferedWriter(new FileWriter(f));
                    StringBuilder builder = new StringBuilder();
                    builder.append("                           Function                           | Called |  Time\n");
                    for (StapData k : ((CallgraphView)CallgraphView.this).g.nodeDataMap.values()) {
                        if (!k.isCollapsed && !k.isOnlyChildWithThisName()) continue;
                        if (k.isCollapsed) {
                            StringBuilder name = new StringBuilder(k.name);
                            name = CallgraphView.this.fixString(name, 60);
                            builder.append(" " + name + " | ");
                            StringBuilder called = new StringBuilder("" + k.timesCalled);
                            called = CallgraphView.this.fixString(called, 6);
                            StringBuilder time = new StringBuilder(StapNode.numberFormat.format((float)k.getTime() / (float)CallgraphView.this.g.getTotalTime() * 100.0f) + "%");
                            time = CallgraphView.this.fixString(time, 6);
                            builder.append(called + " | " + time + "\n");
                        }
                        if (builder.length() <= 2000) continue;
                        out.append(builder.toString());
                        out.flush();
                        builder.setLength(0);
                    }
                    if (builder.length() > 0) {
                        out.append(builder.toString());
                    }
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        this.saveMenu = new MenuManager(Messages.getString("CallgraphView.SaveMenu"));
        this.file.add((IContributionItem)this.saveMenu);
        this.saveMenu.add((IAction)this.save_cur_dot);
        this.saveMenu.add((IAction)this.save_col_dot);
        this.saveMenu.add((IAction)this.save_text);
        this.saveMenu.add((IAction)this.save_dot);
        this.view = new MenuManager(Messages.getString("CallgraphView.ViewMenu"));
        this.animation = new MenuManager(Messages.getString("CallgraphView.AnimationMenu"));
        this.markers = new MenuManager(Messages.getString("CallgraphView.Markers"));
        this.gotoMenu = new MenuManager(Messages.getString("CallgraphView.GoTo"));
        this.menu.add((IContributionItem)this.view);
        this.menu.add((IContributionItem)this.gotoMenu);
        this.addHelpMenu();
        this.view.add((IAction)this.view_treeview);
        this.view.add((IAction)this.view_radialview);
        this.view.add((IAction)this.view_aggregateview);
        this.view.add((IAction)this.view_levelview);
        this.view.add((IAction)this.getView_refresh());
        this.view.add((IAction)this.mode_collapsednodes);
        this.view.add((IAction)this.limits);
        this.view.add((IContributionItem)this.animation);
        this.gotoMenu.add((IAction)this.play);
        this.gotoMenu.add((IAction)this.goto_previous);
        this.gotoMenu.add((IAction)this.goto_next);
        this.gotoMenu.add((IAction)this.goto_last);
        this.gotoMenu.add((IContributionItem)this.markers);
        this.addKillButton();
        this.mgr.add((IAction)this.play);
        this.mgr.add((IAction)this.view_radialview);
        this.mgr.add((IAction)this.view_treeview);
        this.mgr.add((IAction)this.view_levelview);
        this.mgr.add((IAction)this.view_aggregateview);
        this.mgr.add((IAction)this.mode_collapsednodes);
        this.markers.add((IAction)this.markers_next);
        this.markers.add((IAction)this.markers_previous);
        this.animation.add((IAction)this.animation_slow);
        this.animation.add((IAction)this.animation_fast);
        this.setGraphOptions(false);
    }

    public StringBuilder fixString(StringBuilder name, int length) {
        if (name.length() > length) {
            name = new StringBuilder(name.substring(0, length - 1));
        } else {
            int diff = length - name.length();
            boolean left = true;
            while (diff > 0) {
                if (left) {
                    name.insert(0, " ");
                    left = false;
                } else {
                    name.append(" ");
                    left = true;
                }
                --diff;
            }
        }
        return name;
    }

    public void createViewActions() {
        this.view_treeview = new Action(Messages.getString("CallgraphView.TreeView")){

            public void run() {
                CallgraphView.this.g.draw(2, CallgraphView.this.g.getAnimationMode(), CallgraphView.this.g.getRootVisibleNodeNumber());
                CallgraphView.this.g.scrollTo(((CallgraphView)CallgraphView.this).g.getNode((int)((CallgraphView)CallgraphView.this).g.getRootVisibleNodeNumber()).getLocation().x - ((CallgraphView)CallgraphView.this).g.getBounds().width / 2, ((CallgraphView)CallgraphView.this).g.getNode((int)((CallgraphView)CallgraphView.this).g.getRootVisibleNodeNumber()).getLocation().y);
                if (CallgraphView.this.play != null) {
                    CallgraphView.this.play.setEnabled(true);
                }
            }
        };
        ImageDescriptor treeImage = CallgraphPlugin.getImageDescriptor("icons/tree_view.gif");
        this.view_treeview.setImageDescriptor(treeImage);
        this.view_radialview = new Action(Messages.getString("CallgraphView.RadialView")){

            public void run() {
                CallgraphView.this.g.draw(1, CallgraphView.this.g.getAnimationMode(), CallgraphView.this.g.getRootVisibleNodeNumber());
                if (CallgraphView.this.play != null) {
                    CallgraphView.this.play.setEnabled(true);
                }
            }
        };
        ImageDescriptor d = CallgraphPlugin.getImageDescriptor("/icons/radial_view.gif");
        this.view_radialview.setImageDescriptor(d);
        this.view_aggregateview = new Action(Messages.getString("CallgraphView.AggregateView")){

            public void run() {
                CallgraphView.this.g.draw(3, CallgraphView.this.g.getAnimationMode(), CallgraphView.this.g.getRootVisibleNodeNumber());
                if (CallgraphView.this.play != null) {
                    CallgraphView.this.play.setEnabled(false);
                }
            }
        };
        ImageDescriptor aggregateImage = CallgraphPlugin.getImageDescriptor("/icons/view_aggregateview.gif");
        this.view_aggregateview.setImageDescriptor(aggregateImage);
        this.view_levelview = new Action(Messages.getString("CallgraphView.LevelView")){

            public void run() {
                CallgraphView.this.g.draw(0, CallgraphView.this.g.getAnimationMode(), CallgraphView.this.g.getRootVisibleNodeNumber());
                if (CallgraphView.this.play != null) {
                    CallgraphView.this.play.setEnabled(true);
                }
            }
        };
        ImageDescriptor levelImage = CallgraphPlugin.getImageDescriptor("/icons/showchild_mode.gif");
        this.view_levelview.setImageDescriptor(levelImage);
        this.setView_refresh(new Action(Messages.getString("CallgraphView.Reset")){

            public void run() {
                CallgraphView.this.g.reset();
            }
        });
        ImageDescriptor refreshImage = CallgraphPlugin.getImageDescriptor("/icons/nav_refresh.gif");
        this.getView_refresh().setImageDescriptor(refreshImage);
    }

    public void createAnimateActions() {
        this.animation_slow = new Action(Messages.getString("CallgraphView.AnimationSlow"), 8){

            public void run() {
                CallgraphView.this.g.setAnimationMode(1);
                this.setChecked(true);
                CallgraphView.this.animation_slow.setChecked(true);
                CallgraphView.this.animation_fast.setChecked(false);
            }
        };
        this.animation_slow.setChecked(true);
        this.animation_fast = new Action(Messages.getString("CallgraphView.AnimationFast"), 8){

            public void run() {
                CallgraphView.this.g.setAnimationMode(3);
                CallgraphView.this.animation_slow.setChecked(false);
                CallgraphView.this.animation_fast.setChecked(true);
            }
        };
        this.mode_collapsednodes = new Action(Messages.getString("CallgraphView.CollapsedMode"), 2){

            public void run() {
                if (CallgraphView.this.g.isCollapseMode()) {
                    CallgraphView.this.g.setCollapseMode(false);
                    CallgraphView.this.g.draw(CallgraphView.this.g.getRootVisibleNodeNumber());
                } else {
                    CallgraphView.this.g.setCollapseMode(true);
                    CallgraphView.this.g.draw(CallgraphView.this.g.getRootVisibleNodeNumber());
                }
            }
        };
        ImageDescriptor newImage = CallgraphPlugin.getImageDescriptor("icons/mode_collapsednodes.gif");
        this.mode_collapsednodes.setImageDescriptor(newImage);
        this.limits = new Action(Messages.getString("CallgraphView.SetLimits"), 1){
            private Spinner limit;
            private Spinner buffer;
            private Shell sh;

            public void run() {
                this.sh = new Shell();
                this.sh.setLayout((Layout)new GridLayout());
                this.sh.setSize(150, 200);
                Label limitLabel = new Label((Composite)this.sh, 0);
                limitLabel.setLayoutData((Object)new GridData(0x1000000, -1, true, false));
                limitLabel.setText(Messages.getString("CallgraphView.MaxNodes"));
                this.limit = new Spinner((Composite)this.sh, 2048);
                this.limit.setMaximum(5000);
                this.limit.setSelection(CallgraphView.this.g.getMaxNodes());
                this.limit.setLayoutData((Object)new GridData(0x1000000, -1, true, false));
                Label bufferLabel = new Label((Composite)this.sh, 0);
                bufferLabel.setLayoutData((Object)new GridData(0x1000000, -1, true, false));
                bufferLabel.setText(Messages.getString("CallgraphView.MaxDepth"));
                this.buffer = new Spinner((Composite)this.sh, 2048);
                this.buffer.setMaximum(5000);
                this.buffer.setSelection(CallgraphView.this.g.getLevelBuffer());
                this.buffer.setLayoutData((Object)new GridData(0x1000000, -1, true, false));
                Button set_limit = new Button((Composite)this.sh, 8);
                set_limit.setText(Messages.getString("CallgraphView.SetValues"));
                set_limit.setLayoutData((Object)new GridData(0x1000000, -1, true, false));
                set_limit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean redraw = false;
                        if (limit.getSelection() >= 0 && buffer.getSelection() >= 0) {
                            CallgraphView.this.g.setMaxNodes(limit.getSelection());
                            CallgraphView.this.g.setLevelBuffer(buffer.getSelection());
                            if (CallgraphView.this.g.changeLevelLimits(CallgraphView.this.g.getLevelOfNode(CallgraphView.this.g.getRootVisibleNodeNumber()))) {
                                SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("CallgraphView.BufferTooHigh"), Messages.getString("CallgraphView.BufferTooHigh"), String.valueOf(Messages.getString("CallgraphView.BufferMessage1")) + Messages.getString("CallgraphView.BufferMessage2") + Messages.getString("CallgraphView.BufferMessage3") + Messages.getString("CallgraphView.BufferMessage4") + CallgraphView.this.g.getLevelBuffer() + Messages.getString("CallgraphView.BufferMessage5") + "\n" + "\n" + Messages.getString("CallgraphView.BufferMessage6") + Messages.getString("CallgraphView.BufferMessage7"));
                                mess.schedule();
                            }
                            redraw = true;
                        }
                        sh.dispose();
                        if (redraw) {
                            CallgraphView.this.g.draw();
                        }
                    }
                });
                this.sh.open();
            }
        };
    }

    public void createActions() {
        this.createViewActions();
        this.createAnimateActions();
        this.createMarkerActions();
        this.createMovementActions();
        this.mode_collapsednodes.setChecked(true);
    }

    public void createMovementActions() {
        this.goto_next = new Action(Messages.getString("CallgraphView.Next")){

            public void run() {
                CallgraphView.this.g.drawNextNode();
            }
        };
        this.goto_previous = new Action(Messages.getString("CallgraphView.Previous")){

            public void run() {
                int toDraw;
                if (CallgraphView.this.g.isCollapseMode()) {
                    CallgraphView.this.g.setCollapseMode(false);
                }
                if ((toDraw = CallgraphView.this.g.getPreviousCalledNode(CallgraphView.this.g.getRootVisibleNodeNumber())) != -1) {
                    CallgraphView.this.g.draw(toDraw);
                }
            }
        };
        this.goto_last = new Action(Messages.getString("CallgraphView.Last")){

            public void run() {
                if (CallgraphView.this.g.isCollapseMode()) {
                    CallgraphView.this.g.setCollapseMode(false);
                }
                CallgraphView.this.g.draw(CallgraphView.this.g.getLastFunctionCalled());
            }
        };
        this.play = new Action(Messages.getString("CallgraphView.Play")){

            public void run() {
                if (CallgraphView.this.g.getDrawMode() != 3) {
                    CallgraphView.this.g.play();
                    CallgraphView.this.togglePlayImage();
                }
            }
        };
        this.play.setImageDescriptor(this.playImage);
    }

    protected void togglePlayImage() {
        if (this.play.getToolTipText() == Messages.getString("CallgraphView.Pause")) {
            this.play.setImageDescriptor(this.playImage);
            this.play.setToolTipText(Messages.getString("CallgraphView.Play"));
        } else {
            this.play.setImageDescriptor(this.pauseImage);
            this.play.setToolTipText("");
        }
    }

    public void createMarkerActions() {
        this.markers_next = new Action(Messages.getString("CallgraphView.nextMarker")){

            public void run() {
                CallgraphView.this.g.draw(CallgraphView.this.g.getNextMarkedNode());
            }
        };
        this.markers_previous = new Action(Messages.getString("CallgraphView.previousMarker")){

            public void run() {
                CallgraphView.this.g.draw(CallgraphView.this.g.getPreviousMarkedNode());
            }
        };
    }

    protected boolean createOpenAction() {
        this.open_file = new Action(Messages.getString("CallgraphView.Open")){

            public void run() {
                try {
                    FileDialog dialog = new FileDialog(new Shell(), -1);
                    String filePath = dialog.open();
                    if (filePath != null) {
                        StapGraphParser new_parser = new StapGraphParser();
                        new_parser.setSourcePath(filePath);
                        new_parser.setViewID("org.eclipse.linuxtools.callgraph.callgraphview");
                        new_parser.schedule();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        return true;
    }

    protected boolean createOpenDefaultAction() {
        this.open_default = new Action(Messages.getString("CallgraphView.OpenLastRun")){

            public void run() {
                try {
                    StapGraphParser new_parser = new StapGraphParser();
                    new_parser.setViewID("org.eclipse.linuxtools.callgraph.callgraphview");
                    new_parser.schedule();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        return true;
    }

    public boolean setParser(SystemTapParser newParser) {
        if (newParser instanceof StapGraphParser) {
            this.parser = (StapGraphParser)newParser;
            return true;
        }
        return false;
    }

    public void setViewID() {
        this.viewID = "org.eclipse.linuxtools.callgraph.callgraphview";
    }

    public Action getAnimation_slow() {
        return this.animation_slow;
    }

    public void setAnimation_slow(Action animation_slow) {
        this.animation_slow = animation_slow;
    }

    public Action getAnimation_fast() {
        return this.animation_fast;
    }

    public void setAnimation_fast(Action animation_fast) {
        this.animation_fast = animation_fast;
    }

    public IMenuManager getAnimation() {
        return this.animation;
    }

    public void setAnimation(IMenuManager animation) {
        this.animation = animation;
    }

    public Action getMode_collapsednodes() {
        return this.mode_collapsednodes;
    }

    public void setMode_collapsednodes(Action mode_collapsednodes) {
        this.mode_collapsednodes = mode_collapsednodes;
    }

    public void setView_refresh(Action view_refresh) {
        this.view_refresh = view_refresh;
    }

    public Action getView_refresh() {
        return this.view_refresh;
    }

    public Action getGoto_next() {
        return this.goto_next;
    }

    public void setGoto_next(Action gotoNext) {
        this.goto_next = gotoNext;
    }

    public Action getGoto_previous() {
        return this.goto_previous;
    }

    public void setGoto_parent(Action gotoParent) {
        this.goto_previous = gotoParent;
    }

    public Action getGoto_last() {
        return this.goto_last;
    }

    public void setGoto_last(Action gotoLast) {
        this.goto_last = gotoLast;
    }

    public Action getView_treeview() {
        return this.view_treeview;
    }

    public void setView_treeview(Action viewTreeview) {
        this.view_treeview = viewTreeview;
    }

    public Action getView_radialview() {
        return this.view_radialview;
    }

    public void setView_radialview(Action viewRadialview) {
        this.view_radialview = viewRadialview;
    }

    public Action getView_aggregateview() {
        return this.view_aggregateview;
    }

    public void setView_aggregateview(Action viewAggregateview) {
        this.view_aggregateview = viewAggregateview;
    }

    public Action getView_levelview() {
        return this.view_levelview;
    }

    public void setView_levelview(Action viewlevelview) {
        this.view_levelview = viewlevelview;
    }

    public void setGoto_previous(Action gotoPrevious) {
        this.goto_previous = gotoPrevious;
    }

    public Action getPlay() {
        return this.play;
    }

    public StapGraph getGraph() {
        return this.g;
    }

    public void setFocus() {
    }

    public void updateMethod() {
        NullProgressMonitor m = new NullProgressMonitor();
        m.beginTask("Updating callgraph", 4);
        this.loadData((IProgressMonitor)m);
        m.worked(1);
        if (this.parser.totalTime > 0L) {
            this.finishLoad((IProgressMonitor)m);
        }
        m.worked(1);
        this.g.draw(1, 1, this.g.getFirstUsefulNode());
    }

    public SystemTapParser getParser() {
        return this.parser;
    }

    private void writeToDot(boolean mode, Set<Integer> keySet) {
        Shell sh = new Shell();
        FileDialog dialog = new FileDialog(sh, 8192);
        String filePath = dialog.open();
        if (filePath != null) {
            File f = new File(filePath);
            f.delete();
            try {
                f.createNewFile();
            }
            catch (IOException iOException) {
                return;
            }
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(f));
                StringBuilder build = new StringBuilder("");
                out.write("digraph stapgraph {\n");
                for (int i : keySet) {
                    if (i == 0) continue;
                    StapData d = this.g.getNodeData(i);
                    if (d.isCollapsed != mode && !d.isOnlyChildWithThisName()) continue;
                    build.append(String.valueOf(i) + " [label=\"" + d.name + " ");
                    build.append(String.valueOf(StapNode.numberFormat.format((float)d.getTime() / (float)this.g.getTotalTime() * 100.0f)) + "%\"]\n");
                    int j = d.parent;
                    if (mode) {
                        j = d.collapsedParent;
                    }
                    if (!keySet.contains(j) || j == 0) continue;
                    String called = mode ? " [label=\"" + this.g.getNodeData((int)i).timesCalled + "\"]\n" : "\n";
                    build.append(String.valueOf(j) + "->" + i);
                    build.append(called);
                    out.write(build.toString());
                    build.setLength(0);
                }
                out.write("}");
                out.flush();
                out.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

