/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.trace;

import java.util.Arrays;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;

public class TmfLocationArray
implements Comparable<TmfLocationArray>,
Cloneable {
    private ITmfLocation<? extends Comparable<?>>[] fLocations;

    public TmfLocationArray(ITmfLocation<? extends Comparable<?>>[] locations) {
        this.fLocations = locations;
    }

    public ITmfLocation<? extends Comparable<?>>[] getLocations() {
        return this.fLocations;
    }

    public TmfLocationArray clone() {
        ITmfLocation[] clones = new ITmfLocation[this.fLocations.length];
        int i = 0;
        while (i < this.fLocations.length) {
            clones[i] = this.fLocations[i].clone();
            ++i;
        }
        return new TmfLocationArray(clones);
    }

    @Override
    public int compareTo(TmfLocationArray o) {
        int i = 0;
        while (i < this.fLocations.length) {
            ITmfLocation l1 = (ITmfLocation)((Object)this.fLocations[i].getLocation());
            ITmfLocation l2 = (ITmfLocation)((Object)o.fLocations[i].getLocation());
            int result = l1.getLocation().compareTo(l2.getLocation());
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fLocations);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfLocationArray other = (TmfLocationArray)obj;
        return Arrays.equals(this.fLocations, other.fLocations);
    }

    public String toString() {
        return "TmfLocationArray [locations=" + Arrays.toString(this.fLocations) + "]";
    }
}

