/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.util.Collection;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Vector;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputReader;
import org.eclipse.linuxtools.internal.ctf.core.Activator;
import org.eclipse.linuxtools.internal.ctf.core.trace.Stream;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInput;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputReaderTimestampComparator;

public class CTFTraceReader {
    private final CTFTrace trace;
    private final Vector<StreamInputReader> streamInputReaders = new Vector();
    protected PriorityQueue<StreamInputReader> prio;
    private long[] eventCountPerTraceFile;
    private long startTime;
    private long endTime;

    protected void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public CTFTraceReader(CTFTrace trace) {
        this.trace = trace;
        this.streamInputReaders.clear();
        this.createStreamInputReaders();
        this.populateStreamInputReaderHeap();
        this.startTime = 0L;
        if (this.hasMoreEvents()) {
            this.startTime = this.prio.peek().getCurrentEvent().getTimestamp();
            this.setEndTime(this.startTime);
        }
    }

    public CTFTraceReader copyFrom() {
        CTFTraceReader newReader = null;
        newReader = new CTFTraceReader(this.trace);
        newReader.startTime = this.startTime;
        newReader.setEndTime(this.endTime);
        return newReader;
    }

    public long getStartTime() {
        return this.startTime;
    }

    private void createStreamInputReaders() {
        Collection<Stream> streams = this.trace.getStreams().values();
        for (Stream stream : streams) {
            Set<StreamInput> streamInputs = stream.getStreamInputs();
            for (StreamInput streamInput : streamInputs) {
                streamInput.getIndex().getEntries().clear();
                StreamInputReader streamInputReader = new StreamInputReader(streamInput);
                this.streamInputReaders.add(streamInputReader);
            }
        }
        this.eventCountPerTraceFile = new long[this.streamInputReaders.size()];
    }

    private void populateStreamInputReaderHeap() {
        this.prio = new PriorityQueue<StreamInputReader>(this.streamInputReaders.size() * 2, new StreamInputReaderTimestampComparator());
        int pos = 0;
        for (StreamInputReader reader : this.streamInputReaders) {
            reader.setParent(this);
            if (!reader.readNextEvent()) continue;
            this.prio.add(reader);
            this.eventCountPerTraceFile[pos] = 0L;
            reader.setName(pos);
            ++pos;
        }
    }

    public EventDefinition getCurrentEventDef() {
        StreamInputReader top = this.getTopStream();
        return top != null ? top.getCurrentEvent() : null;
    }

    public boolean advance() {
        StreamInputReader top = this.prio.poll();
        if (top == null) {
            return false;
        }
        if (top.readNextEvent()) {
            this.prio.add(top);
            long topEnd = top.getCurrentEvent().getTimestamp() + this.getTrace().getOffset();
            this.setEndTime(Math.max(topEnd, this.getEndTime()));
            int n = top.getName();
            this.eventCountPerTraceFile[n] = this.eventCountPerTraceFile[n] + 1L;
            if (top.getCurrentEvent() != null) {
                this.endTime = Math.max(top.getCurrentEvent().getTimestamp(), this.endTime);
            }
        }
        return this.hasMoreEvents();
    }

    public void goToLastEvent() {
        this.seek(this.getEndTime());
        while (this.prio.size() > 1) {
            this.advance();
        }
    }

    public boolean seek(long timestamp) {
        this.prio.clear();
        for (StreamInputReader streamInputReader : this.streamInputReaders) {
            streamInputReader.seek(timestamp);
        }
        for (StreamInputReader streamInputReader : this.streamInputReaders) {
            if (streamInputReader.getCurrentEvent() == null) continue;
            this.prio.add(streamInputReader);
        }
        return this.hasMoreEvents();
    }

    private long goToZero() {
        for (StreamInputReader streamInputReader : this.streamInputReaders) {
            streamInputReader.seek(0L);
        }
        long tempIndex = 0L;
        return tempIndex;
    }

    public StreamInputReader getTopStream() {
        return this.prio.peek();
    }

    public boolean hasMoreEvents() {
        return this.prio.size() > 0;
    }

    public void printStats() {
        this.printStats(60);
    }

    public void printStats(int width) {
        int numEvents = 0;
        if (width == 0) {
            return;
        }
        long[] lArray = this.eventCountPerTraceFile;
        int n = this.eventCountPerTraceFile.length;
        int n2 = 0;
        while (n2 < n) {
            long i = lArray[n2];
            numEvents = (int)((long)numEvents + i);
            ++n2;
        }
        int j = 0;
        while (j < this.eventCountPerTraceFile.length) {
            StreamInputReader se = this.streamInputReaders.get(j);
            long len = (long)width * this.eventCountPerTraceFile[se.getName()] / (long)numEvents;
            StringBuilder sb = new StringBuilder(String.valueOf(se.getFilename()) + "\t[");
            int i = 0;
            while ((long)i < len) {
                sb.append('+');
                ++i;
            }
            long i2 = len;
            while (i2 < (long)width) {
                sb.append(' ');
                ++i2;
            }
            sb.append("]\t" + this.eventCountPerTraceFile[se.getName()] + " Events");
            Activator.getDefault().log(sb.toString());
            ++j;
        }
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + (this.streamInputReaders == null ? 0 : this.streamInputReaders.hashCode());
        result = 31 * result + (this.trace == null ? 0 : this.trace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CTFTraceReader)) {
            return false;
        }
        CTFTraceReader other = (CTFTraceReader)obj;
        if (this.streamInputReaders == null ? other.streamInputReaders != null : !this.streamInputReaders.equals(other.streamInputReaders)) {
            return false;
        }
        return !(this.trace == null ? other.trace != null : !this.trace.equals(other.trace));
    }

    public String toString() {
        return "CTFTraceReader [trace=" + this.trace + ']';
    }

    public CTFTrace getTrace() {
        return this.trace;
    }
}

