/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.findreplace;

import java.util.LinkedList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.linuxtools.dataviewers.findreplace.STViewerRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class STTreeViewerRow
extends STViewerRow<TreeItem> {
    public STTreeViewerRow(TreeItem item) {
        super(item);
    }

    public Rectangle getBounds() {
        return ((TreeItem)this.getItem()).getBounds();
    }

    public Rectangle getBounds(int columnIndex) {
        return ((TreeItem)this.getItem()).getBounds(columnIndex);
    }

    public int getColumnCount() {
        return ((TreeItem)this.getItem()).getParent().getColumnCount();
    }

    public Color getBackground(int columnIndex) {
        return ((TreeItem)this.getItem()).getBackground(columnIndex);
    }

    public Font getFont(int columnIndex) {
        return ((TreeItem)this.getItem()).getFont(columnIndex);
    }

    public Color getForeground(int columnIndex) {
        return ((TreeItem)this.getItem()).getForeground(columnIndex);
    }

    public Image getImage(int columnIndex) {
        return ((TreeItem)this.getItem()).getImage(columnIndex);
    }

    public String getText(int columnIndex) {
        return ((TreeItem)this.getItem()).getText(columnIndex);
    }

    public void setBackground(int columnIndex, Color color) {
        ((TreeItem)this.getItem()).setBackground(columnIndex, color);
    }

    public void setFont(int columnIndex, Font font) {
        ((TreeItem)this.getItem()).setFont(columnIndex, font);
    }

    public void setForeground(int columnIndex, Color color) {
        ((TreeItem)this.getItem()).setForeground(columnIndex, color);
    }

    public void setImage(int columnIndex, Image image) {
        Image oldImage = ((TreeItem)this.getItem()).getImage(columnIndex);
        if (image != oldImage) {
            ((TreeItem)this.getItem()).setImage(columnIndex, image);
        }
    }

    public void setText(int columnIndex, String text) {
        ((TreeItem)this.getItem()).setText(columnIndex, text == null ? "" : text);
    }

    public Tree getControl() {
        return ((TreeItem)this.getItem()).getParent();
    }

    @Override
    protected ViewerRow getRowBelow(boolean sameLevel) {
        Tree tree = ((TreeItem)this.getItem()).getParent();
        if (((TreeItem)this.getItem()).getParentItem() == null) {
            if (sameLevel || !((TreeItem)this.getItem()).getExpanded()) {
                int index = tree.indexOf((TreeItem)this.getItem()) + 1;
                if (index < tree.getItemCount()) {
                    return new STTreeViewerRow(tree.getItem(index));
                }
            } else if (((TreeItem)this.getItem()).getExpanded() && ((TreeItem)this.getItem()).getItemCount() > 0) {
                return new STTreeViewerRow(((TreeItem)this.getItem()).getItem(0));
            }
        } else if (sameLevel || !((TreeItem)this.getItem()).getExpanded()) {
            int totalIndex;
            TreeItem parentItem = ((TreeItem)this.getItem()).getParentItem();
            int nextIndex = parentItem.indexOf((TreeItem)this.getItem()) + 1;
            TreeItem itemAfter = nextIndex == (totalIndex = parentItem.getItemCount()) ? this.findNextItem(parentItem) : parentItem.getItem(nextIndex);
            if (itemAfter != null) {
                return new STTreeViewerRow(itemAfter);
            }
        } else if (((TreeItem)this.getItem()).getExpanded() && ((TreeItem)this.getItem()).getItemCount() > 0) {
            return new STTreeViewerRow(((TreeItem)this.getItem()).getItem(0));
        }
        return null;
    }

    @Override
    protected ViewerRow getRowAbove(boolean sameLevel) {
        Tree tree = ((TreeItem)this.getItem()).getParent();
        if (((TreeItem)this.getItem()).getParentItem() == null) {
            int index = tree.indexOf((TreeItem)this.getItem()) - 1;
            TreeItem nextTopItem = null;
            if (index >= 0) {
                nextTopItem = tree.getItem(index);
            }
            if (nextTopItem != null) {
                if (sameLevel) {
                    return new STTreeViewerRow(nextTopItem);
                }
                return new STTreeViewerRow(this.findLastVisibleItem(nextTopItem));
            }
        } else {
            TreeItem parentItem = ((TreeItem)this.getItem()).getParentItem();
            int previousIndex = parentItem.indexOf((TreeItem)this.getItem()) - 1;
            TreeItem itemBefore = previousIndex >= 0 ? (sameLevel ? parentItem.getItem(previousIndex) : this.findLastVisibleItem(parentItem.getItem(previousIndex))) : parentItem;
            if (itemBefore != null) {
                return new STTreeViewerRow(itemBefore);
            }
        }
        return null;
    }

    private TreeItem findLastVisibleItem(TreeItem parentItem) {
        TreeItem rv = parentItem;
        while (rv.getExpanded() && rv.getItemCount() > 0) {
            rv = rv.getItem(rv.getItemCount() - 1);
        }
        return rv;
    }

    private TreeItem findNextItem(TreeItem item) {
        int totalItems;
        int nextIndex;
        TreeItem rv = null;
        Tree tree = item.getParent();
        TreeItem parentItem = item.getParentItem();
        if (parentItem == null) {
            nextIndex = tree.indexOf(item) + 1;
            totalItems = tree.getItemCount();
        } else {
            nextIndex = parentItem.indexOf(item) + 1;
            totalItems = parentItem.getItemCount();
        }
        if (nextIndex == totalItems) {
            if (item.getParentItem() != null) {
                rv = this.findNextItem(item.getParentItem());
            }
        } else {
            rv = parentItem == null ? tree.getItem(nextIndex) : parentItem.getItem(nextIndex);
        }
        return rv;
    }

    public TreePath getTreePath() {
        TreeItem tItem = (TreeItem)this.getItem();
        LinkedList<Object> segments = new LinkedList<Object>();
        while (tItem != null) {
            Object segment = tItem.getData();
            Assert.isNotNull((Object)segment);
            segments.addFirst(segment);
            tItem = tItem.getParentItem();
        }
        return new TreePath(segments.toArray());
    }

    public STTreeViewerRow clone() {
        return new STTreeViewerRow((TreeItem)this.getItem());
    }
}

