/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class TmfExperimentElement
extends TmfProjectModelElement
implements IPropertySource2 {
    private static final String sfInfoCategory = "Info";
    private static final String sfName = "name";
    private static final String sfPath = "path";
    private static final String sfLocation = "location";
    private static final TextPropertyDescriptor sfNameDescriptor = new TextPropertyDescriptor((Object)"name", "name");
    private static final TextPropertyDescriptor sfPathDescriptor = new TextPropertyDescriptor((Object)"path", "path");
    private static final TextPropertyDescriptor sfLocationDescriptor = new TextPropertyDescriptor((Object)"location", "location");
    private static final IPropertyDescriptor[] sfDescriptors = new IPropertyDescriptor[]{sfNameDescriptor, sfPathDescriptor, sfLocationDescriptor};

    static {
        sfNameDescriptor.setCategory(sfInfoCategory);
        sfPathDescriptor.setCategory(sfInfoCategory);
        sfLocationDescriptor.setCategory(sfInfoCategory);
    }

    public TmfExperimentElement(String name, IFolder folder, TmfExperimentFolder parent) {
        super(name, (IResource)folder, parent);
        parent.addChild(this);
    }

    public IFolder getResource() {
        return (IFolder)this.fResource;
    }

    @Override
    public TmfProjectElement getProject() {
        return (TmfProjectElement)this.getParent().getParent();
    }

    public List<TmfTraceElement> getTraces() {
        List<ITmfProjectModelElement> children = this.getChildren();
        ArrayList<TmfTraceElement> traces = new ArrayList<TmfTraceElement>();
        for (ITmfProjectModelElement child : children) {
            if (!(child instanceof TmfTraceElement)) continue;
            traces.add((TmfTraceElement)child);
        }
        return traces;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return sfDescriptors != null ? Arrays.copyOf(sfDescriptors, sfDescriptors.length) : null;
    }

    public Object getPropertyValue(Object id) {
        if (sfName.equals(id)) {
            return this.getName();
        }
        if (sfPath.equals(id)) {
            return this.getPath().toString();
        }
        if (sfLocation.equals(id)) {
            return this.getLocation().toString();
        }
        return null;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }
}

