/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.tmf.core.component.TmfDataProvider;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;

public class TmfProviderManager {
    private static Map<Class<? extends ITmfEvent>, List<TmfDataProvider<? extends ITmfEvent>>> fProviders = new HashMap<Class<? extends ITmfEvent>, List<TmfDataProvider<? extends ITmfEvent>>>();

    private TmfProviderManager() {
    }

    public static <T extends ITmfEvent> void register(Class<T> eventType, TmfDataProvider<? extends ITmfEvent> provider) {
        if (fProviders.get(eventType) == null) {
            fProviders.put(eventType, new ArrayList());
        }
        fProviders.get(eventType).add(provider);
    }

    public static <T extends ITmfEvent> void deregister(Class<T> dataClass, TmfDataProvider<? extends ITmfEvent> provider) {
        List<TmfDataProvider<? extends ITmfEvent>> list = fProviders.get(dataClass);
        if (list != null) {
            list.remove(provider);
            if (list.size() == 0) {
                fProviders.remove(dataClass);
            }
        }
    }

    public static TmfDataProvider<? extends ITmfEvent>[] getProviders(Class<? extends ITmfEvent> dataClass) {
        List<TmfDataProvider<? extends ITmfEvent>> list = fProviders.get(dataClass);
        if (list == null) {
            list = new ArrayList<TmfDataProvider<? extends ITmfEvent>>();
        }
        TmfDataProvider[] result = new TmfDataProvider[list.size()];
        return list.toArray(result);
    }

    public static TmfDataProvider<? extends ITmfEvent>[] getProviders(Class<? extends ITmfEvent> dataClass, Class<? extends TmfDataProvider<? extends ITmfEvent>> providerClass) {
        if (providerClass == null) {
            return TmfProviderManager.getProviders(dataClass);
        }
        TmfDataProvider<? extends ITmfEvent>[] list = TmfProviderManager.getProviders(dataClass);
        ArrayList<TmfDataProvider<? extends ITmfEvent>> result = new ArrayList<TmfDataProvider<? extends ITmfEvent>>();
        if (list != null) {
            TmfDataProvider<? extends ITmfEvent>[] tmfDataProviderArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                TmfDataProvider<? extends ITmfEvent> provider = tmfDataProviderArray[n2];
                if (provider.getClass() == providerClass) {
                    result.add(provider);
                }
                ++n2;
            }
        }
        TmfDataProvider[] array = new TmfDataProvider[result.size()];
        return result.toArray(array);
    }
}

