/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.launch.configuration;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.linuxtools.oprofile.launch.OprofileLaunchMessages;
import org.eclipse.linuxtools.oprofile.launch.OprofileLaunchPlugin;
import org.eclipse.linuxtools.oprofile.launch.configuration.LaunchOptions;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OprofileSetupTab
extends AbstractLaunchConfigurationTab {
    protected Text _kernelImageFileText;
    protected Button _checkSeparateLibrary;
    protected Button _checkSeparateKernel;
    protected LaunchOptions _options = null;

    public String getName() {
        return OprofileLaunchMessages.getString("tab.global.name");
    }

    public boolean isValid(ILaunchConfiguration config) {
        boolean b = this._options.isValid();
        return b;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        this._options.saveConfiguration(config);
        try {
            config.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this._options.loadConfiguration(config);
        this._kernelImageFileText.setText(this._options.getKernelImageFile());
        int separate = this._options.getSeparateSamples();
        if (separate == 0) {
            this._checkSeparateLibrary.setSelection(false);
            this._checkSeparateKernel.setSelection(false);
        } else {
            if ((separate & 1) != 0) {
                this._checkSeparateLibrary.setSelection(true);
            }
            if ((separate & 2) != 0) {
                this._checkSeparateKernel.setSelection(true);
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this._options = new LaunchOptions();
        this._options.saveConfiguration(config);
        try {
            config.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public Image getImage() {
        return OprofileLaunchPlugin.getImageDescriptor("icons/global_tab.gif").createImage();
    }

    public void createControl(Composite parent) {
        this._options = new LaunchOptions();
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(top, 1);
        Composite p = new Composite(top, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        p.setLayout((Layout)layout);
        GridData data = new GridData(768);
        p.setLayoutData((Object)data);
        Label l = new Label(p, 0);
        l.setText(OprofileLaunchMessages.getString("tab.global.kernelImage.label.text"));
        data = new GridData();
        data.horizontalSpan = 2;
        l.setLayoutData((Object)data);
        this._kernelImageFileText = new Text(p, 2052);
        data = new GridData(768);
        this._kernelImageFileText.setLayoutData((Object)data);
        this._kernelImageFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent mev) {
                OprofileSetupTab.this._handleKernelImageFileTextModify(OprofileSetupTab.this._kernelImageFileText);
            }
        });
        Button button = this.createPushButton(p, OprofileLaunchMessages.getString("tab.global.kernelImage.browse.button.text"), null);
        final Shell shell = top.getShell();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent sev) {
                OprofileSetupTab.this._showFileDialog(shell);
            }
        });
        this.createVerticalSpacer(top, 1);
        p = new Composite(top, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        p.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        p.setLayoutData((Object)data);
        this._checkSeparateLibrary = this._createCheckButton(p, OprofileLaunchMessages.getString("tab.global.check.separateLibrary.text"));
        this._checkSeparateKernel = this._createCheckButton(p, OprofileLaunchMessages.getString("tab.global.check.separateKernel.text"));
    }

    private Button _createCheckButton(Composite parent, String label) {
        final Button b = new Button(parent, 32);
        b.setText(label);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                OprofileSetupTab.this._handleCheckSelected(b);
            }
        });
        return b;
    }

    private void _handleCheckSelected(Button button) {
        int oldSeparate;
        int newSeparate = oldSeparate = this._options.getSeparateSamples();
        if (button == this._checkSeparateLibrary) {
            newSeparate = button.getSelection() ? oldSeparate | 1 : oldSeparate & 0xFFFFFFFE;
        } else if (button == this._checkSeparateKernel) {
            newSeparate = button.getSelection() ? oldSeparate | 2 : oldSeparate & 0xFFFFFFFD;
        }
        this._options.setSeparateSamples(newSeparate);
        this.updateLaunchConfigurationDialog();
    }

    private void _handleKernelImageFileTextModify(Text text) {
        String errorMessage = null;
        String filename = text.getText();
        if (filename.length() > 0) {
            File file = new File(filename);
            if (!file.exists() || !file.isFile()) {
                String msg = OprofileLaunchMessages.getString("tab.global.kernelImage.kernel.nonexistent");
                Object[] args = new Object[]{filename};
                errorMessage = MessageFormat.format(msg, args);
            }
            this._options.setKernelImageFile(filename);
        } else {
            this._options.setKernelImageFile("");
        }
        this.setErrorMessage(errorMessage);
        this.updateLaunchConfigurationDialog();
    }

    private void _showFileDialog(Shell shell) {
        FileDialog d = new FileDialog(shell, 4096);
        File kernel = new File(this._options.getKernelImageFile());
        if (!kernel.exists() && !(kernel = new File("/boot")).exists()) {
            kernel = new File("/");
        }
        d.setFileName(kernel.toString());
        d.setText(OprofileLaunchMessages.getString("tab.global.selectKernelDialog.text"));
        String newKernel = d.open();
        if (newKernel != null) {
            kernel = new File(newKernel);
            if (!kernel.exists()) {
                MessageBox mb = new MessageBox(shell, 1281);
                mb.setMessage(OprofileLaunchMessages.getString("tab.global.selectKernelDialog.error.kernelDoesNotExist.text"));
                switch (mb.open()) {
                    case 1024: {
                        this._showFileDialog(shell);
                        break;
                    }
                }
            } else {
                this._kernelImageFileText.setText(newKernel);
            }
        }
    }
}

