/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools.ui.editors;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfWhitespaceDetector;

public class AutoconfMacroRule
implements IRule {
    protected IToken token;
    protected IWordDetector fDetector;
    protected IWhitespaceDetector fWsDetector = new AutoconfWhitespaceDetector();
    protected int fColumn = -1;
    protected static final int UNDEFINED = -1;
    private StringBuffer fBuffer = new StringBuffer();
    private String fStartingSequence;

    public AutoconfMacroRule(String startingSequence, IWordDetector detector, IToken inToken) {
        this.token = inToken;
        this.fDetector = detector;
        this.fStartingSequence = startingSequence;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        this.fBuffer.setLength(0);
        int i = 0;
        while (i < this.fStartingSequence.length()) {
            this.fBuffer.append((char)c);
            if (this.fStartingSequence.charAt(i) != c) {
                this.unreadBuffer(scanner);
                return Token.UNDEFINED;
            }
            c = scanner.read();
            ++i;
        }
        while (c != -1 && this.fDetector.isWordPart((char)c)) {
            this.fBuffer.append((char)c);
            c = scanner.read();
        }
        if (c != -1 && c != 40 && c != 59 && !this.fWsDetector.isWhitespace((char)c)) {
            this.unreadBuffer(scanner);
            return Token.UNDEFINED;
        }
        scanner.unread();
        return this.token;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

