/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.rpmlint.builder;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.rpm.rpmlint.builder.Messages;
import org.eclipse.linuxtools.rpm.rpmlint.builder.RpmlintDeltaVisitor;
import org.eclipse.linuxtools.rpm.rpmlint.builder.RpmlintMarkerVisitor;
import org.eclipse.linuxtools.rpm.rpmlint.builder.RpmlintPreVisitor;
import org.eclipse.linuxtools.rpm.rpmlint.parser.RpmlintItem;
import org.eclipse.linuxtools.rpm.rpmlint.parser.RpmlintParser;
import org.eclipse.linuxtools.rpm.ui.editor.markers.SpecfileErrorHandler;
import org.eclipse.linuxtools.rpm.ui.editor.markers.SpecfileTaskHandler;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpmlintBuilder
extends IncrementalProjectBuilder {
    public static final int MAX_WORKS = 100;
    public static final String BUILDER_ID = "org.eclipse.linuxtools.rpm.rpmlint.rpmlintBuilder";
    public static final String MARKER_ID = "org.eclipse.linuxtools.rpm.rpmlint.rpmlintProblem";
    private SpecfileParser specfileParser;
    private SpecfileErrorHandler errorHandler;
    private SpecfileTaskHandler taskHandler;

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.RpmlintBuilder_0, 100);
        monitor.worked(20);
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        RpmlintPreVisitor resourceVisitor = new RpmlintPreVisitor();
        this.getProject().accept((IResourceVisitor)resourceVisitor);
        this.checkCancel(monitor);
        monitor.worked(50);
        monitor.setTaskName(Messages.RpmlintBuilder_1);
        ArrayList<RpmlintItem> rpmlintItems = RpmlintParser.getInstance().parseVisisted(resourceVisitor.getVisitedPaths());
        this.visitAndMarkRpmlintItems(monitor, rpmlintItems);
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        RpmlintDeltaVisitor deltaVisitor = new RpmlintDeltaVisitor();
        delta.accept((IResourceDeltaVisitor)deltaVisitor);
        monitor.worked(50);
        monitor.setTaskName(Messages.RpmlintBuilder_1);
        ArrayList<RpmlintItem> rpmlintItems = RpmlintParser.getInstance().parseVisisted(deltaVisitor.getVisitedPaths());
        this.visitAndMarkRpmlintItems(monitor, rpmlintItems);
    }

    private void visitAndMarkRpmlintItems(IProgressMonitor monitor, ArrayList<RpmlintItem> rpmlintItems) throws CoreException {
        if (rpmlintItems.size() > 0) {
            this.checkCancel(monitor);
            monitor.worked(70);
            monitor.setTaskName(Messages.RpmlintBuilder_2);
            this.getProject().accept((IResourceVisitor)new RpmlintMarkerVisitor(this, rpmlintItems));
            monitor.worked(100);
        }
    }

    protected SpecfileParser getSpecfileParser() {
        if (this.specfileParser == null) {
            this.specfileParser = new SpecfileParser();
        }
        return this.specfileParser;
    }

    protected SpecfileErrorHandler getSpecfileErrorHandler(IFile file, String specContent) {
        if (this.errorHandler == null) {
            this.errorHandler = new SpecfileErrorHandler(file, (IDocument)new Document(specContent));
        } else {
            this.errorHandler.setFile(file);
            this.errorHandler.setDocument((IDocument)new Document(specContent));
        }
        return this.errorHandler;
    }

    protected SpecfileTaskHandler getSpecfileTaskHandler(IFile file, String specContent) {
        if (this.taskHandler == null) {
            this.taskHandler = new SpecfileTaskHandler(file, (IDocument)new Document(specContent));
        } else {
            this.taskHandler.setFile(file);
            this.taskHandler.setDocument((IDocument)new Document(specContent));
        }
        return this.taskHandler;
    }

    protected void checkCancel(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

