/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.timechart;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITmfTimeAnalysisEntry;
import org.eclipse.linuxtools.tmf.ui.views.colors.ColorSettingsManager;
import org.eclipse.linuxtools.tmf.ui.views.timechart.TimeChartAnalysisEntry;
import org.eclipse.linuxtools.tmf.ui.views.timechart.TimeChartDecorationProvider;

public class TimeChartEvent
implements ITimeEvent {
    private static final byte TIMESTAMP_SCALE = -9;
    private TimeChartAnalysisEntry fParentEntry;
    private long fTime;
    private long fDuration;
    private long fFirstRank;
    private long fLastRank;
    private RankRangeList fRankRangeList;
    private long fNbEvents;
    private int fColorSettingPriority;
    private boolean fIsBookmark;
    private boolean fIsVisible;
    private boolean fIsSearchMatch;
    private TimeChartAnalysisEntry fItemizedEntry;
    private boolean fItemizing;

    public TimeChartEvent(TimeChartAnalysisEntry parentEntry, ITmfEvent event, long rank, TimeChartDecorationProvider decorationProvider) {
        this.fParentEntry = parentEntry;
        this.fTime = event.getTimestamp().normalize(0L, -9).getValue();
        this.fDuration = 0L;
        this.fFirstRank = this.fLastRank = rank;
        this.fRankRangeList = new RankRangeList(rank);
        this.fNbEvents = 1L;
        this.fColorSettingPriority = ColorSettingsManager.getColorSettingPriority(event);
        this.fIsBookmark = decorationProvider.isBookmark(rank);
        this.fIsVisible = decorationProvider.isVisible(event);
        this.fIsSearchMatch = decorationProvider.isSearchMatch(event);
    }

    @Override
    public ITmfTimeAnalysisEntry getEntry() {
        return this.fParentEntry;
    }

    @Override
    public long getTime() {
        return this.fTime;
    }

    @Override
    public long getDuration() {
        return this.fDuration;
    }

    public long getFirstRank() {
        return this.fFirstRank;
    }

    public long getLastRank() {
        return this.fLastRank;
    }

    public RankRangeList getRankRangeList() {
        return this.fRankRangeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(TimeChartEvent event) {
        this.mergeDecorations(event);
        if (this.fTime == event.getTime() && this.fDuration == event.getDuration()) {
            return;
        }
        long endTime = Math.max(this.fTime + this.fDuration, event.getTime() + event.getDuration());
        this.fTime = Math.min(this.fTime, event.getTime());
        this.fDuration = endTime - this.fTime;
        this.fFirstRank = Math.min(this.fFirstRank, event.fFirstRank);
        this.fLastRank = Math.max(this.fLastRank, event.fLastRank);
        this.fNbEvents += event.fNbEvents;
        this.fItemizedEntry = null;
        RankRangeList rankRangeList = this.fRankRangeList;
        synchronized (rankRangeList) {
            this.fRankRangeList.merge(event.getRankRangeList());
        }
    }

    public void mergeDecorations(TimeChartEvent event) {
        this.fColorSettingPriority = Math.min(this.fColorSettingPriority, event.getColorSettingPriority());
        this.fIsBookmark |= event.fIsBookmark;
        this.fIsVisible |= event.fIsVisible;
        this.fIsSearchMatch |= event.fIsSearchMatch;
    }

    public long getNbEvents() {
        return this.fNbEvents;
    }

    public int getColorSettingPriority() {
        return this.fColorSettingPriority;
    }

    public void setColorSettingPriority(int priority) {
        this.fColorSettingPriority = priority;
    }

    public boolean isBookmarked() {
        return this.fIsBookmark;
    }

    public void setIsBookmarked(boolean isBookmarked) {
        this.fIsBookmark = isBookmarked;
    }

    public boolean isVisible() {
        return this.fIsVisible;
    }

    public void setIsVisible(boolean isVisible) {
        this.fIsVisible = isVisible;
    }

    public boolean isSearchMatch() {
        return this.fIsSearchMatch;
    }

    public void setIsSearchMatch(boolean isSearchMatch) {
        this.fIsSearchMatch = isSearchMatch;
    }

    public void setItemizedEntry(TimeChartAnalysisEntry timeAnalysisEntry) {
        this.fItemizedEntry = timeAnalysisEntry;
    }

    public TimeChartAnalysisEntry getItemizedEntry() {
        return this.fItemizedEntry;
    }

    public boolean isItemizing() {
        return this.fItemizing;
    }

    public void setItemizing(boolean itemizing) {
        this.fItemizing = itemizing;
    }

    public class RankRange {
        private long firstRank;
        private long lastRank;

        public RankRange(long firstRank, long lastRank) {
            this.firstRank = firstRank;
            this.lastRank = lastRank;
        }

        public long getFirstRank() {
            return this.firstRank;
        }

        public long getLastRank() {
            return this.lastRank;
        }

        public long distanceFrom(RankRange range) {
            if (range.lastRank < TimeChartEvent.this.fFirstRank) {
                return TimeChartEvent.this.fFirstRank - range.lastRank;
            }
            if (range.firstRank > TimeChartEvent.this.fLastRank) {
                return range.firstRank - TimeChartEvent.this.fLastRank;
            }
            return 0L;
        }

        public String toString() {
            return "[" + this.firstRank + "," + this.lastRank + "]";
        }
    }

    private class RankRangeList
    extends ArrayList<RankRange> {
        private static final long serialVersionUID = 6060485531208535986L;

        public RankRangeList(long rank) {
            super(1);
            this.add(new RankRange(rank, rank));
        }

        public void merge(RankRangeList rankRangeList) {
            long threshold = TimeChartEvent.this.fParentEntry.getTrace().getCacheSize();
            for (RankRange newRange : rankRangeList) {
                boolean merged = false;
                for (RankRange oldRange : TimeChartEvent.this.fRankRangeList) {
                    if (newRange.distanceFrom(oldRange) > threshold) continue;
                    oldRange.firstRank = Math.min(oldRange.firstRank, newRange.firstRank);
                    oldRange.lastRank = Math.max(oldRange.lastRank, newRange.lastRank);
                    merged = true;
                    break;
                }
                if (merged) continue;
                this.add(newRange);
            }
            Iterator iterator = TimeChartEvent.this.fRankRangeList.iterator();
            RankRange previous = null;
            while (iterator.hasNext()) {
                RankRange range = (RankRange)iterator.next();
                if (previous != null && range.distanceFrom(previous) <= threshold) {
                    previous.firstRank = Math.min(previous.firstRank, range.firstRank);
                    previous.lastRank = Math.max(previous.lastRank, range.lastRank);
                    iterator.remove();
                }
                previous = range;
            }
        }
    }
}

