/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.pdt;

import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.IModelServiceHolder;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.editor.browser.WaitForBrowserReadyHandler;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.actf.ui.util.timer.WaitExecSyncEventHandler;
import org.eclipse.actf.ui.util.timer.WaitExecSyncEventListener;
import org.eclipse.actf.visualization.internal.ui.pdt.PdtVisualizationPlugin;
import org.eclipse.actf.visualization.ui.IVisualizationView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

abstract class AbstructVisualizationActionForPdt {
    private static final String BROWSER_EDITOR_ID = "org.eclipse.ui.browser.editor";
    private static final String SWT_BROWSER_GET_TEXT_METHOD = "getText";
    private static final String SWT_BROWSER_CLASS = "org.eclipse.swt.browser.Browser";
    private static final String PHPBROWSER_ID = "org.eclipse.debug.ui.PHPBrowserOutput";
    private static final String LISTENER_KEY = "org.eclipse.actf.visualization.internal.ui.pdt.AbstructVisualizationActionForPdt";
    private IModelServiceHolder browserHolder;
    private IWebBrowserACTF browser;
    private String targetHtml = "";
    private File targetHtmlFile = null;
    private IWorkbenchWindow _window;
    private HashMap<String, WaitExecSyncEventListener> eventhandlerHolder = new HashMap();

    AbstructVisualizationActionForPdt() {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this._window = iWorkbenchWindow;
    }

    public void run(IAction iAction) {
        IModelService iModelService = ModelServiceUtils.getActiveModelService();
        if (iModelService != null && iModelService != this.browser) {
            this.visualize();
            return;
        }
        IEditorPart iEditorPart = PlatformUIUtil.getActiveEditor();
        if (iEditorPart != null && BROWSER_EDITOR_ID.equals(iEditorPart.getEditorSite().getId())) {
            this.visualize();
            return;
        }
        boolean bl = false;
        String string = this.getText(this._window.getActivePage());
        if (string != null && !string.equals(this.targetHtml)) {
            bl = true;
            this.targetHtml = string;
            if (this.targetHtmlFile != null) {
                this.targetHtmlFile.delete();
            }
            this.targetHtmlFile = this.saveToFile(this.targetHtml);
        }
        IEditorReference[] iEditorReferenceArray = this._window.getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference iEditorReference = iEditorReferenceArray[n2];
            if (iEditorReference.getEditor(false) == this.browserHolder) {
                if (bl) {
                    this.browser.navigate(this.targetHtmlFile.getAbsolutePath());
                    this.waitAndVisualize();
                    return;
                }
                this._window.getActivePage().activate((IWorkbenchPart)this.browserHolder.getEditorPart());
                this.visualize();
                return;
            }
            ++n2;
        }
        if (string != null) {
            ModelServiceUtils.launch((String)this.targetHtmlFile.getAbsolutePath());
            this.browser = (IWebBrowserACTF)ModelServiceUtils.getActiveModelService();
            this.browserHolder = ModelServiceUtils.getActiveModelServiceHolder();
            this.waitAndVisualize();
            return;
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    private void visualize() {
        try {
            IViewPart iViewPart = this._window.getActivePage().showView(this.getTargetViewId());
            if (iViewPart instanceof IVisualizationView) {
                ((IVisualizationView)iViewPart).doVisualize();
            }
        }
        catch (PartInitException partInitException) {}
    }

    private File saveToFile(String string) {
        File file = null;
        try {
            file = PdtVisualizationPlugin.getDefault().createTempFile("php", ".html");
            PrintWriter printWriter = new PrintWriter(file, "UTF-8");
            printWriter.print(string);
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {}
        return file;
    }

    private void waitAndVisualize() {
        if (this.browser != null) {
            IViewPart iViewPart = null;
            try {
                iViewPart = this._window.getActivePage().showView(this.getTargetViewId());
            }
            catch (PartInitException partInitException) {}
            if (iViewPart instanceof IVisualizationView) {
                final IVisualizationView iVisualizationView = (IVisualizationView)iViewPart;
                WaitForBrowserReadyHandler waitForBrowserReadyHandler = new WaitForBrowserReadyHandler(this.browser, 30.0, false, new Runnable(){

                    public void run() {
                        AbstructVisualizationActionForPdt.this.eventhandlerHolder.remove(AbstructVisualizationActionForPdt.LISTENER_KEY);
                        iVisualizationView.doVisualize();
                        PlatformUIUtil.showView((String)AbstructVisualizationActionForPdt.this.getTargetViewId());
                    }
                });
                this.eventhandlerHolder.put(LISTENER_KEY, new WaitExecSyncEventListener((WaitExecSyncEventHandler)waitForBrowserReadyHandler));
            }
        }
    }

    private String getText(IWorkbenchPage iWorkbenchPage) {
        if (iWorkbenchPage == null) {
            return null;
        }
        IViewReference[] iViewReferenceArray = iWorkbenchPage.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference iViewReference = iViewReferenceArray[n2];
            if (PHPBROWSER_ID.equals(iViewReference.getId())) {
                IViewPart[] iViewPartArray = iWorkbenchPage.getViewStack(iViewReference.getView(false));
                try {
                    IViewPart[] iViewPartArray2 = iViewPartArray;
                    int n3 = iViewPartArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IViewPart iViewPart = iViewPartArray2[n4];
                        if (PHPBROWSER_ID.equals(iViewPart.getViewSite().getId())) {
                            Field[] fieldArray;
                            Field[] fieldArray2 = fieldArray = iViewPart.getClass().getDeclaredFields();
                            int n5 = fieldArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                Field field = fieldArray2[n6];
                                if (SWT_BROWSER_CLASS.equals(field.getType().getName())) {
                                    field.setAccessible(true);
                                    Object object = field.get(iViewPart);
                                    Method method = object.getClass().getMethod(SWT_BROWSER_GET_TEXT_METHOD, new Class[0]);
                                    String string = (String)method.invoke(object, new Object[0]);
                                    field.setAccessible(false);
                                    return string;
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return null;
    }

    abstract String getTargetViewId();
}

