/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and Others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Kentarou FUKUDA - initial API and implementation
 *******************************************************************************/

package org.eclipse.actf.visualization.eval;

import java.io.InputStream;
import java.util.ResourceBundle;

/**
 * Interface to provide additional guideline/evaluation item information
 * implemented in the checkers extension
 */
public interface ICheckerInfoProvider {

	/**
	 * @return array of {@link InputStream} for guideline.xml
	 */
	InputStream[] getGuidelineInputStreams();

	/**
	 * @return array of {@link InputStream} for checkitem.xml
	 */
	InputStream[] getCheckItemInputStreams();

	/**
	 * @return a {@link ResourceBundle} to obtain messages for each evaluation
	 *         item
	 */
	ResourceBundle getDescriptionRB();
}
