/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ooo;

import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.lang.IndexOutOfBoundsException;
import org.eclipse.actf.model.dom.odf.ODFConstants;
import org.eclipse.actf.model.dom.odf.util.ODFFileUtils;
import org.eclipse.actf.model.internal.ui.editors.ooo.OOoWindowComposite;
import org.eclipse.actf.model.internal.ui.editors.ooo.util.ODFException;
import org.eclipse.actf.model.ui.IModelServiceScrollManager;
import org.eclipse.actf.model.ui.ModelServiceSizeInfo;
import org.eclipse.actf.model.ui.util.ScrollBarSizeUtil;

public class OOoEditorScrollManager
implements IModelServiceScrollManager {
    OOoWindowComposite _oOoWindowComposite;

    public OOoEditorScrollManager(OOoWindowComposite oOoWindowComposite) {
        this._oOoWindowComposite = oOoWindowComposite;
    }

    public void absoluteCoordinateScroll(int n, boolean bl) {
    }

    public void absoluteCoordinateScroll(int n, int n2, boolean bl) {
    }

    public int incrementScrollX(boolean bl) {
        String string = this._oOoWindowComposite.getUrl();
        if (ODFConstants.ContentType.SPREADSHEET.equals((Object)ODFFileUtils.getODFFileType((String)string))) {
            return -1;
        }
        return this.doScrollAction(0, 1);
    }

    public int decrementScrollX(boolean bl) {
        String string = this._oOoWindowComposite.getUrl();
        if (ODFConstants.ContentType.SPREADSHEET.equals((Object)ODFFileUtils.getODFFileType((String)string))) {
            return -1;
        }
        return this.doScrollAction(0, 0);
    }

    public int incrementScrollY(boolean bl) {
        String string = this._oOoWindowComposite.getUrl();
        if (ODFConstants.ContentType.SPREADSHEET.equals((Object)ODFFileUtils.getODFFileType((String)string))) {
            return -1;
        }
        return this.doScrollAction(1, 1);
    }

    public int decrementScrollY(boolean bl) {
        String string = this._oOoWindowComposite.getUrl();
        if (ODFConstants.ContentType.SPREADSHEET.equals((Object)ODFFileUtils.getODFFileType((String)string))) {
            return -1;
        }
        return this.doScrollAction(1, 0);
    }

    public int incrementLargeScrollX(boolean bl) {
        String string = this._oOoWindowComposite.getUrl();
        ODFConstants.ContentType contentType = ODFFileUtils.getODFFileType((String)string);
        if (ODFConstants.ContentType.SPREADSHEET.equals((Object)contentType) || ODFConstants.ContentType.PRESENTATION.equals((Object)contentType)) {
            return -1;
        }
        return this.doScrollAction(0, 3);
    }

    public int decrementLargeScrollX(boolean bl) {
        String string = this._oOoWindowComposite.getUrl();
        ODFConstants.ContentType contentType = ODFFileUtils.getODFFileType((String)string);
        if (ODFConstants.ContentType.SPREADSHEET.equals((Object)contentType) || ODFConstants.ContentType.PRESENTATION.equals((Object)contentType)) {
            return -1;
        }
        return this.doScrollAction(0, 2);
    }

    public int incrementLargeScrollY(boolean bl) {
        String string = this._oOoWindowComposite.getUrl();
        ODFConstants.ContentType contentType = ODFFileUtils.getODFFileType((String)string);
        if (ODFConstants.ContentType.PRESENTATION.equals((Object)contentType)) {
            this._oOoWindowComposite.setDrawingMode();
            return this._oOoWindowComposite.movePresentationPage(true);
        }
        if (ODFConstants.ContentType.SPREADSHEET.equals((Object)contentType)) {
            return -1;
        }
        return this.doScrollAction(1, 3);
    }

    public int decrementLargeScrollY(boolean bl) {
        String string = this._oOoWindowComposite.getUrl();
        ODFConstants.ContentType contentType = ODFFileUtils.getODFFileType((String)string);
        if (ODFConstants.ContentType.PRESENTATION.equals((Object)contentType)) {
            this._oOoWindowComposite.setDrawingMode();
            return this._oOoWindowComposite.movePresentationPage(false);
        }
        if (ODFConstants.ContentType.SPREADSHEET.equals((Object)contentType)) {
            return -1;
        }
        return this.doScrollAction(1, 2);
    }

    public int decrementPageScroll(boolean bl) {
        String string = this._oOoWindowComposite.getUrl();
        ODFConstants.ContentType contentType = ODFFileUtils.getODFFileType((String)string);
        if (ODFConstants.ContentType.PRESENTATION.equals((Object)contentType)) {
            this._oOoWindowComposite.setDrawingMode();
            int n = this._oOoWindowComposite.movePresentationPage(false);
            if (bl) {
                this.waitRendering();
            }
            return n;
        }
        return -1;
    }

    public int incrementPageScroll(boolean bl) {
        String string = this._oOoWindowComposite.getUrl();
        ODFConstants.ContentType contentType = ODFFileUtils.getODFFileType((String)string);
        if (ODFConstants.ContentType.PRESENTATION.equals((Object)contentType)) {
            this._oOoWindowComposite.setDrawingMode();
            int n = this._oOoWindowComposite.movePresentationPage(true);
            if (bl) {
                this.waitRendering();
            }
            return n;
        }
        return -1;
    }

    public int jumpToPage(int n, boolean bl) {
        if (ODFConstants.ContentType.PRESENTATION.equals((Object)ODFFileUtils.getODFFileType((String)this._oOoWindowComposite.getUrl()))) {
            this._oOoWindowComposite.setDrawingMode();
            int n2 = this._oOoWindowComposite.jumpToPresentationPage(n);
            if (bl) {
                this.waitRendering();
            }
            return n2;
        }
        return -1;
    }

    public int getCurrentPageNumber() {
        if (ODFConstants.ContentType.PRESENTATION.equals((Object)ODFFileUtils.getODFFileType((String)this._oOoWindowComposite.getUrl()))) {
            return this._oOoWindowComposite.getCurrentPageNumber();
        }
        return -1;
    }

    public int getLastPageNumber() {
        if (ODFConstants.ContentType.PRESENTATION.equals((Object)ODFFileUtils.getODFFileType((String)this._oOoWindowComposite.getUrl()))) {
            return this._oOoWindowComposite.getPresentationPageCount();
        }
        return -1;
    }

    public int getScrollType() {
        String string = this._oOoWindowComposite.getUrl();
        if (string == null) {
            return -1;
        }
        if (ODFConstants.ContentType.PRESENTATION.equals((Object)ODFFileUtils.getODFFileType((String)string))) {
            return 2;
        }
        return -1;
    }

    private int doScrollAction(int n, int n2) {
        int[] nArray = this._oOoWindowComposite.getViewData();
        if (nArray == null) {
            return -1;
        }
        XAccessibleAction[] xAccessibleActionArray = this._oOoWindowComposite.getScrollAction();
        if (xAccessibleActionArray == null || xAccessibleActionArray.length <= n || xAccessibleActionArray[n] == null) {
            return -1;
        }
        try {
            xAccessibleActionArray[n].doAccessibleAction(n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
        }
        int[] nArray2 = this._oOoWindowComposite.getViewData();
        return Math.abs(nArray2[n] - nArray[n]);
    }

    public ModelServiceSizeInfo getSize(boolean bl) {
        int[] nArray;
        if (ODFConstants.ContentType.PRESENTATION.equals((Object)ODFFileUtils.getODFFileType((String)this._oOoWindowComposite.getUrl()))) {
            this._oOoWindowComposite.setDrawingMode();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        try {
            nArray = this._oOoWindowComposite.getOOoWinSize();
        }
        catch (ODFException oDFException) {
            return new ModelServiceSizeInfo(0, 0, 0, 0);
        }
        int n = ScrollBarSizeUtil.getVerticalBarWidth();
        int n2 = ScrollBarSizeUtil.getHorizontalBarHeight();
        ModelServiceSizeInfo modelServiceSizeInfo = new ModelServiceSizeInfo(nArray[0] - n, nArray[1] - n2, nArray[0] - n, nArray[1] - n2);
        if (bl) {
            int n3;
            int n4;
            if (ODFConstants.ContentType.PRESENTATION.equals((Object)ODFFileUtils.getODFFileType((String)this._oOoWindowComposite.getUrl()))) {
                int n5 = this._oOoWindowComposite.getPresentationPageCount();
                ModelServiceSizeInfo modelServiceSizeInfo2 = new ModelServiceSizeInfo(nArray[0] - n, nArray[1] - n2, nArray[0] - n, nArray[1] * n5 - n2);
                return modelServiceSizeInfo2;
            }
            this._oOoWindowComposite.setVisible(false);
            while ((n4 = this.incrementLargeScrollX(false)) != 0 && n4 != -1) {
            }
            while ((n4 = this.incrementLargeScrollY(false)) != 0 && n4 != -1) {
            }
            int[] nArray2 = this._oOoWindowComposite.getViewData();
            if (nArray2 == null) {
                this._oOoWindowComposite.setVisible(true);
                return modelServiceSizeInfo;
            }
            ModelServiceSizeInfo modelServiceSizeInfo3 = new ModelServiceSizeInfo(nArray[0] - n, nArray[1] - n, nArray2[2] - n, nArray2[3] - n);
            while ((n3 = this.decrementLargeScrollX(false)) != 0 && n3 != -1) {
            }
            while ((n3 = this.decrementLargeScrollY(false)) != 0 && n3 != -1) {
            }
            this._oOoWindowComposite.setVisible(true);
            this._oOoWindowComposite.redraw();
            return modelServiceSizeInfo3;
        }
        return modelServiceSizeInfo;
    }

    private void waitRendering() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    Thread.sleep(750L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        };
        thread.run();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

