/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.eval.html;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.eclipse.actf.visualization.eval.html.HtmlTagUtil;
import org.eclipse.actf.visualization.eval.html.statistics.FlashData;
import org.eclipse.actf.visualization.eval.html.statistics.HeadingsData;
import org.eclipse.actf.visualization.eval.html.statistics.ImageStatData;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLImageElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlEvalUtil
extends HtmlTagUtil {
    private static final boolean PERFORMANCE_DEBUG = false;
    private static final int LONG_TEXT_NUM = 200;
    private static final String[] HEADING_LEVEL = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
    public static final String[] EVENT_MOUSE_BUTTON = new String[]{"onclick", "ondblclick", "onmouseup", "onmousedown"};
    public static final String[] EVENT_MOUSE_FOCUS = new String[]{"onmouseover", "onmouseout", "onmousemove"};
    public static final String[] EVENT_ON_KEY = new String[]{"onkeydown", "onkeypress", "onkeyup"};
    public static final String[] EVENT_LOAD = new String[]{"onload", "onunload", "onabort", "onerror"};
    public static final String[] EVENT_WINDOW = new String[]{"onresize", "onmove", "ondragdrop"};
    public static final String[] EVENT_FOCUS = new String[]{"onfocus", "onblur", "onselect"};
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private static final Object EXP1 = xpathService.compile(".//a[@href]");
    private static final Object EXP2 = xpathService.compile("//h1|//h2|//h3|//h4|//h5|//h6");
    private Document target;
    private Document resultDoc;
    private Document srcDom;
    private Document liveDom;
    private File targetFile;
    private File srcFile;
    private File liveFile;
    private URL baseUrl;
    private Map<Node, Integer> document2IdMap;
    private boolean isDBCS;
    private boolean isLiveDom;
    private boolean hasAwithHref = false;
    private boolean hasJavascript = false;
    private Element[] aWithHref_elements;
    private String[] aWithHref_hrefs;
    private String[] aWithHref_strings;
    private HTMLImageElement[] img_elements;
    private Element[] table_elements;
    private Element[] body_elements;
    private Element[] frame_elements;
    private Element[] iframe_elements;
    private Element[] object_elements;
    private Element[] parent_table_elements;
    private Element[] bottom_data_tables;
    private Element[] bottom_1row1col_tables;
    private Element[] bottom_notdata_tables;
    private Element[] headings;
    private Element[] embed_elements;
    private Element[] script_elements;
    private Element[] javascript_elements;
    private Element[] eventMouseButtonElements;
    private Element[] eventMouseFocusElements;
    private Element[] eventOnKeyElements;
    private Element[] eventLoadElements;
    private Element[] eventWindowElements;
    private Element[] eventFocusElements;
    private Element[] javascriptHref_elements;
    private String[] javascriptHref_hrefs;
    private String[] javascriptHref_strings;
    private String curUrl;
    private double invalidLinkRatio;
    private PageData pageData;
    private List<Element> imageButtonList;
    private List<Element> textButtonList;
    private List<Element> areaList;
    private List<Element> appletList;
    private List<Element> accessKeyList;
    private List<Element> styleList;
    private List<Element> styleElementList;
    private List<Element> idElementList;

    public HtmlEvalUtil(Document document, Document document2, String string, Map<Node, Integer> map, Document document3, Document document4, PageData pageData, boolean bl, boolean bl2) {
        this(document, document2, string, map, document3, document4, pageData, 0, null, bl, bl2);
    }

    private HtmlEvalUtil(Document document, Document document2, String string, Map<Node, Integer> map, Document document3, Document document4, PageData pageData, int n, String[] stringArray, boolean bl, boolean bl2) {
        String string2;
        Object object;
        Object object2;
        Object object3;
        this.target = document;
        this.resultDoc = document2;
        this.srcDom = document3;
        this.liveDom = document4;
        this.isLiveDom = bl2;
        this.pageData = pageData;
        this.curUrl = string;
        this.baseUrl = null;
        try {
            this.baseUrl = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {}
        this.invalidLinkRatio = 0.0;
        this.document2IdMap = map;
        this.isDBCS = bl;
        NodeList nodeList = xpathService.evalForNodeList(EXP1, (Node)document);
        int n2 = nodeList.getLength();
        if (n2 > 0) {
            this.hasAwithHref = true;
        }
        this.aWithHref_elements = new Element[n2];
        this.aWithHref_hrefs = new String[n2];
        this.aWithHref_strings = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            object3 = (Element)nodeList.item(n3);
            this.aWithHref_elements[n3] = object3;
            this.aWithHref_hrefs[n3] = object3.getAttribute("href");
            this.aWithHref_strings[n3] = HtmlEvalUtil.getTextAltDescendant((Node)object3);
            ++n3;
        }
        nodeList = document.getElementsByTagName("img");
        n2 = nodeList.getLength();
        this.img_elements = new HTMLImageElement[n2];
        Vector<ImageStatData> vector = new Vector<ImageStatData>();
        object3 = new HashMap();
        HashMap<Element, ImageStatData> hashMap = new HashMap<Element, ImageStatData>();
        int n4 = 0;
        while (n4 < n2) {
            this.img_elements[n4] = (HTMLImageElement)nodeList.item(n4);
            object2 = new ImageStatData(this.img_elements[n4], this.baseUrl);
            vector.add((ImageStatData)object2);
            ((HashMap)object3).put(this.img_elements[n4], object2);
            if (((ImageStatData)object2).getAncestorLink() != null) {
                hashMap.put(((ImageStatData)object2).getAncestorLink(), (ImageStatData)object2);
            }
            ++n4;
        }
        pageData.setImageData(vector);
        pageData.setImageDataMap((Map<HTMLImageElement, ImageStatData>)object3);
        pageData.setLinkImageDataMap(hashMap);
        nodeList = document.getElementsByTagName("table");
        n2 = nodeList.getLength();
        this.table_elements = new Element[n2];
        Vector<Element> vector2 = new Vector<Element>();
        object2 = new Vector();
        Vector<Element> vector3 = new Vector<Element>();
        Vector<Element> vector4 = new Vector<Element>();
        int n5 = 0;
        while (n5 < n2) {
            this.table_elements[n5] = (Element)nodeList.item(n5);
            if (this.table_elements[n5].getElementsByTagName("table").getLength() == 0) {
                if (this.is1Row1ColTable(this.table_elements[n5])) {
                    vector3.add(this.table_elements[n5]);
                } else if (this.isDataTable(this.table_elements[n5])) {
                    vector2.add(this.table_elements[n5]);
                } else {
                    vector4.add(this.table_elements[n5]);
                }
            } else {
                ((Vector)object2).add(this.table_elements[n5]);
            }
            ++n5;
        }
        this.bottom_data_tables = new Element[vector2.size()];
        this.bottom_1row1col_tables = new Element[vector3.size()];
        this.bottom_notdata_tables = new Element[vector4.size()];
        this.parent_table_elements = new Element[((Vector)object2).size()];
        vector2.toArray(this.bottom_data_tables);
        vector3.toArray(this.bottom_1row1col_tables);
        vector4.toArray(this.bottom_notdata_tables);
        ((Vector)object2).toArray(this.parent_table_elements);
        this.body_elements = this.getElementsArray(document, "body");
        this.frame_elements = this.getElementsArray(document, "frame");
        this.iframe_elements = this.getElementsArray(document, "iframe");
        HashSet<Object> hashSet = new HashSet<Object>();
        nodeList = document.getElementsByTagName("object");
        n2 = nodeList.getLength();
        this.object_elements = new Element[n2];
        int n6 = 0;
        while (n6 < n2) {
            this.object_elements[n6] = (Element)nodeList.item(n6);
            if ("clsid:d27cdb6e-ae6d-11cf-96b8-444553540000".equalsIgnoreCase(this.object_elements[n6].getAttribute("classid"))) {
                Object object4;
                Object object5;
                object = this.object_elements[n6].getElementsByTagName("param");
                string2 = "";
                int n7 = 0;
                while (n7 < object.getLength()) {
                    try {
                        object5 = (Element)object.item(n7);
                        String string3 = object5.getAttribute("name");
                        object4 = object5.getAttribute("value");
                        if (string3.equalsIgnoreCase("movie")) {
                            string2 = object4;
                        }
                    }
                    catch (Exception exception) {}
                    ++n7;
                }
                if (string2 != null && string2.length() > 0) {
                    FlashData flashData = new FlashData(this.object_elements[n6], string2, true);
                    pageData.addFlashData(flashData);
                    object5 = this.object_elements[n6].getElementsByTagName("embed");
                    int n8 = 0;
                    while (n8 < object5.getLength()) {
                        String string4;
                        object4 = (Element)object5.item(n8);
                        if ("application/x-shockwave-flash".equalsIgnoreCase(object4.getAttribute("type")) && (string4 = object4.getAttribute("src")) != null && string4.length() > 0) {
                            if (string2.equalsIgnoreCase(string4)) {
                                hashSet.add(object4);
                                flashData.setWithEmbed(true);
                            } else {
                                pageData.addFlashData(new FlashData((Element)object4, string2, false));
                            }
                        }
                        ++n8;
                    }
                }
            }
            ++n6;
        }
        this.embed_elements = this.getElementsArray(document, "embed");
        n6 = 0;
        while (n6 < this.embed_elements.length) {
            object = this.embed_elements[n6];
            if (!hashSet.contains(object) && "application/x-shockwave-flash".equals(object.getAttribute("type")) && (string2 = object.getAttribute("src")) != null && string2.length() > 0) {
                pageData.addFlashData(new FlashData((Element)object, string2, false));
            }
            ++n6;
        }
        NodeList nodeList2 = xpathService.evalForNodeList(EXP2, (Node)document);
        n2 = nodeList2.getLength();
        object = new Vector<HeadingsData>();
        this.headings = new Element[nodeList2.getLength()];
        int n9 = 0;
        while (n9 < n2) {
            Element element;
            this.headings[n9] = element = (Element)nodeList2.item(n9);
            ((Vector)object).add((HeadingsData)new HeadingsData(element, HtmlEvalUtil.getTextAltDescendant(element)));
            ++n9;
        }
        pageData.setHeadingsData((Vector<HeadingsData>)object);
        this.collectScriptElements();
    }

    private Element[] getElementsArray(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        int n = nodeList.getLength();
        Element[] elementArray = new Element[n];
        int n2 = 0;
        while (n2 < n) {
            elementArray[n2] = (Element)nodeList.item(n2);
            ++n2;
        }
        return elementArray;
    }

    public List<Element> getElementsList(Node node, String string, String ... stringArray) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = null;
        if (node instanceof Document) {
            nodeList = ((Document)node).getElementsByTagName(string);
        } else if (node instanceof Element) {
            nodeList = ((Element)node).getElementsByTagName(string);
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            arrayList.add((Element)nodeList.item(n));
            ++n;
        }
        if (stringArray.length > 0) {
            n = 0;
            while (n < stringArray.length) {
                arrayList.addAll(this.getElementsList(node, stringArray[n], new String[0]));
                ++n;
            }
        }
        return arrayList;
    }

    private Element[] getElementsArrayByXPath(Document document, String string) {
        NodeList nodeList = xpathService.evalPathForNodeList(string, (Node)document);
        int n = nodeList.getLength();
        Element[] elementArray = new Element[n];
        int n2 = 0;
        while (n2 < n) {
            Element element;
            elementArray[n2] = element = (Element)nodeList.item(n2);
            ++n2;
        }
        return elementArray;
    }

    private List<Element> getElementsListByXPath(Document document, String string) {
        NodeList nodeList = xpathService.evalPathForNodeList(string, (Node)document);
        int n = nodeList.getLength();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add((Element)nodeList.item(n2));
            ++n2;
        }
        return arrayList;
    }

    private void collectScriptElements() {
        this.script_elements = this.getElementsArray(this.target, "script");
        this.javascript_elements = this.getElementsArrayByXPath(this.target, "//script[@type=\"text/javascript\"]");
        this.eventMouseButtonElements = this.getElementsArrayByXPath(this.target, "//*[@onclick or @ondblclick or @onmouseup or @onmousedown]");
        this.eventMouseFocusElements = this.getElementsArrayByXPath(this.target, "//*[@onmouseover or @onmouseout or @onmousemove]");
        this.eventOnKeyElements = this.getElementsArrayByXPath(this.target, "//*[@onkeydown or @onkeyup or @onkeypress]");
        this.eventLoadElements = this.getElementsArrayByXPath(this.target, "//*[@onload or @onunload or @onabort or @onerror]");
        this.eventWindowElements = this.getElementsArrayByXPath(this.target, "//*[@onresize or @onmove or @ondragdrop]");
        this.eventFocusElements = this.getElementsArrayByXPath(this.target, "//*[@onfocus or @onblur or @onselect]");
        Vector<Element> vector = new Vector<Element>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        int n = 0;
        while (n < this.aWithHref_hrefs.length) {
            if (this.aWithHref_hrefs[n].startsWith("javascript:")) {
                vector.add(this.aWithHref_elements[n]);
                vector2.add(this.aWithHref_hrefs[n]);
                vector3.add(this.aWithHref_strings[n]);
            }
            ++n;
        }
        n = vector.size();
        this.javascriptHref_elements = new Element[n];
        this.javascriptHref_hrefs = new String[n];
        this.javascriptHref_strings = new String[n];
        vector.toArray(this.javascriptHref_elements);
        vector2.toArray(this.javascriptHref_hrefs);
        vector3.toArray(this.javascriptHref_strings);
        int n2 = this.javascript_elements.length + this.eventFocusElements.length + this.eventLoadElements.length + this.eventMouseButtonElements.length + this.eventMouseFocusElements.length + this.eventOnKeyElements.length + this.eventWindowElements.length + this.javascriptHref_hrefs.length;
        this.hasJavascript = n2 > 0;
        this.pageData.setHasJavascript(this.hasJavascript);
    }

    private boolean is1Row1ColTable(Element element) {
        NodeList nodeList = element.getElementsByTagName("tr");
        if (nodeList.getLength() <= 1) {
            return true;
        }
        boolean bl = false;
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            NodeList nodeList2 = ((Element)nodeList.item(n2)).getElementsByTagName("th");
            NodeList nodeList3 = ((Element)nodeList.item(n2)).getElementsByTagName("td");
            if (nodeList2.getLength() + nodeList3.getLength() > 1) {
                bl = true;
                break;
            }
            ++n2;
        }
        return !bl;
    }

    private boolean isDataTable(Element element) {
        if (this.hasFormControl(element)) {
            return false;
        }
        NodeList nodeList = element.getElementsByTagName("td");
        if (nodeList.getLength() == 0) {
            return false;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            if (!this.isDataCell((Element)nodeList.item(n2))) {
                return false;
            }
            ++n2;
        }
        nodeList = element.getElementsByTagName("th");
        n = nodeList.getLength();
        n2 = 0;
        while (n2 < n) {
            if (!this.isDataCell((Element)nodeList.item(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean hasFormControl(Element element) {
        NodeList nodeList = element.getElementsByTagName("form");
        if (nodeList.getLength() > 0) {
            return true;
        }
        nodeList = element.getElementsByTagName("input");
        if (nodeList.getLength() > 0) {
            return true;
        }
        nodeList = element.getElementsByTagName("select");
        if (nodeList.getLength() > 0) {
            return true;
        }
        nodeList = element.getElementsByTagName("textarea");
        if (nodeList.getLength() > 0) {
            return true;
        }
        nodeList = element.getElementsByTagName("html:text");
        if (nodeList.getLength() > 0) {
            return true;
        }
        nodeList = element.getElementsByTagName("html:radio");
        return nodeList.getLength() > 0;
    }

    private boolean isDataCell(Element element) {
        if (HtmlEvalUtil.getTextAltDescendant(element).length() > 200) {
            return false;
        }
        NodeList nodeList = element.getElementsByTagName("a");
        NodeList nodeList2 = element.getElementsByTagName("li");
        NodeList nodeList3 = element.getElementsByTagName("img");
        return nodeList.getLength() + nodeList2.getLength() + nodeList3.getLength() <= 3;
    }

    public int getHeadingLevel(String string) {
        int n = 0;
        while (n < HEADING_LEVEL.length) {
            if (string.equalsIgnoreCase(HEADING_LEVEL[n])) {
                return Integer.valueOf(string.substring(1));
            }
            ++n;
        }
        return 0;
    }

    public List<Element> getAccessKeyElements() {
        if (this.accessKeyList == null) {
            this.accessKeyList = this.getElementsListByXPath(this.target, "//*[@accesskey]");
        }
        return this.accessKeyList;
    }

    public List<Element> getElementsWithStyle() {
        if (this.styleList == null) {
            this.styleList = this.getElementsListByXPath(this.target, "//*[@style]");
        }
        return this.styleList;
    }

    public List<Element> getElementsWithId() {
        if (this.idElementList == null) {
            this.idElementList = this.getElementsListByXPath(this.target, "//*[@id]");
        }
        return this.idElementList;
    }

    public List<Element> getStyleElements() {
        if (this.styleElementList == null) {
            this.styleElementList = new ArrayList<Element>();
            for (Element element : this.getElementsList(this.target, "style", new String[0])) {
                this.styleElementList.add(element);
            }
        }
        return this.styleElementList;
    }

    public List<Element> getAppletElements() {
        if (this.appletList == null) {
            this.appletList = this.getElementsList(this.target, "applet", new String[0]);
        }
        return this.appletList;
    }

    public List<Element> getAreaElements() {
        if (this.areaList == null) {
            this.areaList = new ArrayList<Element>();
            for (Element element : this.getElementsList(this.target, "area", new String[0])) {
                this.areaList.add(element);
            }
        }
        return this.areaList;
    }

    public Element[] getAWithHref_elements() {
        return this.aWithHref_elements;
    }

    public String[] getAWithHref_hrefs() {
        return this.aWithHref_hrefs;
    }

    public String[] getAWithHref_strings() {
        return this.aWithHref_strings;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public Element[] getBody_elements() {
        return this.body_elements;
    }

    public Element[] getBottom_1row1col_tables() {
        return this.bottom_1row1col_tables;
    }

    public Element[] getBottom_data_tables() {
        return this.bottom_data_tables;
    }

    public Element[] getBottom_notdata_tables() {
        return this.bottom_notdata_tables;
    }

    public String getUrl() {
        return this.curUrl;
    }

    public Map<Node, Integer> getDocument2IdMap() {
        return this.document2IdMap;
    }

    public Element[] getFrame_elements() {
        return this.frame_elements;
    }

    public boolean isHasAwithHref() {
        return this.hasAwithHref;
    }

    public boolean isHasJavascript() {
        return this.hasJavascript;
    }

    public Element[] getHeadings() {
        return this.headings;
    }

    public Document getLiveDom() {
        return this.liveDom;
    }

    public Element[] getIframe_elements() {
        return this.iframe_elements;
    }

    public HTMLImageElement[] getImg_elements() {
        return this.img_elements;
    }

    public List<Element> getImageButtons() {
        if (this.imageButtonList != null) {
            return this.imageButtonList;
        }
        this.imageButtonList = new ArrayList<Element>();
        for (Element element : this.getElementsList(this.target, "input", new String[0])) {
            if (!element.getAttribute("type").equals("image")) continue;
            this.imageButtonList.add(element);
        }
        return this.imageButtonList;
    }

    public List<Element> getTextButtons() {
        if (this.textButtonList == null) {
            this.textButtonList = new ArrayList<Element>();
            for (Element element : this.getElementsList(this.target, "input", new String[0])) {
                if (!element.getAttribute("type").matches("button|submit|reset")) continue;
                this.textButtonList.add(element);
            }
        }
        return this.textButtonList;
    }

    public double getInvalidLinkRatio() {
        return this.invalidLinkRatio;
    }

    public int getInvisibleElementCount() {
        return 0;
    }

    public String[] getInvisibleLinkStrings() {
        return new String[0];
    }

    public boolean isDBCS() {
        return this.isDBCS;
    }

    public boolean isLiveDom() {
        return this.isLiveDom;
    }

    public HashSet<String> getNotExistHrefSet() {
        return new HashSet<String>();
    }

    public Element[] getObject_elements() {
        return this.object_elements;
    }

    public Document getSrcDom() {
        return this.srcDom;
    }

    public PageData getPageData() {
        return this.pageData;
    }

    public Element[] getParent_table_elements() {
        return this.parent_table_elements;
    }

    public Document getResult() {
        return this.resultDoc;
    }

    public Element[] getTable_elements() {
        return this.table_elements;
    }

    public Document getTarget() {
        return this.target;
    }

    public Element[] getEmbed_elements() {
        return this.embed_elements;
    }

    public Element[] getJavascriptHref_elements() {
        return this.javascriptHref_elements;
    }

    public String[] getJavascriptHref_hrefs() {
        return this.javascriptHref_hrefs;
    }

    public String[] getJavascriptHref_strings() {
        return this.javascriptHref_strings;
    }

    public Element[] getEventLoadElements() {
        return this.eventLoadElements;
    }

    public Element[] getEventMouseButtonElements() {
        return this.eventMouseButtonElements;
    }

    public Element[] getEventOnMouseElements() {
        return this.eventMouseFocusElements;
    }

    public Element[] getEventOnKeyElements() {
        return this.eventOnKeyElements;
    }

    public Element[] getScript_elements() {
        return this.script_elements;
    }

    public Element[] getEventWindowElements() {
        return this.eventWindowElements;
    }

    public Element[] getEventFocusElements() {
        return this.eventFocusElements;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(File file) {
        this.targetFile = file;
    }

    public File getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(File file) {
        this.srcFile = file;
    }

    public File getLiveFile() {
        return this.liveFile;
    }

    public void setLiveFile(File file) {
        this.liveFile = file;
    }

    public boolean appendErrorIcon(IProblemItem iProblemItem, Element element) {
        try {
            String string = this.document2IdMap.get(element).toString();
            Element element2 = this.resultDoc.getElementById("id" + string);
            if (element2 != null && "area".equalsIgnoreCase(element2.getTagName())) {
                element2 = this.resultDoc.getElementById("id" + string + "-span");
            }
            if (element2 != null && element2.getElementsByTagName("img").getLength() == 0) {
                Element element3 = this.resultDoc.createElement("img");
                element3.setAttribute("alt", "error icon");
                element3.setAttribute("src", "img/exclawhite21.gif");
                element3.setAttribute("title", iProblemItem.getDescription());
                String string2 = iProblemItem.getDescription();
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < string2.length()) {
                    if (string2.charAt(n) == '\"') {
                        stringBuffer.append("\\");
                    }
                    if (string2.charAt(n) == '\'') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(string2.charAt(n));
                    ++n;
                }
                String string3 = stringBuffer.toString().replaceAll("\n", "").replaceAll("\r", "");
                element3.setAttribute("onmouseover", "updateBaloon2(\"id" + string + "\",\"" + string3 + "\");");
                element2.appendChild(element3);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

