/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.TaskingEngine;
import org.eclipse.tea.core.TaskingInjectionHelper;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.core.ui.annotations.TaskChainUiInit;
import org.eclipse.ui.PlatformUI;

public final class TaskingEngineJob
extends Job {
    private final TaskingEngine engine;
    private final Object chain;
    private IStatus actualResult;

    public TaskingEngineJob(TaskingEngine engine, Object chain) {
        super("Tasking");
        this.chain = chain;
        this.engine = engine;
        Assert.isLegal((Display.getCurrent() != null ? 1 : 0) != 0, (String)"Cannot instantiate TaskingEngine Job from non-UI thread");
        if (!TaskingInjectionHelper.isHeadless((IEclipseContext)engine.getContext())) {
            engine.getContext().set(Shell.class, (Object)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            try {
                ContextInjectionFactory.invoke((Object)chain, TaskChainUiInit.class, (IEclipseContext)engine.getContext(), null);
            }
            catch (InjectionException e) {
                if (e.getCause() instanceof OperationCanceledException) {
                    this.actualResult = Status.CANCEL_STATUS;
                }
                throw e;
            }
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        TaskExecutionContext context;
        if (this.actualResult != null) {
            return this.actualResult;
        }
        if (this.chain instanceof TaskChain) {
            context = TaskingInjectionHelper.createNewChainContext((TaskingEngine)this.engine, (TaskChain)((TaskChain)this.chain), (IProgressMonitor)monitor);
        } else if (this.chain instanceof String) {
            context = TaskingInjectionHelper.createNewChainContext((TaskingEngine)this.engine, (String)((String)this.chain), (IProgressMonitor)monitor);
        } else {
            return new Status(4, "org.eclipse.tea.core.ui", "Given object is not a TaskChain or String: " + this.chain);
        }
        this.setName(TaskingModel.getTaskChainName((TaskChain)context.getUnderlyingChain()));
        this.actualResult = this.engine.runTaskChain(context);
        return Status.OK_STATUS;
    }

    public IStatus getActualResult() {
        return this.actualResult;
    }

    public boolean belongsTo(Object family) {
        return family == TaskChain.class;
    }
}

