/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractTypeReferenceTraverser;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeReferencePairWalker
extends AbstractTypeReferenceTraverser<JvmTypeReference> {
    private final CommonTypeComputationServices services;
    private final ParameterizedTypeReferenceTraverser parameterizedTypeReferenceTraverser;
    private final WildcardTypeReferenceTraverser wildcardTypeReferenceTraverser;
    private final ArrayTypeReferenceTraverser arrayTypeReferenceTraverser;
    private VarianceInfo expectedVariance;
    private VarianceInfo actualVariance;
    private Object origin;

    protected AbstractTypeReferencePairWalker(CommonTypeComputationServices services) {
        this.services = services;
        this.parameterizedTypeReferenceTraverser = this.createParameterizedTypeReferenceTraverser();
        this.wildcardTypeReferenceTraverser = this.createWildcardTypeReferenceTraverser();
        this.arrayTypeReferenceTraverser = this.createArrayTypeReferenceTraverser();
    }

    protected void processTypeParameter(JvmTypeParameter typeParameter, JvmTypeReference reference) {
    }

    protected boolean shouldProcess(JvmTypeParameter type) {
        return true;
    }

    protected ArrayTypeReferenceTraverser createArrayTypeReferenceTraverser() {
        return new ArrayTypeReferenceTraverser();
    }

    protected WildcardTypeReferenceTraverser createWildcardTypeReferenceTraverser() {
        return new WildcardTypeReferenceTraverser();
    }

    protected ParameterizedTypeReferenceTraverser createParameterizedTypeReferenceTraverser() {
        return new ParameterizedTypeReferenceTraverser();
    }

    public Void doVisitParameterizedTypeReference(JvmParameterizedTypeReference declaredReference, JvmTypeReference param) {
        return (Void)this.parameterizedTypeReferenceTraverser.visit(param, declaredReference);
    }

    public Void doVisitWildcardTypeReference(JvmWildcardTypeReference declaredReference, JvmTypeReference param) {
        return (Void)this.wildcardTypeReferenceTraverser.visit(param, declaredReference);
    }

    public Void doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference declaredReference, JvmTypeReference param) {
        return (Void)this.arrayTypeReferenceTraverser.visit(param, declaredReference);
    }

    protected Void outerVisit(JvmTypeReference reference, JvmTypeReference parameter, Object origin, VarianceInfo expectedVariance, VarianceInfo actualVariance) {
        VarianceInfo oldExpectedVariance = this.expectedVariance;
        VarianceInfo oldActualVariance = this.actualVariance;
        Object oldOrigin = this.origin;
        try {
            this.expectedVariance = expectedVariance;
            this.actualVariance = actualVariance;
            this.origin = origin;
            Void void_ = this.outerVisit(reference, parameter);
            return void_;
        }
        finally {
            this.expectedVariance = oldExpectedVariance;
            this.actualVariance = oldActualVariance;
            this.origin = oldOrigin;
        }
    }

    protected Void outerVisit(JvmTypeReference reference, JvmTypeReference parameter) {
        return (Void)this.visit(reference, parameter);
    }

    public void processPairedReferences(JvmTypeReference declaredType, JvmTypeReference actualType) {
        this.outerVisit(declaredType, actualType, declaredType, VarianceInfo.OUT, VarianceInfo.OUT);
    }

    protected CommonTypeComputationServices getServices() {
        return this.services;
    }

    protected VarianceInfo getActualVariance() {
        return this.actualVariance;
    }

    protected VarianceInfo getExpectedVariance() {
        return this.expectedVariance;
    }

    protected Object getOrigin() {
        return this.origin;
    }

    protected TypeParameterSubstitutor createTypeParameterSubstitutor(Map<JvmTypeParameter, JvmTypeReference> mapping) {
        return new TypeParameterSubstitutor(mapping, this.services);
    }

    protected JvmTypeParameter findMappedParameter(JvmTypeParameter parameter, Map<JvmTypeParameter, JvmTypeReference> mapping, Collection<JvmTypeParameter> visited) {
        for (Map.Entry<JvmTypeParameter, JvmTypeReference> entry : mapping.entrySet()) {
            JvmTypeReference reference = entry.getValue();
            JvmType type = reference.getType();
            if (parameter != type) continue;
            if (visited.add(entry.getKey())) {
                return entry.getKey();
            }
            return null;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ArrayTypeReferenceTraverser
    extends AbstractTypeReferenceTraverser<JvmGenericArrayTypeReference> {
        protected ArrayTypeReferenceTraverser() {
        }

        public Void doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference, JvmGenericArrayTypeReference declaration) {
            return AbstractTypeReferencePairWalker.this.outerVisit(declaration.getComponentType(), reference.getComponentType());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ParameterizedTypeReferenceTraverser
    extends AbstractTypeReferenceTraverser<JvmParameterizedTypeReference> {
        protected ParameterizedTypeReferenceTraverser() {
        }

        public Void doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference, JvmParameterizedTypeReference declaration) {
            JvmType type = declaration.getType();
            if (type instanceof JvmTypeParameter) {
                if (type != reference.getType() && AbstractTypeReferencePairWalker.this.shouldProcess((JvmTypeParameter)type)) {
                    JvmTypeParameter typeParameter = (JvmTypeParameter)type;
                    AbstractTypeReferencePairWalker.this.processTypeParameter(typeParameter, (JvmTypeReference)reference);
                }
            } else if (type instanceof JvmTypeParameterDeclarator && !((JvmTypeParameterDeclarator)type).getTypeParameters().isEmpty()) {
                this.doVisitSuperTypesWithMatchingParams(reference, declaration);
            }
            return null;
        }

        protected void doVisitSuperTypesWithMatchingParams(JvmParameterizedTypeReference reference, JvmParameterizedTypeReference declaration) {
            Map<JvmTypeParameter, JvmTypeReference> actualMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping((JvmTypeReference)reference);
            TypeParameterSubstitutor actualSubstitutor = AbstractTypeReferencePairWalker.this.createTypeParameterSubstitutor(actualMapping);
            Map<JvmTypeParameter, JvmTypeReference> declaredMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping((JvmTypeReference)declaration);
            TypeParameterSubstitutor declaredSubstitutor = AbstractTypeReferencePairWalker.this.createTypeParameterSubstitutor(declaredMapping);
            Set<JvmTypeParameter> actualBoundParameters = actualMapping.keySet();
            HashSet visited = Sets.newHashSet();
            for (JvmTypeParameter actualBoundParameter : actualBoundParameters) {
                if (!visited.add(actualBoundParameter)) continue;
                JvmTypeReference declared = declaredMapping.get(actualBoundParameter);
                while (declared == null && actualBoundParameter != null) {
                    actualBoundParameter = AbstractTypeReferencePairWalker.this.findMappedParameter(actualBoundParameter, actualMapping, visited);
                    declared = declaredMapping.get(actualBoundParameter);
                }
                if (declared == null) continue;
                if (declared.getType() instanceof JvmTypeParameter) {
                    JvmTypeParameter declaredType = (JvmTypeParameter)declared.getType();
                    if (!AbstractTypeReferencePairWalker.this.shouldProcess(declaredType)) {
                        if (actualBoundParameters.contains(declaredType) && !visited.add(declaredType)) continue;
                        declared = declaredSubstitutor.substitute(declared);
                    } else if (!this.allowToVisitTwice() && !visited.add(declaredType)) continue;
                }
                JvmTypeReference actual = actualSubstitutor.substitute(actualMapping.get(actualBoundParameter));
                AbstractTypeReferencePairWalker.this.outerVisit(declared, actual, declaration, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
            }
        }

        protected boolean allowToVisitTwice() {
            return true;
        }

        public Void doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference, JvmParameterizedTypeReference declaration) {
            JvmType type = declaration.getType();
            if (type instanceof JvmTypeParameter && AbstractTypeReferencePairWalker.this.shouldProcess((JvmTypeParameter)type)) {
                JvmTypeParameter typeParameter = (JvmTypeParameter)type;
                AbstractTypeReferencePairWalker.this.processTypeParameter(typeParameter, (JvmTypeReference)reference);
            }
            return null;
        }

        public Void doVisitWildcardTypeReference(JvmWildcardTypeReference reference, JvmParameterizedTypeReference declaration) {
            boolean lowerBoundFound = false;
            for (JvmTypeConstraint actualConstraint : reference.getConstraints()) {
                if (!(actualConstraint instanceof JvmLowerBound)) continue;
                lowerBoundFound = true;
                AbstractTypeReferencePairWalker.this.outerVisit((JvmTypeReference)declaration, actualConstraint.getTypeReference(), declaration, AbstractTypeReferencePairWalker.this.expectedVariance, VarianceInfo.IN);
            }
            if (!lowerBoundFound) {
                for (JvmTypeConstraint actualConstraint : reference.getConstraints()) {
                    AbstractTypeReferencePairWalker.this.outerVisit((JvmTypeReference)declaration, actualConstraint.getTypeReference(), declaration, AbstractTypeReferencePairWalker.this.expectedVariance, VarianceInfo.OUT);
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WildcardTypeReferenceTraverser
    extends AbstractTypeReferenceTraverser<JvmWildcardTypeReference> {
        protected WildcardTypeReferenceTraverser() {
        }

        public Void doVisitWildcardTypeReference(JvmWildcardTypeReference reference, JvmWildcardTypeReference declaration) {
            boolean lowerBoundFound = false;
            for (JvmTypeConstraint declaredConstraint : declaration.getConstraints()) {
                if (!(declaredConstraint instanceof JvmLowerBound)) continue;
                lowerBoundFound = true;
                boolean actualHasLowerBound = false;
                for (JvmTypeConstraint actualConstraint : reference.getConstraints()) {
                    if (!(actualConstraint instanceof JvmLowerBound)) continue;
                    actualHasLowerBound = true;
                    AbstractTypeReferencePairWalker.this.outerVisit(declaredConstraint.getTypeReference(), actualConstraint.getTypeReference(), declaration, VarianceInfo.IN, VarianceInfo.IN);
                }
                if (actualHasLowerBound) continue;
                for (JvmTypeConstraint actualConstraint : reference.getConstraints()) {
                    AbstractTypeReferencePairWalker.this.outerVisit(declaredConstraint.getTypeReference(), actualConstraint.getTypeReference(), declaration, VarianceInfo.IN, VarianceInfo.OUT);
                }
            }
            if (!lowerBoundFound) {
                for (JvmTypeConstraint declaredConstraint : declaration.getConstraints()) {
                    for (JvmTypeConstraint actualConstraint : reference.getConstraints()) {
                        AbstractTypeReferencePairWalker.this.outerVisit(declaredConstraint.getTypeReference(), actualConstraint.getTypeReference(), declaration, VarianceInfo.OUT, actualConstraint instanceof JvmUpperBound ? VarianceInfo.OUT : VarianceInfo.IN);
                    }
                }
            }
            return null;
        }

        @Override
        public Void doVisitTypeReference(JvmTypeReference reference, JvmWildcardTypeReference declaration) {
            boolean lowerBoundFound = false;
            for (JvmTypeConstraint declaredConstraint : declaration.getConstraints()) {
                if (!(declaredConstraint instanceof JvmLowerBound)) continue;
                lowerBoundFound = true;
                AbstractTypeReferencePairWalker.this.outerVisit(declaredConstraint.getTypeReference(), reference, declaration, VarianceInfo.IN, VarianceInfo.INVARIANT);
            }
            if (!lowerBoundFound) {
                for (JvmTypeConstraint declaredConstraint : declaration.getConstraints()) {
                    if (!(declaredConstraint instanceof JvmUpperBound)) continue;
                    AbstractTypeReferencePairWalker.this.outerVisit(declaredConstraint.getTypeReference(), reference, declaration, VarianceInfo.OUT, VarianceInfo.INVARIANT);
                }
            }
            return null;
        }
    }
}

