/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.beans.Introspector;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.scoping.featurecalls.DefaultJvmFeatureDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IFeaturesForTypeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XFeatureCallSugarDescriptionProvider
extends DefaultJvmFeatureDescriptionProvider {
    @Inject
    private OperatorMapping operatorMapping;

    public void setOperatorMapping(OperatorMapping operatorMapping) {
        this.operatorMapping = operatorMapping;
    }

    @Override
    protected void doCollectDescriptions(final String name, IFeaturesForTypeProvider featureProvider, JvmTypeReference typeReference, ITypeArgumentContext context, Iterable<JvmTypeReference> hierarchy, final IAcceptor<JvmFeatureDescription> acceptor) {
        IAcceptor<JvmFeatureDescription> myAcceptor = new IAcceptor<JvmFeatureDescription>(){

            public void accept(JvmFeatureDescription t) {
                if (name.equals(t.getName().toString())) {
                    acceptor.accept((Object)t);
                }
            }
        };
        super.doCollectDescriptions(name, featureProvider, typeReference, context, hierarchy, myAcceptor);
        QualifiedName methodName = this.operatorMapping.getMethodName(QualifiedName.create((String)name));
        if (methodName != null) {
            super.doCollectDescriptions(methodName.toString(), featureProvider, typeReference, context, hierarchy, myAcceptor);
        } else {
            String getterAlias = "get" + Strings.toFirstUpper((String)name);
            super.doCollectDescriptions(getterAlias, featureProvider, typeReference, context, hierarchy, myAcceptor);
            String isAlias = "is" + Strings.toFirstUpper((String)name);
            super.doCollectDescriptions(isAlias, featureProvider, typeReference, context, hierarchy, myAcceptor);
        }
    }

    @Override
    public void addFeatureDescriptions(JvmFeature feature, ITypeArgumentContext context, IAcceptor<JvmFeatureDescription> acceptor) {
        if (feature instanceof JvmOperation) {
            QualifiedName operator;
            final JvmOperation op = (JvmOperation)feature;
            int syntacticalNumberOfArguments = this.getSyntacticalNumberOfArguments(op);
            if (syntacticalNumberOfArguments <= 1 && (operator = this.operatorMapping.getOperator(QualifiedName.create((String)op.getSimpleName()))) != null) {
                final Provider<String> originalShadowingStringProvider = this.getSignature(feature, context);
                Provider<String> shadowingStringProvider = new Provider<String>(){

                    public String get() {
                        String result = String.valueOf(operator.toString()) + ((String)originalShadowingStringProvider.get()).substring(op.getSimpleName().length());
                        return result;
                    }
                };
                acceptor.accept((Object)this.createJvmFeatureDescription(operator, (JvmFeature)op, context, shadowingStringProvider, this.isVisible(feature), this.isValidStaticState(feature)));
            }
            if (syntacticalNumberOfArguments == 0) {
                String propertyName;
                acceptor.accept((Object)this.createJvmFeatureDescription((JvmFeature)op, context, new Provider<String>(){

                    public String get() {
                        return op.getSimpleName();
                    }
                }, this.isVisible(feature), this.isValidStaticState(feature)));
                if (this.isGetterMethod(op) && (propertyName = this.getPropertyNameForGetterMethod(op.getSimpleName())) != null) {
                    acceptor.accept((Object)this.createJvmFeatureDescription(QualifiedName.create((String)propertyName), (JvmFeature)op, context, propertyName, this.isVisible(feature), this.isValidStaticState(feature)));
                }
            }
        }
    }

    protected int getSyntacticalNumberOfArguments(JvmOperation op) {
        int numberOfArgs = op.getParameters().size();
        if (numberOfArgs == 0) {
            return numberOfArgs;
        }
        if (this.isExtensionProvider() || this.implicitArgument != null) {
            --numberOfArgs;
        }
        if (numberOfArgs == 1 && op.isVarArgs()) {
            --numberOfArgs;
        }
        return numberOfArgs;
    }

    protected boolean isGetterMethod(JvmOperation op) {
        if (this.getSyntacticalNumberOfArguments(op) != 0) {
            return false;
        }
        if (op.isVarArgs()) {
            return false;
        }
        return this.getPropertyNameForGetterMethod(op.getSimpleName()) != null;
    }

    protected String getPropertyNameForGetterMethod(String opName) {
        if (opName.startsWith("get") && opName.length() > 3 && Character.isUpperCase(opName.charAt(3))) {
            return Introspector.decapitalize(opName.substring(3));
        }
        if (opName.startsWith("is") && opName.length() > 2 && Character.isUpperCase(opName.charAt(2))) {
            return Introspector.decapitalize(opName.substring(2));
        }
        return null;
    }
}

