/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.loggerpropertyeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.ui.Utility;
import org.eclipse.stem.ui.adapters.loggerpropertyeditor.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class DecoratorPickerDialog
extends Dialog {
    private static final String DECORATORS_FOLDER_NAME = "decorators";
    private IProject project;
    private Set<String> selectedDecoratorProperties = new HashSet<String>();
    private IntegrationDecorator selectedDecorator = null;
    private Shell shell;
    private Composite mainComposite;
    private ListViewer availablePropertiesList;
    private ListViewer selectedPropertiesList;
    private Combo projectList;
    private ComboViewer decoratorList;
    private boolean cancelPressed = false;

    public DecoratorPickerDialog(Shell parent, int style, IProject project, Set<String> selectedDecoratorProperties) {
        super(parent, style);
        this.project = project;
        if (selectedDecoratorProperties != null) {
            this.selectedDecoratorProperties.addAll(selectedDecoratorProperties);
        }
    }

    public Set<String> getSelectedProperties() {
        return this.selectedDecoratorProperties;
    }

    public boolean open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 68704);
        this.shell.setMinimumSize(new Point(600, 400));
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setText(Messages.DPD_Title);
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
            }
        });
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 3;
        mainLayout.makeColumnsEqualWidth = false;
        mainLayout.marginBottom = 0;
        mainLayout.marginTop = 0;
        mainLayout.verticalSpacing = 0;
        this.mainComposite = new Composite((Composite)this.shell, 0);
        this.mainComposite.setLayout((Layout)mainLayout);
        this.createProjectDecoratorSelectorWidgets(this.mainComposite);
        this.createCompartmentSelectorWidgets(this.mainComposite);
        this.createDialogControlButtons(this.mainComposite);
        this.updateDecoratorsList();
        this.shell.pack();
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return !this.cancelPressed;
    }

    private void createProjectDecoratorSelectorWidgets(Composite parent) {
        Composite projectDecoratorSelectorComposite = new Composite(parent, 0);
        GridData projectDecoratorSelectorCompositeData = new GridData();
        projectDecoratorSelectorCompositeData.grabExcessHorizontalSpace = true;
        projectDecoratorSelectorCompositeData.horizontalSpan = 3;
        projectDecoratorSelectorCompositeData.widthHint = 500;
        projectDecoratorSelectorComposite.setLayoutData((Object)projectDecoratorSelectorCompositeData);
        GridLayout projectDecoratorSelectorLayout = new GridLayout(2, false);
        projectDecoratorSelectorComposite.setLayout((Layout)projectDecoratorSelectorLayout);
        Label projectLabel = new Label(projectDecoratorSelectorComposite, 0);
        GridData projectLabelData = new GridData();
        projectLabelData.grabExcessHorizontalSpace = false;
        projectLabel.setText(Messages.DPD_Project);
        projectLabel.setLayoutData((Object)projectLabelData);
        this.projectList = new Combo(projectDecoratorSelectorComposite, 8);
        GridData projectListLayoutData = new GridData();
        projectListLayoutData.grabExcessHorizontalSpace = true;
        this.projectList.setLayoutData((Object)projectListLayoutData);
        String[] projectNames = this.getProjectList();
        this.projectList.setItems(projectNames);
        this.projectList.select(this.getProjectIndex(projectNames));
        this.projectList.setSize(this.projectList.computeSize(-1, -1, true));
        Label decoratorLabel = new Label(projectDecoratorSelectorComposite, 0);
        GridData decoratorLabelData = new GridData();
        decoratorLabelData.grabExcessHorizontalSpace = false;
        decoratorLabel.setText(Messages.DPD_Decorator);
        decoratorLabel.setLayoutData((Object)decoratorLabelData);
        this.decoratorList = new ComboViewer(projectDecoratorSelectorComposite, 8);
        GridData decoratorListLayoutData = new GridData();
        decoratorListLayoutData.grabExcessHorizontalSpace = true;
        decoratorListLayoutData.minimumWidth = 300;
        this.decoratorList.getCombo().setLayoutData((Object)decoratorListLayoutData);
        this.decoratorList.getCombo().setSize(this.decoratorList.getCombo().computeSize(300, -1, true));
        this.projectList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DecoratorPickerDialog.this.selectedDecorator = null;
                DecoratorPickerDialog.this.updateDecoratorsList();
                DecoratorPickerDialog.this.updateAvailablePropertiesList();
            }
        });
        this.decoratorList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DecoratorPickerDialog.this.selectedDecorator = null;
                Object selected = ((StructuredSelection)event.getSelection()).getFirstElement();
                if (selected instanceof IntegrationDecorator) {
                    DecoratorPickerDialog.this.selectedDecorator = (IntegrationDecorator)selected;
                }
                DecoratorPickerDialog.this.updateAvailablePropertiesList();
            }
        });
        this.decoratorList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.decoratorList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                IntegrationDecorator decorator = (IntegrationDecorator)element;
                return decorator.getURI().lastSegment();
            }
        });
    }

    private void createCompartmentSelectorWidgets(Composite parent) {
        Label availablePropertiesLabel = new Label(parent, 0);
        availablePropertiesLabel.setLayoutData((Object)new GridData(-1, -1));
        availablePropertiesLabel.setText(Messages.DPD_AvailableProperties);
        Composite fillerComposite1 = new Composite(parent, 0);
        fillerComposite1.setLayoutData((Object)new GridData(-1, -1));
        Label selectedPropertiesLabel = new Label(parent, 0);
        selectedPropertiesLabel.setLayoutData((Object)new GridData(-1, -1));
        selectedPropertiesLabel.setText(Messages.DPD_SelectedProperties);
        this.createAvailablePropertiesViewer(parent);
        this.createListControlButtons(parent);
        this.createSelectedPropertiesViewer(parent);
    }

    private void createDialogControlButtons(Composite parent) {
        Composite footerComposite = new Composite(parent, 0);
        GridData footerLayoutData = new GridData();
        footerLayoutData.horizontalAlignment = 0x1000008;
        footerLayoutData.grabExcessHorizontalSpace = true;
        footerLayoutData.horizontalSpan = 3;
        footerComposite.setLayoutData((Object)footerLayoutData);
        RowLayout footerCompositeLayout = new RowLayout();
        footerCompositeLayout.fill = true;
        footerComposite.setLayout((Layout)footerCompositeLayout);
        Button okayButton = new Button(footerComposite, 0);
        okayButton.setText(Messages.DecoratorPickerDialog_DoneButton);
        Button cancelButton = new Button(footerComposite, 0);
        cancelButton.setText(Messages.DecoratorPickerDialog_CancelButton);
        okayButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DecoratorPickerDialog.this.cancelPressed = false;
                DecoratorPickerDialog.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DecoratorPickerDialog.this.cancelPressed = true;
                DecoratorPickerDialog.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void createListControlButtons(Composite parent) {
        Composite listControlComposite = new Composite(parent, 0);
        GridData listControlLayoutData = new GridData();
        listControlComposite.setLayoutData((Object)listControlLayoutData);
        RowLayout listControlCompositeLayout = new RowLayout(512);
        listControlCompositeLayout.justify = true;
        listControlCompositeLayout.pack = false;
        listControlComposite.setLayout((Layout)listControlCompositeLayout);
        Button addButton = new Button(listControlComposite, 8);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DecoratorPickerDialog.this.addSelectedProperties(false);
            }
        });
        addButton.setText(Messages.DPD_AddButton);
        Button addAllButton = new Button(listControlComposite, 8);
        addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DecoratorPickerDialog.this.addSelectedProperties(true);
            }
        });
        addAllButton.setText(Messages.DPD_AddAllButton);
        Button removeButton = new Button(listControlComposite, 8);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DecoratorPickerDialog.this.removeSelectedProperties(false);
            }
        });
        removeButton.setText(Messages.DPD_RemoveButton);
        Button removeAllButton = new Button(listControlComposite, 8);
        removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DecoratorPickerDialog.this.removeSelectedProperties(true);
            }
        });
        removeAllButton.setText(Messages.DPD_RemoveAllButton);
    }

    private void createSelectedPropertiesViewer(Composite parent) {
        this.selectedPropertiesList = new ListViewer(parent);
        org.eclipse.swt.widgets.List backingList = this.selectedPropertiesList.getList();
        backingList.setBounds(40, 20, 220, 100);
        GridData availablePropertiesListLayoutData = new GridData();
        availablePropertiesListLayoutData.widthHint = 500;
        availablePropertiesListLayoutData.heightHint = 300;
        availablePropertiesListLayoutData.grabExcessHorizontalSpace = true;
        availablePropertiesListLayoutData.grabExcessVerticalSpace = true;
        backingList.setLayoutData((Object)availablePropertiesListLayoutData);
        this.selectedPropertiesList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Set in = (Set)inputElement;
                return in.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.selectedPropertiesList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                String[] propertyElements = element.toString().split("\\#");
                if (propertyElements.length > 1) {
                    String uri = propertyElements[0];
                    String property = propertyElements[1];
                    String[] uriElements = uri.split("\\/");
                    if (uriElements.length > 0) {
                        String project = uriElements[2];
                        String decorator = uriElements[4];
                        return String.valueOf(project) + "/" + decorator + ":" + property;
                    }
                }
                return element.toString();
            }
        });
        this.selectedPropertiesList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this.selectedPropertiesList.setInput(this.selectedDecoratorProperties);
        this.selectedPropertiesList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((String)e1).compareTo((String)e2);
            }
        });
    }

    private void createAvailablePropertiesViewer(Composite parent) {
        this.availablePropertiesList = new ListViewer(parent);
        org.eclipse.swt.widgets.List backingList = this.availablePropertiesList.getList();
        backingList.setBounds(40, 20, 220, 100);
        GridData availablePropertiesListLayoutData = new GridData();
        availablePropertiesListLayoutData.widthHint = 200;
        availablePropertiesListLayoutData.heightHint = 300;
        availablePropertiesListLayoutData.grabExcessHorizontalSpace = true;
        availablePropertiesListLayoutData.grabExcessVerticalSpace = true;
        backingList.setLayoutData((Object)availablePropertiesListLayoutData);
        this.availablePropertiesList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (String[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.availablePropertiesList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                String[] elements = element.toString().split("\\#");
                if (elements.length > 1) {
                    return elements[1];
                }
                return element.toString();
            }
        });
        this.availablePropertiesList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this.availablePropertiesList.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !DecoratorPickerDialog.this.selectedDecoratorProperties.contains(element);
            }
        });
        this.availablePropertiesList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((String)e1).compareTo((String)e2);
            }
        });
    }

    private String[] getProjectList() {
        IProject[] projectsArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        Object[] projectNamesArray = new String[projectsArray.length];
        int idx = 0;
        IProject[] iProjectArray = projectsArray;
        int n = projectsArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            projectNamesArray[idx++] = proj.getName();
            ++n2;
        }
        Arrays.sort(projectNamesArray);
        return projectNamesArray;
    }

    private int getProjectIndex(String[] projects) {
        if (this.project != null) {
            return Arrays.binarySearch(projects, this.project.getName());
        }
        if (projects.length > 0) {
            return 0;
        }
        return -1;
    }

    private void updateDecoratorsList() {
        IProject selectedProject;
        String projectName;
        int projectIdx = this.projectList.getSelectionIndex();
        if (projectIdx >= 0 && (projectName = this.projectList.getItem(projectIdx)) != null && (selectedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null) {
            List<IntegrationDecorator> decorators = this.getDecoratorsForProject(selectedProject);
            this.decoratorList.setInput(decorators);
            this.decoratorList.getCombo().setSize(this.decoratorList.getCombo().computeSize(300, -1, true));
            if (decorators.size() > 0) {
                this.decoratorList.setSelection((ISelection)new StructuredSelection((Object)decorators.get(0)));
            }
            this.decoratorList.refresh(true);
            return;
        }
        this.decoratorList.setInput(null);
    }

    private String getStringForDecoratorProperty(IntegrationDecorator decorator, String property) {
        return String.valueOf(decorator.getURI().toString()) + "#" + property;
    }

    private void removeSelectedProperties(boolean all) {
        if (all) {
            int itemCount = this.selectedPropertiesList.getList().getItemCount();
            int idx = 0;
            while (idx < itemCount) {
                this.selectedDecoratorProperties.remove(this.selectedPropertiesList.getElementAt(idx));
                ++idx;
            }
        } else {
            int[] nArray = this.selectedPropertiesList.getList().getSelectionIndices();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int idx = nArray[n2];
                this.selectedDecoratorProperties.remove(this.selectedPropertiesList.getElementAt(idx));
                ++n2;
            }
        }
        this.availablePropertiesList.refresh();
        this.selectedPropertiesList.refresh();
    }

    private void addSelectedProperties(boolean all) {
        if (all) {
            int itemCount = this.availablePropertiesList.getList().getItemCount();
            int idx = 0;
            while (idx < itemCount) {
                this.selectedDecoratorProperties.add((String)this.availablePropertiesList.getElementAt(idx));
                ++idx;
            }
        } else {
            int[] nArray = this.availablePropertiesList.getList().getSelectionIndices();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int idx = nArray[n2];
                this.selectedDecoratorProperties.add((String)this.availablePropertiesList.getElementAt(idx));
                ++n2;
            }
        }
        this.availablePropertiesList.refresh();
        this.selectedPropertiesList.refresh();
    }

    private IntegrationDecorator getSelectedDecorator() {
        return this.selectedDecorator;
    }

    private void updateAvailablePropertiesList() {
        this.availablePropertiesList.setInput(null);
        IntegrationDecorator decorator = this.getSelectedDecorator();
        if (decorator == null) {
            return;
        }
        this.availablePropertiesList.setInput((Object)this.getPropertiesForDecorator(decorator));
    }

    private String[] getPropertiesForDecorator(IntegrationDecorator decorator) {
        ArrayList<String> props = new ArrayList<String>();
        EList populationIds = decorator.getAllLabelIdentifiers();
        if (populationIds != null) {
            for (String popId : populationIds) {
                for (IItemPropertyDescriptor prop : decorator.getCompartments(popId)) {
                    props.add(this.getStringForDecoratorProperty(decorator, String.valueOf(popId) + "/" + prop.getId(null)));
                }
            }
        } else {
            for (IItemPropertyDescriptor prop : decorator.getCompartments(null)) {
                props.add(this.getStringForDecoratorProperty(decorator, prop.getId(null)));
            }
        }
        return props.toArray(new String[props.size()]);
    }

    private List<IntegrationDecorator> getDecoratorsForProject(IProject project) {
        ArrayList<IntegrationDecorator> retVal;
        block7: {
            retVal = new ArrayList<IntegrationDecorator>();
            try {
                IResource[] members;
                IFolder folder = project.getFolder(DECORATORS_FOLDER_NAME);
                if (!folder.exists() || (members = folder.members()) == null) break block7;
                IResource[] iResourceArray = members;
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IFile) {
                        try {
                            Identifiable id = Utility.getIdentifiable((IFile)((IFile)resource));
                            if (id instanceof IntegrationDecorator) {
                                retVal.add((IntegrationDecorator)id);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    ++n2;
                }
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
        }
        return retVal;
    }
}

