/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.scenario.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.impl.IdentifiableFilterImpl;
import org.eclipse.stem.core.common.impl.IdentifiableImpl;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.UnresolvedIdentifiable;
import org.eclipse.stem.core.logger.Logger;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.core.scenario.ScenarioPackage;
import org.eclipse.stem.core.scenario.impl.Messages;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.core.solver.Solver;

public class ScenarioImpl
extends IdentifiableImpl
implements Scenario {
    protected static final URI CANONICAL_GRAPH_URI = URI.createURI((String)"stem:canonicalgraph");
    public static boolean reportEachUnresolvedIdentifiable = true;
    public static boolean reportDanglingAirTransportEdges = false;
    public static boolean reportNumberofUnresolvedIdentifiables = false;
    protected Model model;
    protected Sequencer sequencer;
    protected EList<Decorator> scenarioDecorators;
    protected Graph canonicalGraph;
    protected static final double PROGRESS_EDEFAULT = 0.0;
    protected double progress = 0.0;
    protected Solver solver;
    protected EList<Logger> loggers;

    protected ScenarioImpl() {
        this.setURI(STEMURI.createURI("scenario/" + STEMURI.generateUniquePart()));
        this.setTypeURI(STEMURI.SCENARIO_TYPE_URI);
    }

    @Override
    protected EClass eStaticClass() {
        return ScenarioPackage.Literals.SCENARIO;
    }

    @Override
    public Model getModel() {
        if (this.model != null && this.model.eIsProxy()) {
            InternalEObject oldModel = (InternalEObject)this.model;
            this.model = (Model)this.eResolveProxy(oldModel);
            if (this.model != oldModel && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldModel, (Object)this.model));
            }
        }
        return this.model;
    }

    public Model basicGetModel() {
        return this.model;
    }

    @Override
    public void setModel(Model newModel) {
        Model oldModel = this.model;
        this.model = newModel;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldModel, (Object)this.model));
        }
    }

    @Override
    public Sequencer getSequencer() {
        if (this.sequencer != null && this.sequencer.eIsProxy()) {
            InternalEObject oldSequencer = (InternalEObject)this.sequencer;
            this.sequencer = (Sequencer)this.eResolveProxy(oldSequencer);
            if (this.sequencer != oldSequencer && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldSequencer, (Object)this.sequencer));
            }
        }
        return this.sequencer;
    }

    public Sequencer basicGetSequencer() {
        return this.sequencer;
    }

    @Override
    public void setSequencer(Sequencer newSequencer) {
        Sequencer oldSequencer = this.sequencer;
        this.sequencer = newSequencer;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldSequencer, (Object)this.sequencer));
        }
    }

    @Override
    public Graph getCanonicalGraph() {
        return this.canonicalGraph;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(double newProgress) {
        double oldProgress = this.progress;
        this.progress = newProgress;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldProgress, this.progress));
        }
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    public NotificationChain basicSetSolver(Solver newSolver, NotificationChain msgs) {
        Solver oldSolver = this.solver;
        this.solver = newSolver;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldSolver, (Object)newSolver);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setSolver(Solver newSolver) {
        if (newSolver != this.solver) {
            NotificationChain msgs = null;
            if (this.solver != null) {
                msgs = ((InternalEObject)this.solver).eInverseRemove((InternalEObject)this, -9, null, msgs);
            }
            if (newSolver != null) {
                msgs = ((InternalEObject)newSolver).eInverseAdd((InternalEObject)this, -9, null, msgs);
            }
            if ((msgs = this.basicSetSolver(newSolver, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)newSolver, (Object)newSolver));
        }
    }

    @Override
    public EList<Logger> getLoggers() {
        if (this.loggers == null) {
            this.loggers = new EObjectResolvingEList(Logger.class, (InternalEObject)this, 9);
        }
        return this.loggers;
    }

    @Override
    public boolean step() {
        boolean success = true;
        if (!this.getSequencer().isTimeToStop()) {
            assert (this.sane());
            STEMTime currentTime = this.getSequencer().getNextTime();
            long timeDelta = this.getSequencer().getTimeDelta();
            for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
                decorator.setProgress(0.0);
            }
            success = this.getSolver().step(currentTime, timeDelta, this.getSequencer().getCycle());
            assert (this.sane());
            this.getCanonicalGraph().switchToNextValue(currentTime);
        }
        if (success) {
            success = !this.getSequencer().isTimeToStop();
        }
        return success;
    }

    @Override
    public void reset() throws ScenarioInitializationException {
        this.getSequencer().reset();
        this.getCanonicalGraph().setTime((STEMTime)EcoreUtil.copy((EObject)this.getSequencer().getCurrentTime()));
        ArrayList<Decorator> intDecorators = new ArrayList<Decorator>();
        ArrayList<Decorator> otherDecorators = new ArrayList<Decorator>();
        for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
            if (decorator instanceof IntegrationDecorator) {
                intDecorators.add(decorator);
                continue;
            }
            otherDecorators.add(decorator);
        }
        for (Decorator decorator : intDecorators) {
            if (!decorator.isEnabled()) continue;
            decorator.resetLabels();
        }
        for (Decorator decorator : otherDecorators) {
            if (!decorator.isEnabled()) continue;
            decorator.resetLabels();
        }
        this.getSolver().reset();
    }

    @Override
    public void initialize() throws ScenarioInitializationException {
        if (this.getSequencer() == null) {
            throw new ScenarioInitializationException(NLS.bind((String)Messages.MISSING_SEQUENCER, (Object[])new Object[]{this.getURI().toString()}), this, new Exception());
        }
        this.getSequencer().reset();
        STEMTime start = this.getSequencer().getStartTime();
        if (this.getModel() == null) {
            throw new ScenarioInitializationException(NLS.bind((String)Messages.MISSING_MODEL, (Object[])new Object[]{this}), this, new Exception());
        }
        this.getModel().prepare(start);
        this.canonicalGraph = this.getModel().getCanonicalGraph(CANONICAL_GRAPH_URI, new IdentifiableFilterImpl(this.getModel().getDublinCore().getCoverage()), start);
        this.getCanonicalGraph().setTime((STEMTime)EcoreUtil.copy((EObject)this.getSequencer().getCurrentTime()));
        Iterator unresolved = this.getCanonicalGraph().getUnresolvedIdentifiables().iterator();
        while (unresolved.hasNext()) {
            UnresolvedIdentifiable temp = (UnresolvedIdentifiable)unresolved.next();
            if (this.getCanonicalGraph().getNodes().get((Object)temp.getUnresolvedURI()) == null && this.getCanonicalGraph().getEdges().get((Object)temp.getUnresolvedURI()) == null) continue;
            unresolved.remove();
        }
        assert (this.getCanonicalGraph().sane());
        final double numDecorators = this.getCanonicalGraph().getDecorators().size();
        final ScenarioImpl self = this;
        for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
            decorator.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    Decorator cfr_ignored_0 = (Decorator)msg.getNotifier();
                    switch (msg.getFeatureID(Decorator.class)) {
                        case 7: {
                            double delta = msg.getNewDoubleValue() - msg.getOldDoubleValue();
                            self.setProgress(self.getProgress() + (delta /= numDecorators));
                        }
                    }
                }
            });
        }
        ArrayList<Decorator> intDecorators = new ArrayList<Decorator>();
        ArrayList<Decorator> otherDecorators = new ArrayList<Decorator>();
        Iterator scenarioDecorators = this.getScenarioDecorators().iterator();
        while (scenarioDecorators.hasNext()) {
            Decorator decorator = (Decorator)EcoreUtil.copy((EObject)((Decorator)scenarioDecorators.next()));
            if (decorator instanceof IntegrationDecorator) {
                intDecorators.add(decorator);
                continue;
            }
            otherDecorators.add(decorator);
        }
        for (Decorator decorator : intDecorators) {
            this.getCanonicalGraph().getDecorators().add((Object)decorator);
            decorator.decorateGraph(start);
            decorator.setGraphDecorated(true);
        }
        for (Decorator decorator : otherDecorators) {
            this.getCanonicalGraph().getDecorators().add((Object)decorator);
            decorator.decorateGraph(start);
            decorator.setGraphDecorated(true);
        }
        if (reportEachUnresolvedIdentifiable && this.getCanonicalGraph().getUnresolvedIdentifiables().size() > 0) {
            this.logUnresolvedIdentifiables();
        }
        if (reportNumberofUnresolvedIdentifiables && this.getCanonicalGraph().getUnresolvedIdentifiables().size() > 0) {
            this.logNumberOfUnresolvedIdentifiables();
        }
    }

    @Override
    public String produceTitle() {
        String retValue = this.getURI().lastSegment();
        if (retValue.contains(".")) {
            return retValue.substring(0, retValue.indexOf("."));
        }
        return retValue;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return this.basicSetSolver(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public EList<Decorator> getScenarioDecorators() {
        if (this.scenarioDecorators == null) {
            this.scenarioDecorators = new EObjectResolvingEList(Decorator.class, (InternalEObject)this, 5);
        }
        return this.scenarioDecorators;
    }

    private void logUnresolvedIdentifiables() {
        for (UnresolvedIdentifiable unresolvedID : this.getCanonicalGraph().getUnresolvedIdentifiables()) {
            CorePlugin.logInformation("In scenario " + this.produceTitle() + "\", model \"" + unresolvedID.getModel().getDublinCore().getTitle() + "\",  the URI \"" + unresolvedID.getUnresolvedURI() + "\" was unresolved.", null);
        }
    }

    private void logNumberOfUnresolvedIdentifiables() {
        CorePlugin.logInformation("In scenario \"" + this.produceTitle() + "\", there were " + this.getCanonicalGraph().getUnresolvedIdentifiables().size() + " unresolved references.", null);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                if (resolve) {
                    return this.getModel();
                }
                return this.basicGetModel();
            }
            case 4: {
                if (resolve) {
                    return this.getSequencer();
                }
                return this.basicGetSequencer();
            }
            case 5: {
                return this.getScenarioDecorators();
            }
            case 6: {
                return this.getCanonicalGraph();
            }
            case 7: {
                return this.getProgress();
            }
            case 8: {
                return this.getSolver();
            }
            case 9: {
                return this.getLoggers();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setModel((Model)newValue);
                return;
            }
            case 4: {
                this.setSequencer((Sequencer)newValue);
                return;
            }
            case 5: {
                this.getScenarioDecorators().clear();
                this.getScenarioDecorators().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setProgress((Double)newValue);
                return;
            }
            case 8: {
                this.setSolver((Solver)newValue);
                return;
            }
            case 9: {
                this.getLoggers().clear();
                this.getLoggers().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setModel(null);
                return;
            }
            case 4: {
                this.setSequencer(null);
                return;
            }
            case 5: {
                this.getScenarioDecorators().clear();
                return;
            }
            case 7: {
                this.setProgress(0.0);
                return;
            }
            case 8: {
                this.setSolver(null);
                return;
            }
            case 9: {
                this.getLoggers().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.model != null;
            }
            case 4: {
                return this.sequencer != null;
            }
            case 5: {
                return this.scenarioDecorators != null && !this.scenarioDecorators.isEmpty();
            }
            case 6: {
                return this.canonicalGraph != null;
            }
            case 7: {
                return this.progress != 0.0;
            }
            case 8: {
                return this.solver != null;
            }
            case 9: {
                return this.loggers != null && !this.loggers.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        String title = this.getDublinCore().getTitle();
        return title != null ? title : super.toString();
    }

    @Override
    public boolean sane() {
        boolean retValue = super.sane();
        if (retValue && this.getModel() != null) {
            boolean bl = retValue = retValue && this.getModel().sane();
            assert (retValue);
        }
        if (retValue && this.getCanonicalGraph() != null) {
            boolean bl = retValue = retValue && this.getCanonicalGraph().sane();
            assert (retValue);
        }
        if (retValue && this.getSequencer() != null) {
            boolean bl = retValue = retValue && this.getSequencer().sane();
            assert (retValue);
        }
        return retValue;
    }
}

