/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.foodproduction.presentation;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.foodproduction.Activator;
import org.eclipse.stem.foodproduction.FoodTransformer;
import org.eclipse.stem.foodproduction.presentation.FoodProductionMessages;
import org.eclipse.stem.foodproduction.presentation.FoodProductionPropertyComposite;
import org.eclipse.stem.foodproduction.presentation.NewFoodTransformerWizard;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class FoodProductionDefinitionControl
extends Composite {
    private static FoodTransformer[] foodTransformers = null;
    private final Combo combo;
    private final FoodProductionPropertyComposite foodProductionPropertyComposite;
    private NewFoodTransformerWizard newFoodTransformerWizard = null;

    public FoodProductionDefinitionControl(Composite parent, int style, ModifyListener projectValidator, IProject project, NewFoodTransformerWizard nfpw) {
        super(parent, style);
        this.newFoodTransformerWizard = nfpw;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label foodTransformerLabel = new Label((Composite)this, 0);
        GridData gd_diseaseModelLabel = new GridData(4, 0x1000000, true, false);
        gd_diseaseModelLabel.widthHint = 100;
        foodTransformerLabel.setLayoutData((Object)gd_diseaseModelLabel);
        foodTransformerLabel.setText(FoodProductionMessages.getString("FPC.0"));
        this.combo = new Combo((Composite)this, 8);
        this.combo.setTextLimit(30);
        GridData gd_combo = new GridData(4, 0x1000000, true, false);
        gd_combo.widthHint = 303;
        this.combo.setLayoutData((Object)gd_combo);
        this.combo.setToolTipText(FoodProductionMessages.getString("FPC.1"));
        this.combo.setItems(this.getFoodTransformerNames(this.getFoodTransformers()));
        this.combo.select(0);
        this.combo.addModifyListener(projectValidator);
        Label separator = new Label((Composite)this, 258);
        GridData sepData = new GridData(4, 128, true, false);
        sepData.horizontalSpan = 2;
        separator.setLayoutData((Object)sepData);
        this.foodProductionPropertyComposite = new FoodProductionPropertyComposite(this, 0, this.getFoodTransformers(), projectValidator, project);
        GridData gd_diseaseModelPropertyControl = new GridData(4, 0x1000000, true, false, 2, 1);
        this.foodProductionPropertyComposite.setLayoutData(gd_diseaseModelPropertyControl);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FoodProductionDefinitionControl.this.foodProductionPropertyComposite.displayFoodTransformer(FoodProductionDefinitionControl.this.getFoodTransformers()[FoodProductionDefinitionControl.this.combo.getSelectionIndex()]);
                ((FoodProductionDefinitionControl)FoodProductionDefinitionControl.this).newFoodTransformerWizard.newDublinCorePage.updateDublinCorePage(FoodProductionDefinitionControl.this.getSelectedFoodTransformer().getDublinCore());
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newdisease_contextid");
    }

    private FoodTransformer[] getFoodTransformers() {
        if (foodTransformers == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] fpConfigElements = registry.getConfigurationElementsFor("org.eclipse.stem.foodproduction.foodproducer");
            ArrayList<FoodTransformer> temp = new ArrayList<FoodTransformer>();
            int i = 0;
            while (i < fpConfigElements.length) {
                IConfigurationElement element = fpConfigElements[i];
                FoodTransformer foodTransformer = null;
                if (element.getName().equals("classdef")) {
                    try {
                        foodTransformer = (FoodTransformer)element.createExecutableExtension("class");
                        temp.add(foodTransformer);
                    }
                    catch (CoreException e) {
                        Activator.logError((String)FoodProductionMessages.getString("FPC.3"), (Throwable)e);
                    }
                }
                ++i;
            }
            foodTransformers = temp.toArray(new FoodTransformer[0]);
        }
        FoodTransformer[] foodTransformerArray = foodTransformers;
        int n = foodTransformers.length;
        int n2 = 0;
        while (n2 < n) {
            DublinCore dublinCore;
            FoodTransformer foodTransformer = foodTransformerArray[n2];
            if (foodTransformer != null && (dublinCore = Activator.getPluginDublinCore((FoodTransformer)foodTransformer)) != null) {
                foodTransformer.setDublinCore(dublinCore);
            }
            ++n2;
        }
        return foodTransformers;
    }

    private String[] getFoodTransformerNames(FoodTransformer[] foodTransformers) {
        String[] retValue = new String[foodTransformers.length];
        int i = 0;
        while (i < foodTransformers.length) {
            String name = foodTransformers[i].getDublinCore().getTitle();
            if (name == null || name.equals("")) {
                name = foodTransformers[i].getClass().getSimpleName();
            }
            retValue[i] = name;
            ++i;
        }
        return retValue;
    }

    FoodTransformer getSelectedFoodTransformer() {
        FoodTransformer retValue = (FoodTransformer)EcoreUtil.copy((EObject)this.getFoodTransformers()[this.combo.getSelectionIndex()]);
        this.foodProductionPropertyComposite.populateFoodTransformer(retValue);
        return retValue;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public boolean validate() {
        return this.foodProductionPropertyComposite.validate();
    }

    public String getErrorMessage() {
        return this.foodProductionPropertyComposite.getErrorMessage();
    }
}

