/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphgenerators.impl;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.definitions.LocationUtility;
import org.eclipse.stem.definitions.edges.EdgesFactory;
import org.eclipse.stem.definitions.edges.MixingEdge;
import org.eclipse.stem.definitions.edges.MixingEdgeLabel;
import org.eclipse.stem.definitions.edges.MixingEdgeLabelValue;
import org.eclipse.stem.definitions.edges.impl.EdgesFactoryImpl;
import org.eclipse.stem.graphgenerators.GraphgeneratorsPackage;
import org.eclipse.stem.graphgenerators.MixingEdgeGraphGenerator;
import org.eclipse.stem.graphgenerators.impl.GraphGeneratorImpl;

public class MixingEdgeGraphGeneratorImpl
extends GraphGeneratorImpl
implements MixingEdgeGraphGenerator {
    protected static final URI LOCATION_EDEFAULT = null;
    protected URI location = LOCATION_EDEFAULT;
    protected static final double MIXING_RATE_EDEFAULT = 0.1;
    protected double mixingRate = 0.1;
    protected static final String POPULATION_EDEFAULT = "human";
    protected String population = "human";
    protected static final boolean USE_ABSOLUTE_VALUES_EDEFAULT = false;
    protected boolean useAbsoluteValues = false;
    private IProject project;

    @Override
    protected EClass eStaticClass() {
        return GraphgeneratorsPackage.Literals.MIXING_EDGE_GRAPH_GENERATOR;
    }

    @Override
    public Graph getGraph() {
        Graph graph = GraphFactory.eINSTANCE.createGraph();
        DublinCore dc = graph.getDublinCore();
        dc.populate();
        dc.setTitle("Migration Edges");
        dc.setSource(this.getClass().getSimpleName());
        Calendar c = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("E yyyy.MM.dd 'at' hh:mm:ss a zzz");
        String valid = formatter.format(c.getTime());
        dc.setValid(valid);
        Set commonBorderEdges = LocationUtility.getCommonBorderEdges((IProject)this.project, (URI)this.getLocation());
        Iterator iter = commonBorderEdges.iterator();
        while (iter != null && iter.hasNext()) {
            Edge e = (Edge)iter.next();
            URI sourceURI = e.getNodeAURI();
            URI targetURI = e.getNodeBURI();
            EdgesFactory ef = EdgesFactoryImpl.init();
            MixingEdge mEdge1 = ef.createMixingEdge();
            URI edgeURI1 = mEdge1.getURI();
            String s1 = edgeURI1.toString();
            int last = s1.lastIndexOf("/");
            String sEdge1 = s1.substring(0, last);
            String sEdge2 = s1.substring(last, s1.length());
            s1 = String.valueOf(sEdge1) + "/relationship/mixing" + sEdge2;
            URI newURI = URI.createURI((String)s1);
            mEdge1.setURI(newURI);
            mEdge1.setNodeAURI(sourceURI);
            mEdge1.setNodeBURI(targetURI);
            MixingEdgeLabel label1 = mEdge1.getLabel();
            label1.setURI(MixingEdgeGraphGeneratorImpl.createEdgeLabelURI(sourceURI, targetURI));
            MixingEdgeLabelValue melv1 = label1.getCurrentValue();
            melv1.setMixingRate(this.getMixingRate());
            mEdge1.setUseAbsoluteValues(this.useAbsoluteValues);
            mEdge1.setDirected(false);
            DublinCore dc1 = mEdge1.getDublinCore();
            dc1.setTitle(MixingEdgeGraphGeneratorImpl.createEdgeTitle(sourceURI, targetURI));
            mEdge1.setPopulationIdentifier(this.getPopulation());
            graph.putEdge((Edge)mEdge1);
        }
        assert (graph.sane());
        return graph;
    }

    private static URI createEdgeLabelURI(URI uriA, URI uriB) {
        String sA = uriA.lastSegment();
        String sB = uriB.lastSegment();
        sA = sA.replace('_', '.');
        sB = sB.replace('_', '.');
        String uriString = String.valueOf(sA) + "_" + sB;
        URI uri = STEMURI.createURI((String)uriString);
        return uri;
    }

    public static String createEdgeTitle(URI uriA, URI uriB) {
        String sA = uriA.lastSegment();
        String sB = uriB.lastSegment();
        StringBuilder sb = new StringBuilder("MixingEdge[(");
        sb.append(sA);
        sb.append(")<-->(");
        sb.append(sB);
        sb.append(")]");
        return sb.toString();
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(URI newLocation) {
        URI oldLocation = this.location;
        this.location = newLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldLocation, (Object)this.location));
        }
    }

    @Override
    public double getMixingRate() {
        return this.mixingRate;
    }

    @Override
    public void setMixingRate(double newMixingRate) {
        double oldMixingRate = this.mixingRate;
        this.mixingRate = newMixingRate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldMixingRate, this.mixingRate));
        }
    }

    @Override
    public String getPopulation() {
        return this.population;
    }

    @Override
    public void setPopulation(String newPopulation) {
        String oldPopulation = this.population;
        this.population = newPopulation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldPopulation, (Object)this.population));
        }
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(IProject p) {
        this.project = p;
    }

    @Override
    public boolean isUseAbsoluteValues() {
        return this.useAbsoluteValues;
    }

    @Override
    public void setUseAbsoluteValues(boolean newUseAbsoluteValues) {
        boolean oldUseAbsoluteValues = this.useAbsoluteValues;
        this.useAbsoluteValues = newUseAbsoluteValues;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldUseAbsoluteValues, this.useAbsoluteValues));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getLocation();
            }
            case 4: {
                return this.getMixingRate();
            }
            case 5: {
                return this.getPopulation();
            }
            case 6: {
                return this.isUseAbsoluteValues();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setLocation((URI)newValue);
                return;
            }
            case 4: {
                this.setMixingRate((Double)newValue);
                return;
            }
            case 5: {
                this.setPopulation((String)newValue);
                return;
            }
            case 6: {
                this.setUseAbsoluteValues((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
            case 4: {
                this.setMixingRate(0.1);
                return;
            }
            case 5: {
                this.setPopulation(POPULATION_EDEFAULT);
                return;
            }
            case 6: {
                this.setUseAbsoluteValues(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals(this.location);
            }
            case 4: {
                return this.mixingRate != 0.1;
            }
            case 5: {
                return POPULATION_EDEFAULT == null ? this.population != null : !POPULATION_EDEFAULT.equals(this.population);
            }
            case 6: {
                return this.useAbsoluteValues;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (location: ");
        result.append(this.location);
        result.append(", mixingRate: ");
        result.append(this.mixingRate);
        result.append(", population: ");
        result.append(this.population);
        result.append(", useAbsoluteValues: ");
        result.append(this.useAbsoluteValues);
        result.append(')');
        return result.toString();
    }
}

