/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.apache.batik.util.gui.ExtendedGridBagConstraints;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.ButtonFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.resources.ResourceManager;

public class JErrorPane
extends JPanel
implements ActionMap {
    protected static final String RESOURCES = "org.apache.batik.util.gui.resources.JErrorPane";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.util.gui.resources.JErrorPane", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected String msg;
    protected String stacktrace;
    protected ButtonFactory bf = new ButtonFactory(bundle, this);
    protected JComponent detailsArea;
    protected JButton showDetailButton;
    protected boolean isDetailShown = false;
    protected JPanel subpanel;
    protected JButton okButton;
    protected Map listeners = new HashMap();

    public JErrorPane(Throwable throwable, int n) {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.listeners.put("ShowDetailButtonAction", new ShowDetailButtonAction());
        this.listeners.put("OKButtonAction", new OKButtonAction());
        this.msg = bundle.getString("Heading.text") + "\n\n" + throwable.getMessage();
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        stringWriter.flush();
        this.stacktrace = stringWriter.toString();
        ExtendedGridBagConstraints extendedGridBagConstraints = new ExtendedGridBagConstraints();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(this.msg);
        jTextArea.setColumns(50);
        jTextArea.setFont(new JLabel().getFont());
        jTextArea.setForeground(new JLabel().getForeground());
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        extendedGridBagConstraints.setWeight(0.0, 0.0);
        extendedGridBagConstraints.anchor = 17;
        extendedGridBagConstraints.fill = 0;
        extendedGridBagConstraints.setGridBounds(0, 0, 1, 1);
        this.add((Component)jTextArea, extendedGridBagConstraints);
        extendedGridBagConstraints.setWeight(1.0, 0.0);
        extendedGridBagConstraints.anchor = 10;
        extendedGridBagConstraints.fill = 2;
        extendedGridBagConstraints.setGridBounds(0, 1, 1, 1);
        this.add((Component)this.createButtonsPanel(), extendedGridBagConstraints);
        JTextArea jTextArea2 = new JTextArea();
        jTextArea.setColumns(50);
        jTextArea2.setText(this.stacktrace);
        jTextArea2.setEditable(false);
        this.detailsArea = new JPanel(new BorderLayout(0, 10));
        this.detailsArea.add((Component)new JSeparator(), "North");
        this.detailsArea.add((Component)new JScrollPane(jTextArea2), "Center");
        this.subpanel = new JPanel(new BorderLayout());
        extendedGridBagConstraints.insets = new Insets(10, 4, 4, 4);
        extendedGridBagConstraints.setWeight(1.0, 1.0);
        extendedGridBagConstraints.anchor = 10;
        extendedGridBagConstraints.fill = 1;
        extendedGridBagConstraints.setGridBounds(0, 2, 1, 1);
        this.add((Component)this.subpanel, extendedGridBagConstraints);
    }

    public JDialog createDialog(Component component, String string) {
        JDialog jDialog = new JDialog(JOptionPane.getFrameForComponent(component), string);
        jDialog.getContentPane().add((Component)this, "Center");
        jDialog.pack();
        jDialog.getRootPane().setDefaultButton(this.okButton);
        return jDialog;
    }

    protected JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.showDetailButton = this.bf.createJButton("ShowDetailButton");
        jPanel.add(this.showDetailButton);
        this.okButton = this.bf.createJButton("OKButton");
        jPanel.add(this.okButton);
        return jPanel;
    }

    @Override
    public Action getAction(String string) throws MissingListenerException {
        return (Action)this.listeners.get(string);
    }

    protected class OKButtonAction
    extends AbstractAction {
        protected OKButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ((JDialog)JErrorPane.this.getTopLevelAncestor()).dispose();
        }
    }

    protected class ShowDetailButtonAction
    extends AbstractAction {
        protected ShowDetailButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JErrorPane.this.isDetailShown) {
                JErrorPane.this.subpanel.remove(JErrorPane.this.detailsArea);
                JErrorPane.this.isDetailShown = false;
                JErrorPane.this.showDetailButton.setText(resources.getString("ShowDetailButton.text"));
            } else {
                JErrorPane.this.subpanel.add((Component)JErrorPane.this.detailsArea, "Center");
                JErrorPane.this.showDetailButton.setText(resources.getString("ShowDetailButton.text2"));
                JErrorPane.this.isDetailShown = true;
            }
            ((JDialog)JErrorPane.this.getTopLevelAncestor()).pack();
        }
    }
}

