/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.util.ControlWorkflowMatcherCompletable;
import org.eclipse.jdt.internal.corext.util.ControlWorkflowMatcherRunnable;
import org.eclipse.jdt.internal.corext.util.NodeMatcher;

public final class ControlWorkflowMatcher
implements ControlWorkflowMatcherCompletable,
ControlWorkflowMatcherRunnable {
    private int idGenerator = 1;
    private int nbWorkflow;
    private List<List<NodeMatcher<Expression>>> conditionsByWorkflow = new ArrayList<List<NodeMatcher<Expression>>>();
    private List<List<NodeMatcher<Statement>>> statementsByWorkflow = new ArrayList<List<NodeMatcher<Statement>>>();
    private List<NodeMatcher<Expression>> returnedValuesByWorkflow = new ArrayList<NodeMatcher<Expression>>();

    private ControlWorkflowMatcher() {
    }

    public static ControlWorkflowMatcherRunnable createControlWorkflowMatcher() {
        return new ControlWorkflowMatcher();
    }

    @Override
    public ControlWorkflowMatcherCompletable addWorkflow(NodeMatcher<Expression> condition) {
        ++this.nbWorkflow;
        ArrayList<NodeMatcher<Expression>> conditions = new ArrayList<NodeMatcher<Expression>>();
        conditions.add(condition);
        this.conditionsByWorkflow.add(conditions);
        this.statementsByWorkflow.add(new ArrayList());
        this.returnedValuesByWorkflow.add(null);
        return this;
    }

    @Override
    public ControlWorkflowMatcherCompletable condition(NodeMatcher<Expression> condition) {
        this.conditionsByWorkflow.get(this.nbWorkflow - 1).add(condition);
        return this;
    }

    @Override
    public ControlWorkflowMatcherCompletable statement(NodeMatcher<Statement> statement) {
        this.statementsByWorkflow.get(this.nbWorkflow - 1).add(statement);
        return this;
    }

    @Override
    public ControlWorkflowMatcherRunnable returnedValue(NodeMatcher<Expression> returnedValue) {
        this.returnedValuesByWorkflow.set(this.nbWorkflow - 1, returnedValue);
        return this;
    }

    @Override
    public boolean isMatching(Statement statement) {
        return this.isMatching(Arrays.asList(statement));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isMatching(List<Statement> actualStatements) {
        try {
            ControlWorkflowNode actualNode = this.buildActualNodes(actualStatements);
            this.expandActualNode(actualNode);
            HashSet<Integer> actualLastNodes = new HashSet<Integer>();
            this.collectActualLastNodes(actualNode, actualLastNodes);
            if (actualLastNodes.size() != this.nbWorkflow) {
                return false;
            }
            boolean isPassive = this.isPassive(actualNode);
            int i = 0;
            while (true) {
                if (i >= this.nbWorkflow) {
                    return actualLastNodes.isEmpty();
                }
                if (!this.doMatching(actualNode, i, actualLastNodes, isPassive)) {
                    return false;
                }
                ++i;
            }
        }
        catch (AbortSearchException abortSearchException) {
            return false;
        }
    }

    private boolean doMatching(ControlWorkflowNode actualNode, int i, Set<Integer> actualLastNodes, boolean isPassive) {
        ControlWorkflowNode currentActualNode = actualNode;
        ArrayList remainingConditions = new ArrayList(this.conditionsByWorkflow.get(i));
        while (!remainingConditions.isEmpty()) {
            if (currentActualNode == null || currentActualNode.getCondition() == null) {
                return false;
            }
            Boolean matching = null;
            Iterator iterator = remainingConditions.iterator();
            while (iterator.hasNext()) {
                NodeMatcher nodeMatcher = (NodeMatcher)iterator.next();
                matching = nodeMatcher.isMatching(currentActualNode.getCondition());
                if (matching != null) {
                    iterator.remove();
                    break;
                }
                if (isPassive) continue;
                return false;
            }
            if (matching == null) {
                return false;
            }
            currentActualNode = matching != false ? currentActualNode.getThenNode() : currentActualNode.getElseNode();
        }
        if (currentActualNode.getCondition() != null || currentActualNode.getFinalStatement() != null == ControlWorkflowMatcher.isEmpty((Collection)this.statementsByWorkflow.get(i)) || currentActualNode.getReturnedValue() != null ^ this.returnedValuesByWorkflow.get(i) != null) {
            return false;
        }
        if (!ControlWorkflowMatcher.isEmpty((Collection)this.statementsByWorkflow.get(i))) {
            if (Boolean.TRUE.equals(this.statementsByWorkflow.get(i).get(0).isMatching(currentActualNode.getFinalStatement())) && actualLastNodes.contains(currentActualNode.getId())) {
                actualLastNodes.remove(currentActualNode.getId());
                return true;
            }
        } else if (this.returnedValuesByWorkflow.get(i) != null && Boolean.TRUE.equals(this.returnedValuesByWorkflow.get(i).isMatching(currentActualNode.getReturnedValue())) && actualLastNodes.contains(currentActualNode.getId())) {
            actualLastNodes.remove(currentActualNode.getId());
            return true;
        }
        return false;
    }

    private void collectActualLastNodes(ControlWorkflowNode actualNode, Set<Integer> actualLastNodes) {
        if (actualNode.getCondition() == null) {
            if (actualNode.getThenNode() != null || actualNode.getElseNode() != null || actualNode.getReturnedValue() == null && actualNode.getFinalStatement() == null) {
                throw new AbortSearchException();
            }
            actualLastNodes.add(actualNode.getId());
        } else {
            if (actualNode.getThenNode() == null || actualNode.getElseNode() == null || actualNode.getReturnedValue() != null || actualNode.getFinalStatement() != null) {
                throw new AbortSearchException();
            }
            this.collectActualLastNodes(actualNode.getThenNode(), actualLastNodes);
            this.collectActualLastNodes(actualNode.getElseNode(), actualLastNodes);
        }
    }

    private boolean isPassive(ControlWorkflowNode actualNode) {
        return actualNode.getCondition() == null || ASTNodes.isPassive((ASTNode)actualNode.getCondition()) && this.isPassive(actualNode.getThenNode()) && this.isPassive(actualNode.getElseNode());
    }

    private void expandActualNode(ControlWorkflowNode actualNode) {
        if (actualNode.getCondition() == null) {
            return;
        }
        PrefixExpression prefixExpression = ASTNodes.as(actualNode.getCondition(), PrefixExpression.class);
        ConditionalExpression ternaryExpression = ASTNodes.as(actualNode.getCondition(), ConditionalExpression.class);
        InfixExpression infixExpression = ASTNodes.as(actualNode.getCondition(), InfixExpression.class);
        if (prefixExpression != null) {
            if (ASTNodes.hasOperator(prefixExpression, PrefixExpression.Operator.NOT, new PrefixExpression.Operator[0])) {
                ControlWorkflowNode oppositeNode = actualNode.getThenNode();
                actualNode.setThenNode(actualNode.getElseNode());
                actualNode.setElseNode(oppositeNode);
                actualNode.setCondition(prefixExpression.getOperand());
                this.expandActualNode(actualNode);
                return;
            }
        } else {
            if (ternaryExpression != null) {
                ControlWorkflowNode node1 = new ControlWorkflowNode();
                node1.setCondition(ternaryExpression.getThenExpression());
                node1.setThenNode(this.cloneNode(actualNode.getThenNode()));
                node1.setElseNode(this.cloneNode(actualNode.getElseNode()));
                ControlWorkflowNode node2 = new ControlWorkflowNode();
                node2.setCondition(ternaryExpression.getElseExpression());
                node2.setThenNode(this.cloneNode(actualNode.getThenNode()));
                node2.setElseNode(this.cloneNode(actualNode.getElseNode()));
                actualNode.setCondition(ternaryExpression.getExpression());
                actualNode.setThenNode(node1);
                actualNode.setElseNode(node2);
                this.expandActualNode(actualNode);
                return;
            }
            if (infixExpression != null && ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.CONDITIONAL_AND, InfixExpression.Operator.AND, InfixExpression.Operator.CONDITIONAL_OR, InfixExpression.Operator.OR)) {
                List<Expression> allOperands = ASTNodes.allOperands(infixExpression);
                Expression firstOperand = allOperands.remove(0);
                ControlWorkflowNode currentNode = actualNode;
                for (Expression operand : allOperands) {
                    ControlWorkflowNode subNode = new ControlWorkflowNode();
                    subNode.setCondition(operand);
                    subNode.setThenNode(this.cloneNode(currentNode.getThenNode()));
                    subNode.setElseNode(this.cloneNode(currentNode.getElseNode()));
                    currentNode.setCondition(firstOperand);
                    if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.CONDITIONAL_AND, InfixExpression.Operator.AND)) {
                        currentNode.setThenNode(subNode);
                    } else {
                        currentNode.setElseNode(subNode);
                    }
                    currentNode = subNode;
                }
                this.expandActualNode(actualNode);
                return;
            }
            if (infixExpression != null && !infixExpression.hasExtendedOperands() && ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.XOR, new InfixExpression.Operator[0])) {
                ControlWorkflowNode subNode1 = new ControlWorkflowNode();
                subNode1.setCondition(infixExpression.getRightOperand());
                subNode1.setThenNode(this.cloneNode(actualNode.getElseNode()));
                subNode1.setElseNode(this.cloneNode(actualNode.getThenNode()));
                ControlWorkflowNode subNode2 = new ControlWorkflowNode();
                subNode2.setCondition(infixExpression.getRightOperand());
                subNode2.setThenNode(this.cloneNode(actualNode.getThenNode()));
                subNode2.setElseNode(this.cloneNode(actualNode.getElseNode()));
                actualNode.setCondition(infixExpression.getLeftOperand());
                actualNode.setThenNode(subNode1);
                actualNode.setElseNode(subNode2);
                this.expandActualNode(actualNode);
                return;
            }
        }
        this.expandActualNode(actualNode.getThenNode());
        this.expandActualNode(actualNode.getElseNode());
    }

    private ControlWorkflowNode cloneNode(ControlWorkflowNode actualNode) {
        if (actualNode == null) {
            return null;
        }
        ControlWorkflowNode clone = new ControlWorkflowNode();
        clone.setCondition(actualNode.getCondition());
        clone.setReturnedValue(actualNode.getReturnedValue());
        clone.setFinalStatement(actualNode.getFinalStatement());
        clone.setThenNode(this.cloneNode(actualNode.getThenNode()));
        clone.setElseNode(this.cloneNode(actualNode.getElseNode()));
        return clone;
    }

    private ControlWorkflowNode buildActualNodes(Statement actualStatement) {
        if (actualStatement == null) {
            throw new AbortSearchException();
        }
        return this.buildActualNodes(ASTNodes.asList(actualStatement));
    }

    private ControlWorkflowNode buildActualNodes(List<Statement> actualStatements) {
        if (ControlWorkflowMatcher.isEmpty(actualStatements)) {
            throw new AbortSearchException();
        }
        IfStatement ifStatement = ASTNodes.as(actualStatements.get(0), IfStatement.class);
        ReturnStatement returnStatement = ASTNodes.as(actualStatements.get(0), ReturnStatement.class);
        if (ifStatement != null) {
            ControlWorkflowNode node = new ControlWorkflowNode();
            node.setCondition(ifStatement.getExpression());
            node.setThenNode(this.buildActualNodes(ifStatement.getThenStatement()));
            if (ifStatement.getElseStatement() != null && actualStatements.size() == 1) {
                node.setElseNode(this.buildActualNodes(ifStatement.getElseStatement()));
                return node;
            }
            if (ifStatement.getElseStatement() != null || actualStatements.size() == 1 || !ASTNodes.fallsThrough(ifStatement.getThenStatement())) {
                throw new AbortSearchException();
            }
            ArrayList<Statement> elseStmts = new ArrayList<Statement>(actualStatements);
            elseStmts.remove(0);
            node.setElseNode(this.buildActualNodes(elseStmts));
            return node;
        }
        if (returnStatement != null) {
            Expression condition = returnStatement.getExpression();
            return this.buildActualNodes(condition);
        }
        if (actualStatements.size() == 1) {
            ControlWorkflowNode node = new ControlWorkflowNode();
            node.setFinalStatement(actualStatements.get(0));
            return node;
        }
        throw new AbortSearchException();
    }

    private ControlWorkflowNode buildActualNodes(Expression condition) {
        ControlWorkflowNode actualNode = new ControlWorkflowNode();
        ConditionalExpression ternaryExpression = ASTNodes.as(condition, ConditionalExpression.class);
        if (ternaryExpression != null) {
            actualNode.setCondition(ternaryExpression.getExpression());
            actualNode.setThenNode(this.buildActualNodes(ternaryExpression.getThenExpression()));
            actualNode.setElseNode(this.buildActualNodes(ternaryExpression.getElseExpression()));
        } else {
            actualNode.setReturnedValue(condition);
        }
        return actualNode;
    }

    private static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    private class ControlWorkflowNode {
        private final int id;
        private Statement finalStatement;
        private Expression returnedValue;
        private Expression condition;
        private ControlWorkflowNode thenNode;
        private ControlWorkflowNode elseNode;

        private ControlWorkflowNode() {
            ControlWorkflowMatcher controlWorkflowMatcher2 = ControlWorkflowMatcher.this;
            int n = controlWorkflowMatcher2.idGenerator;
            controlWorkflowMatcher2.idGenerator = n + 1;
            this.id = n;
        }

        public Statement getFinalStatement() {
            return this.finalStatement;
        }

        public void setFinalStatement(Statement finalStatement) {
            this.finalStatement = finalStatement;
        }

        public Expression getReturnedValue() {
            return this.returnedValue;
        }

        public void setReturnedValue(Expression returnedValue) {
            this.returnedValue = returnedValue;
        }

        public Expression getCondition() {
            return this.condition;
        }

        public void setCondition(Expression condition) {
            this.condition = condition;
        }

        public ControlWorkflowNode getThenNode() {
            return this.thenNode;
        }

        public void setThenNode(ControlWorkflowNode thenNode) {
            this.thenNode = thenNode;
        }

        public ControlWorkflowNode getElseNode() {
            return this.elseNode;
        }

        public void setElseNode(ControlWorkflowNode elseNode) {
            this.elseNode = elseNode;
        }

        public int getId() {
            return this.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ControlWorkflowNode other = (ControlWorkflowNode)obj;
            return this.id == other.id;
        }
    }
}

