/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.loggerpropertyeditor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stem.core.logger.Logger;
import org.eclipse.stem.loggers.SimulationLogger;
import org.eclipse.stem.loggers.SimulationLoggerPackage;
import org.eclipse.stem.loggers.SynchronousDecoratorPropertyLogger;
import org.eclipse.stem.ui.adapters.loggerpropertyeditor.DecoratorPickerDialog;
import org.eclipse.stem.ui.adapters.loggerpropertyeditor.LoggerPropertyEditor;
import org.eclipse.stem.ui.adapters.loggerpropertyeditor.Messages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SimulationLoggerPropertyEditor
extends LoggerPropertyEditor {
    Set<String> selectedDecoratorProperties = new HashSet<String>();

    public SimulationLoggerPropertyEditor(Composite parent, int style, Logger logger, ModifyListener projectValidator, final IProject project) {
        super(parent, style, logger, projectValidator, project);
        if (logger instanceof SynchronousDecoratorPropertyLogger) {
            Label label = new Label((Composite)this, 0);
            label.setText(Messages.SLPE_CompartmentsToLog);
            GridData labelGD = new GridData(1);
            labelGD.grabExcessHorizontalSpace = true;
            labelGD.horizontalAlignment = 4;
            labelGD.horizontalIndent = 0;
            label.setLayoutData((Object)labelGD);
            Button selectDecoratorsButton = new Button((Composite)this, 8);
            selectDecoratorsButton.setText(Messages.SLPE_SelectCompartments);
            GridData textGD = new GridData(3);
            textGD.grabExcessHorizontalSpace = false;
            textGD.horizontalAlignment = 4;
            selectDecoratorsButton.setLayoutData((Object)textGD);
            selectDecoratorsButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    DecoratorPickerDialog lpDialog = new DecoratorPickerDialog(SimulationLoggerPropertyEditor.this.getShell(), 0, project, SimulationLoggerPropertyEditor.this.selectedDecoratorProperties);
                    if (lpDialog.open()) {
                        SimulationLoggerPropertyEditor.this.selectedDecoratorProperties = lpDialog.getSelectedProperties();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            Label labelSpacer = new Label((Composite)this, 0);
            labelSpacer.setText("");
            GridData labelSpacerGD = new GridData(3);
            labelSpacerGD.verticalAlignment = 2;
            labelSpacer.setLayoutData((Object)labelSpacerGD);
        }
    }

    public boolean isUserSpecifiedProperty(EStructuralFeature feature) {
        boolean retValue = false;
        EClass containingClass = feature.getEContainingClass();
        if (containingClass.equals(SimulationLoggerPackage.eINSTANCE.getSimulationLogger()) || containingClass.getEAllSuperTypes().contains((Object)SimulationLoggerPackage.eINSTANCE.getSimulationLogger())) {
            retValue = true;
        }
        if (feature.getName().equals("properties")) {
            retValue = false;
        }
        return retValue;
    }

    @Override
    public void populate(Logger logger) {
        super.populate(logger);
        if (logger instanceof SimulationLogger) {
            SimulationLogger obj = (SimulationLogger)logger;
            obj.setEnabled(((Button)this.booleanMap.get(SimulationLoggerPackage.Literals.SIMULATION_LOGGER__ENABLED)).getSelection());
            obj.setStepMod(Integer.parseInt(((Text)this.map.get(SimulationLoggerPackage.Literals.SIMULATION_LOGGER__STEP_MOD)).getText()));
            obj.setStartStep(Long.parseLong(((Text)this.map.get(SimulationLoggerPackage.Literals.SIMULATION_LOGGER__START_STEP)).getText()));
        }
        if (logger instanceof SynchronousDecoratorPropertyLogger) {
            ((SynchronousDecoratorPropertyLogger)logger).getProperties().clear();
            ((SynchronousDecoratorPropertyLogger)logger).getProperties().addAll(this.selectedDecoratorProperties);
        }
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        Text text = (Text)this.map.get(SimulationLoggerPackage.Literals.SIMULATION_LOGGER__START_STEP);
        if (text != null && (text.getText().equals("") || !this.isValidLongValue(text.getText(), 0L))) {
            this.errorMessage = Messages.SLPE_PropertyStartStep;
            return false;
        }
        text = (Text)this.map.get(SimulationLoggerPackage.Literals.SIMULATION_LOGGER__STEP_MOD);
        if (text != null && (text.getText().equals("") || !this.isValidIntValue(text.getText(), 1))) {
            this.errorMessage = Messages.SLPE_PropertyStepMod;
            return false;
        }
        return true;
    }
}

