/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.internal.junit.JUnitCorePlugin;
import org.eclipse.jdt.internal.junit.launcher.ITestFinder;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitRuntimeClasspathEntry;

public class TestKind
implements ITestKind {
    private final IConfigurationElement fElement;
    private ITestFinder fFinder;

    public TestKind(IConfigurationElement element) {
        this.fElement = element;
        this.fFinder = null;
    }

    @Override
    public ITestFinder getFinder() {
        if (this.fFinder == null) {
            try {
                this.fFinder = (ITestFinder)this.fElement.createExecutableExtension("finderClass");
            }
            catch (CoreException e1) {
                JUnitCorePlugin.log(e1);
                this.fFinder = ITestFinder.NULL;
            }
        }
        return this.fFinder;
    }

    @Override
    public String getDisplayName() {
        return this.getAttribute("displayName");
    }

    @Override
    public String getFinderClassName() {
        return this.getAttribute("finderClass");
    }

    @Override
    public String getId() {
        return this.getAttribute("id");
    }

    @Override
    public String getLoaderClassName() {
        return this.getAttribute("loaderClass");
    }

    @Override
    public String getLoaderPluginId() {
        return this.getAttribute("loaderPluginId");
    }

    @Override
    public String getPrecededKindId() {
        String attribute = this.getAttribute("precedesTestKind");
        return attribute == null ? "" : attribute;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    protected String getAttribute(String attributeName) {
        return this.fElement.getAttribute(attributeName);
    }

    boolean precedes(ITestKind otherKind) {
        String precededKindId = this.getPrecededKindId();
        String[] ids = precededKindId.split(",");
        int i = 0;
        while (i < ids.length) {
            if (ids[i].equals(otherKind.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public JUnitRuntimeClasspathEntry[] getClasspathEntries() {
        IConfigurationElement[] children = this.fElement.getChildren("runtimeClasspathEntry");
        JUnitRuntimeClasspathEntry[] returnThis = new JUnitRuntimeClasspathEntry[children.length];
        int i = 0;
        while (i < children.length) {
            IConfigurationElement element = children[i];
            String pluginID = element.getAttribute("pluginId");
            String pathToJar = element.getAttribute("pathToJar");
            returnThis[i] = new JUnitRuntimeClasspathEntry(pluginID, pathToJar);
            ++i;
        }
        return returnThis;
    }

    public String toString() {
        return String.valueOf(this.getDisplayName()) + " (id: " + this.getId() + ")";
    }
}

