/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphgenerators.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.definitions.lattice.impl.LatticeGeneratorUtilityImpl;
import org.eclipse.stem.graphgenerators.GraphgeneratorsPackage;
import org.eclipse.stem.graphgenerators.PlateCarreeGlobeGraphGenerator;
import org.eclipse.stem.graphgenerators.impl.LatticeGraphGeneratorImpl;

public class PlateCarreeGlobeGraphGeneratorImpl
extends LatticeGraphGeneratorImpl
implements PlateCarreeGlobeGraphGenerator {
    protected static final int ANGULAR_STEP_EDEFAULT = 10;
    protected int angularStep = 10;
    protected static final double RADIUS_EDEFAULT = 6371.0;
    protected double radius = 6371.0;

    @Override
    protected EClass eStaticClass() {
        return GraphgeneratorsPackage.Literals.PLATE_CARREE_GLOBE_GRAPH_GENERATOR;
    }

    @Override
    public Graph getGraph() {
        LatticeGeneratorUtilityImpl slgi = new LatticeGeneratorUtilityImpl("Plate Carree");
        Graph g = slgi.getPlateCareeGraph(this.getAngularStep(), this.getRadius(), this.isUseNearestNeighbors(), this.isUseNextNearestNeighbors(), this.isPeriodicBoundaries());
        return g;
    }

    @Override
    public int getAngularStep() {
        return this.angularStep;
    }

    @Override
    public void setAngularStep(int newAngularStep) {
        int oldAngularStep = this.angularStep;
        this.angularStep = newAngularStep;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldAngularStep, this.angularStep));
        }
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(double newRadius) {
        double oldRadius = this.radius;
        this.radius = newRadius;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldRadius, this.radius));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getAngularStep();
            }
            case 7: {
                return this.getRadius();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setAngularStep((Integer)newValue);
                return;
            }
            case 7: {
                this.setRadius((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setAngularStep(10);
                return;
            }
            case 7: {
                this.setRadius(6371.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return this.angularStep != 10;
            }
            case 7: {
                return this.radius != 6371.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (angularStep: ");
        result.append(this.angularStep);
        result.append(", radius: ");
        result.append(this.radius);
        result.append(')');
        return result.toString();
    }
}

