/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.adapters.history;

import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.stem.adapters.history.HistoryExtendedListener;
import org.eclipse.stem.adapters.history.HistoryProvider;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.ResettableAdapter;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.core.model.STEMTime;

public class HistoryProviderAdapter
extends AdapterImpl
implements HistoryProvider,
ResettableAdapter {
    private List<HistoryExtendedListener> extensionListeners = new CopyOnWriteArrayList<HistoryExtendedListener>();
    private int earliestCycleNumber = 0;

    @Override
    public Identifiable getInstance(STEMTime time) {
        return (Identifiable)this.getTarget();
    }

    @Override
    public Identifiable[] getAllHistoricInstances() {
        return new Identifiable[0];
    }

    @Override
    public Identifiable[] getHistoricInstances(STEMTime[] timeRange) {
        return new Identifiable[timeRange.length];
    }

    @Override
    public STEMTime[] getAllHistoricTimeValues() {
        return new STEMTime[0];
    }

    @Override
    public int getEarliestCycleNumber() {
        return this.earliestCycleNumber;
    }

    @Override
    public void reset() {
        this.fireHistoryExtended();
    }

    @Override
    public STEMTime getEarliestTimeValue() {
        STEMTime retValue = ModelFactory.eINSTANCE.createSTEMTime();
        retValue.setTime(new Date());
        return retValue;
    }

    public boolean isAdapterForType(Object type) {
        return type == HistoryProvider.class;
    }

    public void addExtensionListener(HistoryExtendedListener listener) {
        this.extensionListeners.add(listener);
    }

    public void removeExtensionListener(HistoryExtendedListener listener) {
        this.extensionListeners.remove(listener);
    }

    protected void fireHistoryExtended() {
        for (HistoryExtendedListener listener : this.extensionListeners) {
            listener.historyExtended(this);
        }
    }
}

